/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests.integration.utils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.pulsar.tests.integration.docker.ContainerExecException;
import org.apache.pulsar.tests.integration.docker.ContainerExecResult;
import org.apache.pulsar.tests.integration.docker.ContainerExecResultBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DockerUtils.class);

    private static File getTargetDirectory(String containerId) {
        File directory;
        String base = System.getProperty("maven.buildDirectory");
        if (base == null) {
            base = "target";
        }
        if (!(directory = new File(base + "/container-logs/" + containerId)).exists() && !directory.mkdirs()) {
            LOG.error("Error creating directory for container logs.");
        }
        return directory;
    }

    public static void dumpContainerLogToTarget(DockerClient dockerClient, String containerId) {
        String containerName = DockerUtils.getContainerName(dockerClient, containerId);
        File output = DockerUtils.getUniqueFileInTargetDirectory(containerName, "docker", ".log");
        try (final BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(output));){
            final CompletableFuture future = new CompletableFuture();
            dockerClient.logContainerCmd(containerName).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withTimestamps(Boolean.valueOf(true)).exec((ResultCallback)new ResultCallback<Frame>(){

                public void close() {
                }

                public void onStart(Closeable closeable) {
                }

                public void onNext(Frame object) {
                    try {
                        os.write(object.getPayload());
                    }
                    catch (IOException e) {
                        this.onError(e);
                    }
                }

                public void onError(Throwable throwable) {
                    future.completeExceptionally(throwable);
                }

                public void onComplete() {
                    future.complete(true);
                }
            });
            future.get();
        }
        catch (IOException | RuntimeException | ExecutionException e) {
            LOG.error("Error dumping log for {}", (Object)containerName, (Object)e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted dumping log from container {}", (Object)containerName, (Object)ie);
        }
    }

    private static File getUniqueFileInTargetDirectory(String containerName, String prefix, String suffix) {
        return DockerUtils.getUniqueFileInDirectory(DockerUtils.getTargetDirectory(containerName), prefix, suffix);
    }

    private static File getUniqueFileInDirectory(File directory, String prefix, String suffix) {
        File file = new File(directory, prefix + suffix);
        int i = 0;
        while (file.exists()) {
            LOG.info("{} exists, incrementing", (Object)file);
            file = new File(directory, prefix + "_" + i++ + suffix);
        }
        return file;
    }

    private static String getContainerName(DockerClient dockerClient, String containerId) {
        InspectContainerResponse inspectContainerResponse = dockerClient.inspectContainerCmd(containerId).exec();
        return inspectContainerResponse.getName().replace("/", "");
    }

    public static void dumpContainerDirToTargetCompressed(DockerClient dockerClient, String containerId, String path) {
        block13: {
            String containerName = DockerUtils.getContainerName(dockerClient, containerId);
            String baseName = path.replace("/", "-").replaceAll("^-", "");
            File output = DockerUtils.getUniqueFileInTargetDirectory(containerName, baseName, ".tar.gz");
            try (InputStream dockerStream = dockerClient.copyArchiveFromContainerCmd(containerId, path).exec();
                 GZIPOutputStream os = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(output)));){
                IOUtils.copy((InputStream)dockerStream, (OutputStream)os);
            }
            catch (IOException | RuntimeException e) {
                if (e instanceof NotFoundException) break block13;
                LOG.error("Error reading dir from container {}", (Object)containerName, (Object)e);
            }
        }
    }

    public static void dumpContainerLogDirToTarget(DockerClient docker, String containerId, String path) {
        File targetDirectory = DockerUtils.getTargetDirectory(containerId);
        try (InputStream dockerStream = docker.copyArchiveFromContainerCmd(containerId, path).exec();
             TarArchiveInputStream stream = new TarArchiveInputStream(dockerStream);){
            TarArchiveEntry entry = stream.getNextTarEntry();
            while (entry != null) {
                if (entry.isFile()) {
                    File output = new File(targetDirectory, entry.getName().replace("/", "-"));
                    Files.copy((InputStream)stream, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                entry = stream.getNextTarEntry();
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error reading logs from container {}", (Object)containerId, (Object)e);
        }
    }

    public static String getContainerIP(DockerClient docker, String containerId) {
        Iterator iterator = docker.inspectContainerCmd(containerId).exec().getNetworkSettings().getNetworks().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            return ((ContainerNetwork)e.getValue()).getIpAddress();
        }
        throw new IllegalArgumentException("Container " + containerId + " has no networks");
    }

    public static ContainerExecResult runCommand(DockerClient docker, String containerId, String ... cmd) throws ContainerExecException, ExecutionException, InterruptedException {
        try {
            return DockerUtils.runCommandAsync(docker, containerId, cmd).get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ContainerExecException) {
                throw (ContainerExecException)e.getCause();
            }
            throw e;
        }
    }

    public static ContainerExecResult runCommandAsUser(String userId, DockerClient docker, String containerId, String ... cmd) throws ContainerExecException, ExecutionException, InterruptedException {
        try {
            return DockerUtils.runCommandAsyncAsUser(userId, docker, containerId, cmd).get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ContainerExecException) {
                throw (ContainerExecException)e.getCause();
            }
            throw e;
        }
    }

    public static CompletableFuture<ContainerExecResult> runCommandAsyncAsUser(String userId, DockerClient dockerClient, String containerId, String ... cmd) {
        String execId = ((ExecCreateCmdResponse)dockerClient.execCreateCmd(containerId).withCmd(cmd).withAttachStderr(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).withUser(userId).exec()).getId();
        return DockerUtils.runCommandAsync(execId, dockerClient, containerId, cmd);
    }

    public static CompletableFuture<ContainerExecResult> runCommandAsync(DockerClient dockerClient, String containerId, String ... cmd) {
        String execId = ((ExecCreateCmdResponse)dockerClient.execCreateCmd(containerId).withCmd(cmd).withAttachStderr(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).exec()).getId();
        return DockerUtils.runCommandAsync(execId, dockerClient, containerId, cmd);
    }

    private static CompletableFuture<ContainerExecResult> runCommandAsync(final String execId, final DockerClient dockerClient, final String containerId, String ... cmd) {
        final CompletableFuture<ContainerExecResult> future = new CompletableFuture<ContainerExecResult>();
        final String containerName = DockerUtils.getContainerName(dockerClient, containerId);
        final String cmdString = String.join((CharSequence)" ", cmd);
        final StringBuilder stdout = new StringBuilder();
        final StringBuilder stderr = new StringBuilder();
        dockerClient.execStartCmd(execId).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ResultCallback<Frame>(){

            public void close() {
            }

            public void onStart(Closeable closeable) {
                LOG.info("DOCKER.exec({}:{}): Executing...", (Object)containerName, (Object)cmdString);
            }

            public void onNext(Frame object) {
                LOG.info("DOCKER.exec({}:{}): {}", new Object[]{containerName, cmdString, object});
                if (StreamType.STDOUT == object.getStreamType()) {
                    stdout.append(new String(object.getPayload(), StandardCharsets.UTF_8));
                } else if (StreamType.STDERR == object.getStreamType()) {
                    stderr.append(new String(object.getPayload(), StandardCharsets.UTF_8));
                }
            }

            public void onError(Throwable throwable) {
                future.completeExceptionally(throwable);
            }

            public void onComplete() {
                LOG.info("DOCKER.exec({}:{}): Done", (Object)containerName, (Object)cmdString);
                InspectExecResponse resp = DockerUtils.waitForExecCmdToFinish(dockerClient, execId);
                int retCode = resp.getExitCode();
                ContainerExecResult result = ContainerExecResult.of(retCode, stdout.toString(), stderr.toString());
                LOG.info("DOCKER.exec({}:{}): completed with {}", new Object[]{containerName, cmdString, retCode});
                if (retCode != 0) {
                    LOG.error("DOCKER.exec({}:{}): completed with non zero return code: {}\nstdout: {}\nstderr: {}", new Object[]{containerName, cmdString, result.getExitCode(), result.getStdout(), result.getStderr()});
                    future.completeExceptionally(new ContainerExecException(cmdString, containerId, result));
                } else {
                    future.complete(result);
                }
            }
        });
        return future;
    }

    public static ContainerExecResultBytes runCommandWithRawOutput(DockerClient dockerClient, String containerId, String ... cmd) throws ContainerExecException {
        final CompletableFuture future = new CompletableFuture();
        String execId = ((ExecCreateCmdResponse)dockerClient.execCreateCmd(containerId).withCmd(cmd).withAttachStderr(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).exec()).getId();
        final String containerName = DockerUtils.getContainerName(dockerClient, containerId);
        final String cmdString = String.join((CharSequence)" ", cmd);
        final ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        final ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        dockerClient.execStartCmd(execId).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ResultCallback<Frame>(){

            public void close() {
            }

            public void onStart(Closeable closeable) {
                LOG.info("DOCKER.exec({}:{}): Executing...", (Object)containerName, (Object)cmdString);
            }

            public void onNext(Frame object) {
                try {
                    if (StreamType.STDOUT == object.getStreamType()) {
                        stdout.write(object.getPayload());
                    } else if (StreamType.STDERR == object.getStreamType()) {
                        stderr.write(object.getPayload());
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public void onError(Throwable throwable) {
                future.completeExceptionally(throwable);
            }

            public void onComplete() {
                LOG.info("DOCKER.exec({}:{}): Done", (Object)containerName, (Object)cmdString);
                future.complete(true);
            }
        });
        future.join();
        InspectExecResponse resp = DockerUtils.waitForExecCmdToFinish(dockerClient, execId);
        int retCode = resp.getExitCode();
        ContainerExecResultBytes result = ContainerExecResultBytes.of(retCode, stdout.toByteArray(), stderr.toByteArray());
        LOG.info("DOCKER.exec({}:{}): completed with {}", new Object[]{containerName, cmdString, retCode});
        if (retCode != 0) {
            throw new ContainerExecException(cmdString, containerId, null);
        }
        return result;
    }

    public static CompletableFuture<Integer> runCommandAsyncWithLogging(final DockerClient dockerClient, String containerId, String ... cmd) {
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        final String execId = ((ExecCreateCmdResponse)dockerClient.execCreateCmd(containerId).withCmd(cmd).withAttachStderr(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).exec()).getId();
        final String containerName = DockerUtils.getContainerName(dockerClient, containerId);
        final String cmdString = String.join((CharSequence)" ", cmd);
        dockerClient.execStartCmd(execId).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ResultCallback<Frame>(){

            public void close() {
            }

            public void onStart(Closeable closeable) {
                LOG.info("DOCKER.exec({}:{}): Executing...", (Object)containerName, (Object)cmdString);
            }

            public void onNext(Frame object) {
                LOG.info("DOCKER.exec({}:{}): {}", new Object[]{containerName, cmdString, object});
            }

            public void onError(Throwable throwable) {
                future.completeExceptionally(throwable);
            }

            public void onComplete() {
                LOG.info("DOCKER.exec({}:{}): Done", (Object)containerName, (Object)cmdString);
                InspectExecResponse resp = DockerUtils.waitForExecCmdToFinish(dockerClient, execId);
                int retCode = resp.getExitCode();
                LOG.info("DOCKER.exec({}:{}): completed with {}", new Object[]{containerName, cmdString, retCode});
                future.complete(retCode);
            }
        });
        return future;
    }

    private static InspectExecResponse waitForExecCmdToFinish(DockerClient dockerClient, String execId) {
        InspectExecResponse resp = dockerClient.inspectExecCmd(execId).exec();
        while (resp.isRunning().booleanValue()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
            resp = dockerClient.inspectExecCmd(execId).exec();
        }
        return resp;
    }

    public static Optional<String> getContainerCluster(DockerClient docker, String containerId) {
        return Optional.ofNullable((String)docker.inspectContainerCmd(containerId).exec().getConfig().getLabels().get("cluster"));
    }
}

