/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.parser.Swagger20Parser;
import io.swagger.parser.SwaggerParserExtension;
import io.swagger.parser.SwaggerResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class SwaggerParser {
    public Swagger read(String location) {
        return this.read(location, null, true);
    }

    public Swagger read(String location, List<AuthorizationValue> auths, boolean resolve) {
        Swagger output;
        if (location == null) {
            return null;
        }
        List<SwaggerParserExtension> parserExtensions = this.getExtensions();
        try {
            output = new Swagger20Parser().read(location, auths);
            if (output != null) {
                return new SwaggerResolver().resolve(output, auths);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        for (SwaggerParserExtension extension : parserExtensions) {
            try {
                output = extension.read(location, auths);
                if (output == null) continue;
                return output;
            }
            catch (IOException e) {
                if (System.getProperty("debugParser") == null) continue;
                e.printStackTrace();
            }
        }
        return null;
    }

    public Swagger parse(String swaggerAsString) {
        return this.parse(swaggerAsString, null);
    }

    public Swagger parse(String swaggerAsString, List<AuthorizationValue> auths) {
        try {
            Swagger output = new Swagger20Parser().parse(swaggerAsString);
            if (output != null) {
                return new SwaggerResolver().resolve(output, auths);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public Swagger read(JsonNode node) {
        return this.read(node, false);
    }

    public Swagger read(JsonNode node, boolean resolve) {
        if (node == null) {
            return null;
        }
        List<SwaggerParserExtension> parserExtensions = this.getExtensions();
        Swagger output = null;
        try {
            output = new Swagger20Parser().read(node);
            if (output != null) {
                if (resolve) {
                    return new SwaggerResolver().resolve(output, new ArrayList<AuthorizationValue>());
                }
                return output;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        for (SwaggerParserExtension extension : parserExtensions) {
            try {
                output = extension.read(node);
                if (output == null) continue;
                return output;
            }
            catch (IOException e) {
                if (System.getProperty("debugParser") == null) continue;
                e.printStackTrace();
            }
        }
        return null;
    }

    public List<SwaggerParserExtension> getExtensions() {
        ServiceLoader<SwaggerParserExtension> loader = ServiceLoader.load(SwaggerParserExtension.class);
        ArrayList<SwaggerParserExtension> output = new ArrayList<SwaggerParserExtension>();
        Iterator<SwaggerParserExtension> itr = loader.iterator();
        while (itr.hasNext()) {
            output.add(itr.next());
        }
        return output;
    }
}

