/*
 * Copyright (C) 2016 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.syndesis.model;

import java.util.stream.IntStream;
import java.util.stream.Stream;

import org.junit.Test;

import static org.assertj.core.api.Assertions.assertThat;

public class ListResultTest {

    @Test
    public void shouldCollectFromEmptyStream() {
        final ListResult<Object> collected = Stream.of().collect(ListResult.collector()).build();
        assertThat(collected).isNotNull();
        assertThat(collected.getItems()).isEmpty();
    }

    @Test
    public void shouldCollectFromSingletonStream() {
        final ListResult<String> collected = Stream.of("item").collect(ListResult.collector()).build();
        assertThat(collected).isNotNull();
        assertThat(collected.getItems()).containsExactly("item");
    }

    @Test
    public void shouldCollectFromStreamWithSomeElements() {
        final ListResult<String> collected = IntStream.range(1, 11).mapToObj(String::valueOf)
            .collect(ListResult.collector()).build();
        assertThat(collected).isNotNull();
        assertThat(collected.getItems()).containsExactly("1", "2", "3", "4", "5", "6", "7", "8", "9", "10");
    }
}
