/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.IArtifactMetadata;
import io.takari.builder.internal.ArtifactResourceURLStreamHandler;
import io.takari.builder.internal.TestInputBuilder;
import io.takari.builder.internal.utils.JarBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ArtifactResourceURLStreamHandlerTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    File newDirArtifact(String ... entries) throws IOException {
        File dir = this.temp.newFolder();
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            Files.createFile(dir.toPath().resolve(entry), new FileAttribute[0]);
            ++n2;
        }
        return dir;
    }

    File newJarArtifact(String ... entries) throws IOException {
        return JarBuilder.create((File)this.temp.newFile()).withEntries(entries).build();
    }

    @Test
    public void testEquals() throws Exception {
        String relpath = "file.txt";
        TestInputBuilder.TestArtifactMetadata artifactA = new TestInputBuilder.TestArtifactMetadata("g:a:1");
        File dirA = this.newDirArtifact(relpath);
        URL resourceA = new File(dirA, relpath).toURI().toURL();
        TestInputBuilder.TestArtifactMetadata artifactB = new TestInputBuilder.TestArtifactMetadata("g:b:1");
        File dirB = this.newDirArtifact(relpath);
        URL resourceB = new File(dirB, relpath).toURI().toURL();
        Assertions.assertThat((File)dirA).isNotEqualTo((Object)dirB);
        URL urlA = ArtifactResourceURLStreamHandler.newURL((IArtifactMetadata)artifactA, (String)relpath, (URL)resourceA);
        URL urlB = ArtifactResourceURLStreamHandler.newURL((IArtifactMetadata)artifactB, (String)relpath, (URL)resourceB);
        Assertions.assertThat((boolean)urlA.equals(urlB)).isFalse();
    }
}

