/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.ArtifactResources;
import io.takari.builder.ResolutionScope;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.TestInputBuilder;
import io.takari.builder.internal.utils.JarBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class ArtifactResourcesInputTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    File newJarArtifact(String ... entries) throws IOException {
        return JarBuilder.create((File)this.temp.newFile()).withEntries(entries).build();
    }

    @Test
    public void testArtifactResource() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(".resources: is required");
        File dependency = this.newJarArtifact("test.xml");
        TestInputBuilder builder = TestInputBuilder.builder().withDependency("g:a", dependency);
        builder.build(_ListArtifactResourcesData.class, "resources");
    }

    @Test
    public void testArtifactResourceWithConfiguration() throws Exception {
        File dependency = this.newJarArtifact("test.xml");
        TestInputBuilder builder = TestInputBuilder.builder().withConfigurationXml("<resources><artifact><groupId>g</groupId><artifactId>a</artifactId></artifact><include>test.xml</include></resources>").withDependency("g:a", dependency);
        List value = (List)builder.build(_ListArtifactResourcesData.class, "resources").value();
        Assertions.assertThat((List)value).hasSize(1);
        Assertions.assertThat((String)((URL)value.get(0)).getPath()).isEqualTo((Object)"test.xml");
    }

    @Test
    public void testNonRequiredArtifactResource() throws Exception {
        File dependency = this.newJarArtifact("test.xml");
        TestInputBuilder builder = TestInputBuilder.builder().withDependency("g:a", dependency);
        Assertions.assertThat((builder.build(_ListNonRequiredArtifactResourcesData.class, "resources") == null ? 1 : 0) != 0);
    }

    @Test
    public void testNonRequiredArtifactResourceWithConfiguration() throws Exception {
        File dependency = this.newJarArtifact("test.xml");
        TestInputBuilder builder = TestInputBuilder.builder().withConfigurationXml("<resources><artifact><groupId>g</groupId><artifactId>a</artifactId></artifact><include>test.xml</include></resources>").withDependency("g:a", dependency);
        List value = (List)builder.build(_ListNonRequiredArtifactResourcesData.class, "resources").value();
        Assertions.assertThat((List)value).hasSize(1);
        Assertions.assertThat((String)((URL)value.get(0)).getPath()).isEqualTo((Object)"test.xml");
    }

    static class _ListArtifactResourcesData {
        @ArtifactResources(resourcesRequired=true, scope=ResolutionScope.COMPILE)
        List<URL> resources;

        _ListArtifactResourcesData() {
        }
    }

    static class _ListNonRequiredArtifactResourcesData {
        @ArtifactResources(scope=ResolutionScope.COMPILE)
        List<URL> resources;

        _ListNonRequiredArtifactResourcesData() {
        }
    }
}

