/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.Parameter;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.TestInputBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BasicInputTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testPrivateParameter() throws Exception {
        BuilderInputs.StringValue input = (BuilderInputs.StringValue)TestInputBuilder.builder().build(_PrivateParameterData.class, "parameter");
        Assert.assertEquals((Object)"default-value", (Object)input.configuration);
    }

    @Test
    public void testReadonlyParameter() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        TestInputBuilder.builder().withConfigurationXml("<parameter>readonly-value</parameter>").build(_ReadonlyParameterData.class, "parameter");
    }

    @Test
    public void testOptionalParameter() throws Exception {
        Assert.assertNull(TestInputBuilder.builder().build(_OptionalParameterData.class, "parameter"));
    }

    static class _OptionalParameterData {
        @Parameter(required=false)
        public String parameter = "";

        _OptionalParameterData() {
        }
    }

    static class _PrivateParameterData {
        @Parameter(defaultValue={"default-value"})
        private String parameter;

        _PrivateParameterData() {
        }
    }

    static class _ReadonlyParameterData {
        @Parameter(value={"explicit-value"})
        public String parameter;

        _ReadonlyParameterData() {
        }
    }
}

