/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.enforcer.internal.EnforcerViolation;
import io.takari.builder.enforcer.internal.EnforcerViolationType;
import io.takari.builder.internal.BuilderContext;
import io.takari.builder.internal.BuilderWorkspace;
import io.takari.builder.internal.workspace.FilesystemWorkspace;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class BuilderContextPolicyTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    private BuilderContext.Builder newBuilder() {
        return BuilderContext.builder((Logger)NOPLogger.NOP_LOGGER, (String)"test", (Path)this.temp.getRoot().toPath(), null, (BuilderWorkspace)new BuilderWorkspace((Workspace)new FilesystemWorkspace(), this.temp.getRoot().toPath(), null));
    }

    @Test
    public void testExecFails() throws Exception {
        BuilderContext ctx = this.newBuilder().build();
        new BuilderContext.BuilderContextPolicy(ctx).checkExec("git");
        Assertions.assertThat((Iterable)ctx.getViolations()).hasSize(1);
        Assertions.assertThat((Comparable)((EnforcerViolation)ctx.getViolations().iterator().next()).getViolationType()).isEqualTo((Object)EnforcerViolationType.EXECUTE);
    }

    @Test(expected=SecurityException.class)
    public void testPropertyUnknownAction() throws Exception {
        BuilderContext ctx = this.newBuilder().build();
        new BuilderContext.BuilderContextPolicy(ctx).checkPropertyPermission("non-existent", "property");
    }

    @Test
    public void testPropertyRead() {
        BuilderContext ctx = this.newBuilder().build();
        new BuilderContext.BuilderContextPolicy(ctx).checkPropertyPermission("read", "property");
        Assertions.assertThat((Iterable)ctx.getReadProperties()).containsOnly((Object[])new String[]{"property"});
    }

    @Test
    public void testPropertyWrite() {
        BuilderContext ctx = this.newBuilder().build();
        new BuilderContext.BuilderContextPolicy(ctx).checkPropertyPermission("write", "property");
        Assertions.assertThat((Iterable)ctx.getReadProperties()).isEmpty();
    }

    @Test
    public void testPropertyReadWrite() {
        BuilderContext ctx = this.newBuilder().build();
        new BuilderContext.BuilderContextPolicy(ctx).checkPropertyPermission("read,write", "property");
        Assertions.assertThat((Iterable)ctx.getReadProperties()).containsOnly((Object[])new String[]{"property"});
    }

    @Test
    public void testReadExistingFails() throws Exception {
        BuilderContext ctx = this.newBuilder().build();
        File file = this.temp.newFile();
        new BuilderContext.BuilderContextPolicy(ctx).checkRead(file.getAbsolutePath());
        Assertions.assertThat((Iterable)ctx.getViolations()).hasSize(1);
        Assertions.assertThat((Comparable)((EnforcerViolation)ctx.getViolations().iterator().next()).getViolationType()).isEqualTo((Object)EnforcerViolationType.READ);
    }

    @Test(expected=SecurityException.class)
    public void testSocketPermFailure() throws Exception {
        BuilderContext ctx = this.newBuilder().build();
        new BuilderContext.BuilderContextPolicy(ctx).checkSocketPermission();
    }

    @Test
    public void testWriteFails() throws Exception {
        BuilderContext ctx = this.newBuilder().build();
        new BuilderContext.BuilderContextPolicy(ctx).checkWrite("/some/directory");
        Assertions.assertThat((Iterable)ctx.getViolations()).hasSize(1);
        Assertions.assertThat((Comparable)((EnforcerViolation)ctx.getViolations().iterator().next()).getViolationType()).isEqualTo((Object)EnforcerViolationType.WRITE);
    }

    @Test
    public void testExecPasses() throws Exception {
        BuilderContext ctx = this.newBuilder().addExecExceptions(Arrays.asList("p4")).build();
        new BuilderContext.BuilderContextPolicy(ctx).checkExec("p4");
        Assertions.assertThat((Iterable)ctx.getViolations()).hasSize(0);
    }
}

