/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.enforcer.ComposableSecurityManagerPolicy;
import io.takari.builder.enforcer.PolicyContextPreserver;
import io.takari.builder.internal.BuilderContext;
import io.takari.builder.internal.BuilderWorkspace;
import io.takari.builder.internal.workspace.FilesystemWorkspace;
import io.takari.incrementalbuild.workspace.Workspace;
import io.takari.maven.testing.TestResources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class BuilderContextTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    private BuilderContext.Builder newBuilder() {
        return BuilderContext.builder((Logger)NOPLogger.NOP_LOGGER, (String)"test", (Path)this.temp.getRoot().toPath(), null, (BuilderWorkspace)new BuilderWorkspace((Workspace)new FilesystemWorkspace(), this.temp.getRoot().toPath(), null));
    }

    @Test
    public void testReadNonExistingFiles() throws Exception {
        File basedir = this.temp.getRoot();
        BuilderContext testee = this.newBuilder().build();
        Assert.assertTrue((boolean)testee.checkRead(new File(basedir, "file/does/not/exist").getAbsolutePath()));
    }

    @Test
    public void testReadAfterWrite() throws Exception {
        File basedir = this.temp.getRoot();
        BuilderContext testee = this.newBuilder().addOutputDirectory(basedir.toPath()).build();
        File file = new File(basedir, "file").getCanonicalFile();
        Assert.assertTrue((boolean)testee.checkAndRecordWrite(file.getAbsolutePath()));
        Files.createFile(file.toPath(), new FileAttribute[0]);
        Assert.assertTrue((boolean)testee.checkRead(file.getAbsolutePath()));
    }

    @Test
    public void testReadDirectories() throws Exception {
        File basedir = this.temp.newFolder();
        File file = new File(basedir, "1.txt");
        file.createNewFile();
        BuilderContext testee = this.newBuilder().addInputFile(file.toPath()).build();
        Assert.assertTrue((boolean)testee.checkRead(file.getParent()));
    }

    @Test
    public void testWriteExistingFiles() throws Exception {
        File output = this.temp.newFolder();
        BuilderContext testee = this.newBuilder().addOutputDirectory(output.toPath()).build();
        TestResources.create((File)output, (String[])new String[]{"a"});
        Assert.assertFalse((boolean)testee.checkAndRecordWrite(new File(output, "a").getAbsolutePath()));
    }

    @Test
    public void testWriteMultipleTimes() throws Exception {
        File output = this.temp.newFolder();
        BuilderContext testee = this.newBuilder().addOutputDirectory(output.toPath()).build();
        File file = new File(output, "a").getAbsoluteFile();
        Assert.assertTrue((boolean)testee.checkAndRecordWrite(file.getAbsolutePath()));
        Assert.assertTrue((boolean)file.createNewFile());
        Assert.assertTrue((boolean)testee.checkAndRecordWrite(file.getAbsolutePath()));
    }

    @Test
    public void testExcludesRoot() throws Exception {
        BuilderContext testee = this.newBuilder().addInputFile(this.temp.newFile().toPath()).addOutputDirectory(this.temp.newFolder().toPath()).build();
        File file = new File(this.temp.getRoot(), "1.txt");
        file.createNewFile();
        Assert.assertFalse((boolean)testee.checkRead(file.getAbsolutePath()));
        Assert.assertFalse((boolean)testee.checkAndRecordWrite(file.getAbsolutePath()));
    }

    @Test
    public void testCreateExistingOutputDirectory() throws Exception {
        File dir = this.temp.newFolder().getCanonicalFile();
        BuilderContext testee = this.newBuilder().addOutputDirectory(dir.toPath()).build();
        Assert.assertTrue((boolean)testee.checkAndRecordWrite(dir.getCanonicalPath()));
    }

    @Test
    public void testExec() throws Exception {
        BuilderContext testee = this.newBuilder().addExecExceptions(Arrays.asList("git")).build();
        Assert.assertTrue((boolean)testee.checkExec("git"));
    }

    @Test
    public void testNetworkAccess() throws Exception {
        BuilderContext testee = this.newBuilder().setNetworkAccessAllowed(true).build();
        Assert.assertTrue((boolean)testee.checkSockets());
    }

    @Test
    public void testReadExceptions() throws Exception {
        File basedir = this.temp.getRoot();
        File test = new File(basedir, "test.txt");
        File notest = new File(basedir, "notest.txt");
        test.createNewFile();
        notest.createNewFile();
        BuilderContext testee = this.newBuilder().addReadExceptions(Arrays.asList("**/test.txt")).build();
        Assert.assertTrue((boolean)testee.checkRead(test.getCanonicalPath()));
        Assert.assertFalse((boolean)testee.checkRead(notest.getCanonicalPath()));
    }

    @Test
    public void testDirectoryReadExceptions() throws Exception {
        File basedir = this.temp.getRoot();
        File test = new File(basedir, "test");
        File testFile = new File(test, "file.txt");
        test.mkdir();
        testFile.createNewFile();
        BuilderContext testee = this.newBuilder().addReadExceptions(Arrays.asList("**/test/**")).build();
        Assert.assertTrue((boolean)testee.checkRead(testFile.getCanonicalPath()));
    }

    @Test
    public void testExtensionsReadExceptions() throws Exception {
        File basedir = this.temp.getRoot();
        File test = new File(basedir, "test");
        File testFile = new File(test, "file.txt.hello");
        File noTestFile = new File(test, "file.txt");
        test.mkdir();
        testFile.createNewFile();
        noTestFile.createNewFile();
        BuilderContext testee = this.newBuilder().addReadExceptions(Arrays.asList("**/test/file.txt.*")).build();
        Assert.assertTrue((boolean)testee.checkRead(testFile.getCanonicalPath()));
        Assert.assertFalse((boolean)testee.checkRead(noTestFile.getCanonicalPath()));
    }

    @Test
    public void testConcurrentReadWriteCheck() throws Exception {
        File dir = this.temp.newFolder().getCanonicalFile();
        BuilderContext ctx = this.newBuilder().addOutputDirectory(dir.toPath()).build();
        AtomicInteger fileNo = new AtomicInteger();
        AtomicReference failed = new AtomicReference();
        CyclicBarrier barrier = new CyclicBarrier(32, () -> {
            int no = fileNo.incrementAndGet();
            if (failed.get() != null) {
                throw new RuntimeException("file " + no + ": " + (String)failed.get());
            }
        });
        Runnable r = () -> {
            block9: {
                while (true) {
                    int no = fileNo.get();
                    if (no < 1000) {
                        File file2 = new File(dir, Integer.toString(no));
                        try {
                            barrier.await();
                            String path = file2.getCanonicalPath();
                            if (!ctx.checkRead(path)) {
                                failed.set("!ctx.checkRead");
                            }
                            if (!ctx.checkAndRecordWrite(path)) {
                                failed.set("!ctx.checkAndRecordWrite");
                            }
                            new FileOutputStream(file2).close();
                            if (file2.exists()) continue;
                            failed.set("!file.exists");
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            failed.set(e.getMessage());
                            continue;
                        }
                        catch (Error | RuntimeException e) {
                            e.printStackTrace();
                            throw e;
                        }
                    }
                    break block9;
                    break;
                }
                catch (InterruptedException | BrokenBarrierException exception) {}
            }
        };
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < 32) {
            Thread thread = new Thread(r, "test worked #" + i);
            threads.add(thread);
            thread.start();
            ++i;
        }
        for (Thread thread : threads) {
            thread.join();
        }
        Assert.assertNull(failed.get());
    }

    @Test
    public void testStaleContext() throws Exception {
        ComposableSecurityManagerPolicy.setSystemSecurityManager();
        try {
            BuilderContext testee = this.newBuilder().addInputFile(this.temp.newFile().toPath()).addOutputDirectory(this.temp.newFolder().toPath()).build();
            Path file = this.temp.getRoot().toPath().resolve("1.txt");
            Files.createFile(file, new FileAttribute[0]);
            testee.enter();
            PolicyContextPreserver preserver = new PolicyContextPreserver();
            testee.leave();
            try {
                preserver.wrap(() -> Files.readAllBytes(file)).call();
                Assert.fail();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        finally {
            ComposableSecurityManagerPolicy.removeSystemSecurityManager();
        }
    }
}

