/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import com.google.common.collect.ImmutableSet;
import io.takari.builder.internal.BuilderExecutionState;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BuilderExecutionStateTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testBackwardsCompatibility() throws Exception {
        File file = this.temp.newFile();
        ImmutableSet paths = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c");
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            BuilderExecutionState.writeOutputPaths((ObjectOutputStream)os, (Collection)paths);
            os.writeDouble(42.0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        BuilderExecutionState state = BuilderExecutionState.load((Path)file.toPath());
        Assertions.assertThat((Iterable)state.outputPaths).isEqualTo((Object)paths);
    }
}

