/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.Builder;
import io.takari.builder.Dependencies;
import io.takari.builder.InputFile;
import io.takari.builder.NonDeterministic;
import io.takari.builder.Parameter;
import io.takari.builder.ResolutionScope;
import io.takari.builder.internal.BuilderExecutionState;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.TestInputBuilder;
import io.takari.maven.testing.TestResources;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class BuilderInputsTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testDigest() throws Exception {
        File basedir = this.temp.newFolder();
        File fileA = new File(basedir, "a");
        fileA.createNewFile();
        TestInputBuilder builder = TestInputBuilder.builder(basedir);
        BuilderInputs.Digest digest = builder.build(_Data.class).getDigest();
        TestResources.touch((File)fileA);
        Assert.assertNotEquals((Object)digest, (Object)builder.build(_Data.class).getDigest());
    }

    @Test
    public void testNoParameterDigest() throws Exception {
        BuilderInputs.Digest digest = TestInputBuilder.builder().build(Object.class).getDigest();
        BuilderInputs.Digest emtydigest = BuilderExecutionState.load((Path)new File((File)this.temp.getRoot(), (String)"nosuchfile").toPath()).inputsDigest;
        Assert.assertFalse((boolean)digest.equals((Object)emtydigest));
    }

    @Test
    public void testBacktrace() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(CoreMatchers.startsWith((String)"_Data.string:"));
        TestInputBuilder.builder().withConfigurationXml("<string>b</string>").build(_Data.class, "string");
    }

    @Test
    public void testDefinedPropertyDefaultValue() throws Exception {
        Assert.assertEquals((Object)"test", (Object)TestInputBuilder.builder().withProperty("defaultProperty", "test").build(_Defaults.class, "defaultString").value());
    }

    @Test
    public void testUndefinedPropertyDefaultValue() throws Exception {
        Assert.assertEquals(null, TestInputBuilder.builder().build(_Defaults.class, "defaultString"));
    }

    @Test
    public void testDefinedPropertyValue() throws Exception {
        Assert.assertEquals((Object)"test", (Object)TestInputBuilder.builder().withProperty("defaultProperty", "test").build(_Values.class, "string").value());
    }

    @Test(expected=BuilderInputsBuilder.InvalidConfigurationException.class)
    public void testUndefinedPropertyValue() throws Exception {
        TestInputBuilder.builder().build(_Values.class);
    }

    @Test
    public void testNonPublicBuilder() throws Exception {
        TestInputBuilder builder = TestInputBuilder.builder();
        BuilderInputs inputs = builder.withGoal("generate").build(_nonPublicBuilder.class);
        Assert.assertTrue((boolean)inputs.isNonDeterministic());
    }

    @Test
    public void testUnresolvedDependency() throws Exception {
        File repodir = this.temp.newFolder().getCanonicalFile();
        File dependency = new File(repodir, "nosuchfile");
        BuilderInputs inputs = TestInputBuilder.builder().withDependency("g:a", dependency).build(_Dependency.class);
        Assert.assertNotNull((Object)inputs.getDigest());
        Assertions.assertThat((Iterable)inputs.getInputFiles()).isEmpty();
    }

    static class _Data {
        @Parameter(value={"a"})
        String string;
        @InputFile(value={"a"})
        File file;

        _Data() {
        }
    }

    static class _Defaults {
        @Parameter(defaultValue={"${defaultProperty}"}, required=false)
        String defaultString;

        _Defaults() {
        }
    }

    static class _Dependency {
        @Dependencies(scope=ResolutionScope.COMPILE)
        List<File> dependencies;

        _Dependency() {
        }
    }

    static class _Values {
        @Parameter(value={"${defaultProperty}"}, required=false)
        String string;

        _Values() {
        }
    }

    static class _nonPublicBuilder {
        _nonPublicBuilder() {
        }

        @NonDeterministic
        @Builder(name="generate")
        void execute() {
        }
    }
}

