/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.Builder;
import io.takari.builder.LifecyclePhase;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderRunner;
import io.takari.builder.internal.TestInputBuilder;
import io.takari.builder.testing.BuilderExecutionException;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class BuilderMethodTest {
    private static final String EXT_BASE_MOJO = "extbasemojo";
    private static final String METHOD_NAME = "myMethod";

    @Test
    public void testFindBuilderMethod() throws Exception {
        Method actualMethod = BuilderRunner.getBuilderMethodForGoal(ExtendedBase.class, (String)EXT_BASE_MOJO, BuilderExecutionException::new);
        Method expectedMethod = ExtendedBase.class.getMethod(METHOD_NAME, new Class[0]);
        Assert.assertEquals((String)String.format("Expected to find %s builder method", METHOD_NAME), (Object)expectedMethod, (Object)actualMethod);
    }

    @Test(expected=BuilderExecutionException.class)
    public void testNoBuilderMethodDeclared() throws Exception {
        BuilderRunner.getBuilderMethodForGoal(Base.class, (String)EXT_BASE_MOJO, BuilderExecutionException::new);
    }

    @Test
    public void testInaccessibleType() throws Exception {
        Class<InaccessibleBuilder> builderType = InaccessibleBuilder.class;
        BuilderInputs inputs = TestInputBuilder.builder().build(builderType);
        Method method = BuilderRunner.getBuilderMethodForGoal(builderType, (String)"inaccessible", BuilderExecutionException::new);
        InaccessibleBuilder instance = (InaccessibleBuilder)inputs.newBuilder();
        method.invoke((Object)instance, new Object[0]);
        Assert.assertEquals((long)1L, (long)instance.count);
    }

    private static class Base {
        private Base() {
        }
    }

    private static class ExtendedBase
    extends Base {
        private ExtendedBase() {
        }

        @Builder(name="extbasemojo", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
        public void myMethod() {
        }
    }

    private static class InaccessibleBuilder {
        public int count;

        private InaccessibleBuilder() {
        }

        @Builder(name="inaccessible")
        private void execution() {
            ++this.count;
        }
    }
}

