/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import com.google.common.collect.ImmutableList;
import io.takari.builder.Builder;
import io.takari.builder.Dependencies;
import io.takari.builder.GeneratedResourcesDirectory;
import io.takari.builder.GeneratedSourcesDirectory;
import io.takari.builder.IArtifactMetadata;
import io.takari.builder.InputDirectory;
import io.takari.builder.InputFile;
import io.takari.builder.NonDeterministic;
import io.takari.builder.OutputDirectory;
import io.takari.builder.OutputFile;
import io.takari.builder.Parameter;
import io.takari.builder.ResolutionScope;
import io.takari.builder.ResourceType;
import io.takari.builder.enforcer.internal.EnforcerConfig;
import io.takari.builder.internal.IncrementalBuildException;
import io.takari.builder.internal.ResourceRoot;
import io.takari.builder.internal.pathmatcher.PathNormalizer;
import io.takari.builder.internal.utils.JarBuilder;
import io.takari.builder.internal.workspace.FilesystemWorkspace;
import io.takari.builder.testing.BuilderExecution;
import io.takari.builder.testing.BuilderExecutionException;
import io.takari.builder.testing.BuilderRuntime;
import io.takari.builder.testing.InternalBuilderExecution;
import io.takari.incrementalbuild.workspace.Workspace;
import io.takari.maven.testing.TestResources;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class BuilderRunnerTest {
    public final BuilderRuntime runtime = new BuilderRuntime();
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    public static final String PROPERTY = "some.property";
    static final AtomicReference<File> FILE = new AtomicReference();

    private InternalBuilderExecution builderExecution(Class<?> builder) throws IOException {
        return InternalBuilderExecution.builderExecution(this.temp.newFolder(), builder);
    }

    @Test(expected=SecurityException.class)
    public void testBuilderStaticInitializationEnforcement() throws Exception {
        File tempdir = this.temp.newFolder();
        System.setProperty(StaticInitializationBuilder.class.getName(), tempdir.getCanonicalPath());
        BuilderExecution.builderExecution((File)tempdir, StaticInitializationBuilder.class).execute();
    }

    @Test
    public void testBasicIncrementalBuild() throws Exception {
        File basedir = this.temp.newFolder();
        File stateFile = this.temp.newFile();
        CounterBuilder.COUNTER.set(0);
        InternalBuilderExecution.builderExecution(basedir, CounterBuilder.class).withStateFile(stateFile).execute();
        Assert.assertEquals((long)1L, (long)CounterBuilder.COUNTER.get());
        InternalBuilderExecution.builderExecution(basedir, CounterBuilder.class).withStateFile(stateFile).execute();
        Assert.assertEquals((long)1L, (long)CounterBuilder.COUNTER.get());
        InternalBuilderExecution.builderExecution(basedir, CounterBuilder.class).withStateFile(stateFile).withConfiguration("step", "2").execute();
        Assert.assertEquals((long)3L, (long)CounterBuilder.COUNTER.get());
    }

    @Test
    public void testFailingIncrementalBuild() throws Exception {
        File basedir = this.temp.newFolder();
        File stateFile = this.temp.newFile();
        CounterFailingBuilder.COUNTER.set(0);
        try {
            InternalBuilderExecution.builderExecution(basedir, CounterFailingBuilder.class).withStateFile(stateFile).execute();
            Assert.fail();
        }
        catch (BuilderExecutionException builderExecutionException) {}
        Assert.assertEquals((long)1L, (long)CounterFailingBuilder.COUNTER.get());
        try {
            InternalBuilderExecution.builderExecution(basedir, CounterFailingBuilder.class).withStateFile(stateFile).execute();
            Assert.fail();
        }
        catch (BuilderExecutionException builderExecutionException) {}
        Assert.assertEquals((long)1L, (long)CounterFailingBuilder.COUNTER.get());
        try {
            InternalBuilderExecution.builderExecution(basedir, CounterFailingBuilder.class).withStateFile(stateFile).withConfiguration("step", "2").execute();
            Assert.fail();
        }
        catch (BuilderExecutionException builderExecutionException) {}
        Assert.assertEquals((long)3L, (long)CounterFailingBuilder.COUNTER.get());
    }

    @Test
    public void testIncrementalBuildClasspathChange() throws Exception {
        File basedir = this.temp.newFolder();
        File stateFile = this.temp.newFile();
        File jar = JarBuilder.create((File)this.temp.newFile().getCanonicalFile()).withEntry("Class1.class", "Class1").build();
        File dir = this.temp.newFolder().getCanonicalFile();
        File classfile = new File(dir, "Class2.class");
        Files.write(classfile.toPath(), "Class2".getBytes(), new OpenOption[0]);
        ImmutableList classpath = ImmutableList.of((Object)jar, (Object)dir);
        CounterBuilder.COUNTER.set(0);
        InternalBuilderExecution.builderExecution(basedir, CounterBuilder.class).withStateFile(stateFile).withClasspath((List)classpath).execute();
        Assert.assertEquals((long)1L, (long)CounterBuilder.COUNTER.get());
        Files.write(classfile.toPath(), "Class2 changed".getBytes(), new OpenOption[0]);
        InternalBuilderExecution.builderExecution(basedir, CounterBuilder.class).withStateFile(stateFile).withClasspath((List)classpath).execute();
        Assert.assertEquals((long)2L, (long)CounterBuilder.COUNTER.get());
        JarBuilder.create((File)jar).withEntry("Class1.class", "Class1 changed").build();
        InternalBuilderExecution.builderExecution(basedir, CounterBuilder.class).withStateFile(stateFile).withClasspath((List)classpath).execute();
        Assert.assertEquals((long)3L, (long)CounterBuilder.COUNTER.get());
        InternalBuilderExecution.builderExecution(basedir, CounterBuilder.class).withStateFile(stateFile).withClasspath((List)classpath).execute();
        Assert.assertEquals((long)3L, (long)CounterBuilder.COUNTER.get());
    }

    @Test
    public void testCleanupObsoleteOutput() throws Exception {
        File basedir = this.temp.newFolder();
        File stateFile = this.temp.newFile();
        TestResources.create((File)basedir, (String[])new String[]{"a", "b"});
        File target = this.temp.newFolder();
        InternalBuilderExecution.builderExecution(basedir, CopyFilesBuilder.class).withStateFile(stateFile).withConfiguration("directory", target.getCanonicalPath()).withConfiguration("files", Arrays.asList("a", "b")).execute();
        TestResources.assertDirectoryContents((File)target, (String[])new String[]{"a", "b"});
        InternalBuilderExecution.builderExecution(basedir, CopyFilesBuilder.class).withStateFile(stateFile).withConfiguration("directory", target.getCanonicalPath()).withConfiguration("files", Arrays.asList("a")).execute();
        TestResources.assertDirectoryContents((File)target, (String[])new String[]{"a"});
    }

    @Test
    public void testInputAsOutput() throws Exception {
        File basedir = this.temp.newFolder();
        File stateFile = this.temp.newFile();
        File target = new File(basedir, "out");
        File file = new File(target, "a");
        String relpath = basedir.toPath().relativize(file.toPath()).toString();
        EnforcerConfig enforcerConfig = EnforcerConfig.builder().enforce(true).withReadAndTrackException("input-output", relpath).build();
        file.getParentFile().mkdirs();
        file.createNewFile();
        InternalBuilderExecution.builderExecution(basedir, InputOutputBuilder.class).withStateFile(stateFile).withConfiguration("dir", target.getCanonicalPath()).withConfiguration("write", "true").withEnforcerConfig(enforcerConfig).execute();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)BuilderRunnerTest.readFile(file)).as("File should have been written to once", new Object[0])).isEqualTo((Object)"0");
        Files.write(file.toPath(), "1".getBytes(), new OpenOption[0]);
        TestResources.touch((File)file);
        InternalBuilderExecution.builderExecution(basedir, InputOutputBuilder.class).withStateFile(stateFile).withConfiguration("dir", target.getCanonicalPath()).withConfiguration("write", "true").withEnforcerConfig(enforcerConfig).execute();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)BuilderRunnerTest.readFile(file)).as("File should exist and have been written to", new Object[0])).isEqualTo((Object)"2");
        InternalBuilderExecution.builderExecution(basedir, InputOutputBuilder.class).withStateFile(stateFile).withConfiguration("dir", target.getCanonicalPath()).withConfiguration("write", "false").withEnforcerConfig(enforcerConfig).execute();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)BuilderRunnerTest.readFile(file)).as("File should exist and have been written to", new Object[0])).isEqualTo((Object)"2");
    }

    @Test
    public void testUntrackedRead() throws Exception {
        File basedir = this.temp.newFolder();
        File stateFile = this.temp.newFile();
        File file = this.temp.newFile("b");
        EnforcerConfig enforcerConfig = EnforcerConfig.builder().enforce(true).withReadException("untracked-read", "**/b").build();
        InternalBuilderExecution.builderExecution(basedir, UntrackedReadBuilder.class).withStateFile(stateFile).withConfiguration("file", file.getCanonicalPath()).withEnforcerConfig(enforcerConfig).execute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)UntrackedReadBuilder.COUNTER.get()).as("File should have been read", new Object[0])).isEqualTo(1);
        Files.write(file.toPath(), "1".getBytes(), new OpenOption[0]);
        TestResources.touch((File)file);
        InternalBuilderExecution.builderExecution(basedir, UntrackedReadBuilder.class).withStateFile(stateFile).withConfiguration("file", file.getCanonicalPath()).withEnforcerConfig(enforcerConfig).execute();
        ((AbstractIntegerAssert)Assertions.assertThat((int)UntrackedReadBuilder.COUNTER.get()).as("Counter should not have been incremented", new Object[0])).isEqualTo(1);
    }

    @Test
    public void testInputAsOutputNotWhitelisted() throws Exception {
        File basedir = this.temp.newFolder();
        File stateFile = this.temp.newFile();
        File target = this.temp.newFolder("out");
        File file = new File(target, "a");
        file.createNewFile();
        this.thrown.expect(SecurityException.class);
        this.thrown.expectMessage("Access to an undeclared resource detected");
        this.thrown.expectMessage(String.format("R file:%s", PathNormalizer.normalize0((Path)file.toPath())));
        this.thrown.expectMessage(String.format("W file:%s", PathNormalizer.normalize0((Path)file.toPath())));
        InternalBuilderExecution.builderExecution(basedir, InputOutputBuilder.class).withStateFile(stateFile).withConfiguration("dir", target.getCanonicalPath()).withConfiguration("write", "true").execute();
    }

    static String readFile(File file) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(file.getCanonicalPath(), new String[0]));
        return new String(encoded, Charset.defaultCharset());
    }

    @Test
    public void testSystemProperties() throws Exception {
        File stateFile = this.temp.newFile();
        SystemPropertiesBuilder.COUNTER.set(0);
        System.setProperty(PROPERTY, "value");
        this.builderExecution(SystemPropertiesBuilder.class).withStateFile(stateFile).execute();
        Assert.assertEquals((long)1L, (long)SystemPropertiesBuilder.COUNTER.get());
        this.builderExecution(SystemPropertiesBuilder.class).withStateFile(stateFile).execute();
        Assert.assertEquals((long)1L, (long)SystemPropertiesBuilder.COUNTER.get());
        System.setProperty(PROPERTY, "changed-value");
        this.builderExecution(SystemPropertiesBuilder.class).withStateFile(stateFile).execute();
        Assert.assertEquals((long)2L, (long)SystemPropertiesBuilder.COUNTER.get());
        this.builderExecution(SystemPropertiesBuilder.class).withStateFile(stateFile).execute();
        Assert.assertEquals((long)2L, (long)SystemPropertiesBuilder.COUNTER.get());
    }

    @Test
    public void testTemporaryFile() throws Exception {
        FILE.set(null);
        this.builderExecution(TemporaryFileBuilder.class).execute();
        Assert.assertNotNull((Object)FILE.get());
        Assert.assertFalse((boolean)FILE.get().exists());
    }

    @Test
    public void testGeneratedResources() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("**/*.main");
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("**/*.main.exclude");
        BuilderExecution.builderExecution((File)basedir, GeneratedResourcesBuilder.class).execute().assertProjectResources(new ResourceRoot[]{new ResourceRoot(new File(basedir, "main").getAbsolutePath(), ResourceType.MAIN, includes, excludes), new ResourceRoot(new File(basedir, "test").getAbsolutePath(), ResourceType.TEST, new ArrayList(), new ArrayList())}).assertOutputFiles(basedir, new String[]{"main/main.txt", "test/test.txt"});
    }

    @Test
    public void testGeneratedResources_incremental() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File stateFile = this.temp.newFile();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("**/*.main");
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("**/*.main.exclude");
        InternalBuilderExecution.builderExecution(basedir, GeneratedResourcesBuilder.class).withStateFile(stateFile).execute().assertProjectResources(new ResourceRoot[]{new ResourceRoot(new File(basedir, "main").getAbsolutePath(), ResourceType.MAIN, includes, excludes), new ResourceRoot(new File(basedir, "test").getAbsolutePath(), ResourceType.TEST, new ArrayList(), new ArrayList())}).assertOutputFiles(basedir, new String[]{"main/main.txt", "test/test.txt"});
        InternalBuilderExecution.builderExecution(basedir, GeneratedResourcesBuilder.class).withStateFile(stateFile).execute().assertProjectResources(new ResourceRoot[]{new ResourceRoot(new File(basedir, "main").getAbsolutePath(), ResourceType.MAIN, includes, excludes), new ResourceRoot(new File(basedir, "test").getAbsolutePath(), ResourceType.TEST, new ArrayList(), new ArrayList())}).assertOutputFiles(basedir, new String[0]);
        TestResources.assertDirectoryContents((File)basedir, (String[])new String[]{"main/", "main/main.txt", "test/", "test/test.txt"});
    }

    @Test
    public void testGeneratedSources() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderExecution.builderExecution((File)basedir, GeneratedSourcesBuilder.class).execute().assertCompileSourceRoots(new File[]{new File(basedir, "main")}).assertTestCompileSourceRoots(new File[]{new File(basedir, "test")}).assertOutputFiles(basedir, new String[]{"main/main.txt", "test/test.txt"});
    }

    @Test
    public void testGeneratedSources_incremental() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File stateFile = this.temp.newFile();
        InternalBuilderExecution.builderExecution(basedir, GeneratedSourcesBuilder.class).withStateFile(stateFile).execute().assertCompileSourceRoots(new File[]{new File(basedir, "main")}).assertTestCompileSourceRoots(new File[]{new File(basedir, "test")}).assertOutputFiles(basedir, new String[]{"main/main.txt", "test/test.txt"});
        InternalBuilderExecution.builderExecution(basedir, GeneratedSourcesBuilder.class).withStateFile(stateFile).execute().assertCompileSourceRoots(new File[]{new File(basedir, "main")}).assertTestCompileSourceRoots(new File[]{new File(basedir, "test")}).assertOutputFiles(basedir, new String[0]);
        TestResources.assertDirectoryContents((File)basedir, (String[])new String[]{"main/", "main/main.txt", "test/", "test/test.txt"});
    }

    @Test
    public void testCreateDirectoriesAndFiles() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File stateFile = this.temp.newFile();
        InternalBuilderExecution.builderExecution(basedir, CreateDirectoriesAndFilesBuilder.class).withStateFile(stateFile).withProperty("project.build.outputDirectory", String.valueOf(basedir.toString()) + "/target").withConfiguration("directories", (Collection)ImmutableList.of((Object)"dir1")).withConfiguration("files", (Collection)ImmutableList.of((Object)"dir2/file")).execute().assertOutputFiles(basedir, new String[]{"target/dir2/file"});
        Assertions.assertThat((Object[])new File(basedir, "target").list()).containsExactlyInAnyOrder((Object[])new String[]{"dir1", "dir2"});
        InternalBuilderExecution.builderExecution(basedir, CreateDirectoriesAndFilesBuilder.class).withStateFile(stateFile).withProperty("project.build.outputDirectory", String.valueOf(basedir.toString()) + "/target").withConfiguration("directories", (Collection)ImmutableList.of((Object)"dir1")).execute().assertOutputFiles(basedir, new String[0]);
        Assertions.assertThat((Object[])new File(basedir, "target").list()).containsExactlyInAnyOrder((Object[])new String[]{"dir1"});
        InternalBuilderExecution.builderExecution(basedir, CreateDirectoriesAndFilesBuilder.class).withStateFile(stateFile).withProperty("project.build.outputDirectory", String.valueOf(basedir.toString()) + "/target").withConfiguration("files", (Collection)ImmutableList.of((Object)"dir2/file")).execute().assertOutputFiles(basedir, new String[]{"target/dir2/file"});
        Assertions.assertThat((Object[])new File(basedir, "target").list()).containsExactlyInAnyOrder((Object[])new String[]{"dir2"});
        InternalBuilderExecution.builderExecution(basedir, CreateDirectoriesAndFilesBuilder.class).withStateFile(stateFile).withProperty("project.build.outputDirectory", String.valueOf(basedir.toString()) + "/target").execute().assertOutputFiles(basedir, new String[0]);
        Assertions.assertThat((Object[])new File(basedir, "target").list()).isEmpty();
    }

    @Test
    public void testDirectoryCleanup_unrelatedFilesPresent() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File stateFile = this.temp.newFile();
        File unrelated = new File(basedir, "target/dir/unrelated");
        InternalBuilderExecution.builderExecution(basedir, CreateDirectoriesAndFilesBuilder.class).withStateFile(stateFile).withProperty("project.build.outputDirectory", String.valueOf(basedir.toString()) + "/target").withConfiguration("files", (Collection)ImmutableList.of((Object)"dir/file")).execute().assertOutputFiles(basedir, new String[]{"target/dir/file"});
        Assertions.assertThat((Object[])new File(basedir, "target/dir").list()).containsExactlyInAnyOrder((Object[])new String[]{"file"});
        new FileOutputStream(unrelated).close();
        InternalBuilderExecution.builderExecution(basedir, CreateDirectoriesAndFilesBuilder.class).withStateFile(stateFile).withProperty("project.build.outputDirectory", String.valueOf(basedir.toString()) + "/target").execute().assertOutputFiles(basedir, new String[0]);
        Assertions.assertThat((Object[])new File(basedir, "target/dir").list()).containsExactlyInAnyOrder((Object[])new String[]{"unrelated"});
        unrelated.delete();
        InternalBuilderExecution.builderExecution(basedir, CreateDirectoriesAndFilesBuilder.class).withStateFile(stateFile).withProperty("project.build.outputDirectory", String.valueOf(basedir.toString()) + "/target").execute().assertOutputFiles(basedir, new String[0]);
        Assertions.assertThat((Object[])new File(basedir, "target").list()).containsExactlyInAnyOrder((Object[])new String[]{"dir"});
        InternalBuilderExecution.builderExecution(basedir, CreateDirectoriesAndFilesBuilder.class).withStateFile(stateFile).withProperty("project.build.outputDirectory", String.valueOf(basedir.toString()) + "/target").withConfiguration("files", (Collection)ImmutableList.of((Object)"file")).execute().assertOutputFiles(basedir, new String[]{"target/file"});
        Assertions.assertThat((Object[])new File(basedir, "target").list()).containsExactlyInAnyOrder((Object[])new String[]{"dir", "file"});
    }

    @Test
    public void testBuilderThreads_failure() throws Exception {
        FileSystems.getDefault();
        this.thrown.expect(BuilderExecutionException.class);
        this.thrown.expectMessage("Cannot access system resources without builder context at this thread");
        File basedir = this.temp.newFolder().getCanonicalFile();
        InternalBuilderExecution.builderExecution(basedir, InvalidThreadedBuilder.class).withConfiguration("output", new File(basedir, "output").getCanonicalPath()).execute();
    }

    @Test
    public void testClassesDirectoryAccess() throws Exception {
        File classes = this.temp.newFolder().getCanonicalFile();
        File file = new File(classes, "resource.txt");
        file.createNewFile();
        File basedir = this.temp.newFolder().getCanonicalFile();
        InternalBuilderExecution.builderExecution(basedir, ClasspathResourceReadingBuilder.class).withClasspath((List)Collections.singletonList(classes)).withParameterValue("file", (Object)file.getCanonicalPath()).execute();
        Assertions.assertThat((int)ClasspathResourceReadingBuilder.COUNTER.get()).isEqualTo(1);
    }

    @Test
    public void testCompileSourceRootParsing() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File main = new File(basedir, "main");
        File test = new File(basedir, "test");
        BuilderExecution.builderExecution((File)basedir, CompileSourceRootsBuilder.class).withParameterValue("expectedMain", (Object)main).withParameterValue("expectedTest", (Object)test).withCompileSourceRoot(main).withTestCompileSourceRoot(test).execute();
    }

    @Test
    public void testSourceModeDependenciesAllowedInList() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File dep = this.temp.newFolder();
        File test = new File(dep, "test.txt");
        test.createNewFile();
        BuilderExecution.builderExecution((File)basedir, SourceModeDependenciesBuilder.class).withDependency("g:a:c", dep).execute();
    }

    @Test
    public void testSourceModeDependenciesAllowedInMap() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File dep = this.temp.newFolder();
        File test = new File(dep, "test.txt");
        test.createNewFile();
        BuilderExecution.builderExecution((File)basedir, SourceModeDependencyMapBuilder.class).withDependency("g:a:c", dep).execute();
    }

    @Test
    public void testCrashingBuilder() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File statedir = this.temp.newFolder().getCanonicalFile();
        File statefile = new File(statedir, "statefile");
        try {
            CrashingBuilder.CRASH = true;
            InternalBuilderExecution.builderExecution(basedir, CrashingBuilder.class).withStateFile(statefile).withConfiguration("output", "output").execute();
            Assert.fail();
        }
        catch (CrashError crashError) {}
        Assertions.assertThat((File)new File(basedir, "output")).exists();
        Assertions.assertThat((File)statefile).doesNotExist();
        CrashingBuilder.CRASH = false;
        InternalBuilderExecution.builderExecution(basedir, CrashingBuilder.class).withStateFile(statefile).withConfiguration("output", "output").execute();
        Assertions.assertThat((File)new File(basedir, "output")).exists();
        Assertions.assertThat((File)statefile).exists();
    }

    @Test
    public void testIncrementalBuildException() throws Exception {
        try {
            this.builderExecution(IncrementalBuilderExceptionBuilder.class).execute();
            Assert.fail();
        }
        catch (BuilderExecutionException e) {
            Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(CustomIOException.class);
        }
    }

    @Test
    public void testCrashBeforeWritingOutputFile() throws Exception {
        File basedir = this.temp.newFolder();
        File statefile = this.temp.newFile();
        try {
            CanWriteBuilder.CRASH = true;
            InternalBuilderExecution.builderExecution(basedir, CanWriteBuilder.class).withStateFile(statefile).withConfiguration("output", "output").execute();
            Assert.fail();
        }
        catch (CrashError crashError) {}
        Assertions.assertThat((File)new File(basedir, "output")).doesNotExist();
        CanWriteBuilder.CRASH = false;
        InternalBuilderExecution.builderExecution(basedir, CanWriteBuilder.class).withStateFile(statefile).withConfiguration("output", "output").execute();
        Assertions.assertThat((File)new File(basedir, "output")).exists();
    }

    @Test
    public void testSuppressedWorkspaceModeBuild() throws Exception {
        File basedir = this.temp.newFolder();
        FilesystemWorkspace suppressedWorksapce = new FilesystemWorkspace(){

            public Workspace.Mode getMode() {
                return Workspace.Mode.SUPPRESSED;
            }
        };
        InternalBuilderExecution.builderExecution(basedir, GeneratedSourcesBuilder.class).withWorkspace((Workspace)suppressedWorksapce).execute().assertCompileSourceRoots(new File[]{new File(basedir, "main")}).assertTestCompileSourceRoots(new File[]{new File(basedir, "test")}).assertOutputFiles(basedir, new String[0]);
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("**/*.main");
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("**/*.main.exclude");
        InternalBuilderExecution.builderExecution(basedir, GeneratedResourcesBuilder.class).withWorkspace((Workspace)suppressedWorksapce).execute().assertProjectResources(new ResourceRoot[]{new ResourceRoot(new File(basedir, "main").getAbsolutePath(), ResourceType.MAIN, includes, excludes), new ResourceRoot(new File(basedir, "test").getAbsolutePath(), ResourceType.TEST, new ArrayList(), new ArrayList())}).assertOutputFiles(basedir, new String[0]);
    }

    @Test
    public void testOutputParametersAreProcessedAsOutputs() throws Exception {
        File basedir = this.temp.newFolder();
        File stateFile = this.temp.newFile();
        File target = this.temp.newFolder();
        File targetFile = this.temp.newFile();
        OutputFilesystemWorkspace workspace = new OutputFilesystemWorkspace();
        InternalBuilderExecution.builderExecution(basedir, NoOpBuilder.class).withWorkspace((Workspace)workspace).withStateFile(stateFile).withConfiguration("directory", target.getCanonicalPath()).withConfiguration("file", targetFile.getCanonicalPath()).execute();
        Assertions.assertThat((int)workspace.files.size()).isEqualTo(2);
        Assertions.assertThat(workspace.files).contains((Object[])new File[]{target.getCanonicalFile()});
        Assertions.assertThat(workspace.files).contains((Object[])new File[]{targetFile.getCanonicalFile().getParentFile()});
    }

    static class CanWriteBuilder {
        public static boolean CRASH = false;
        @OutputFile
        private File output;

        CanWriteBuilder() {
        }

        @Builder(name="builder")
        public void execute() throws IOException {
            this.output.canWrite();
            if (CRASH) {
                throw new CrashError();
            }
            new FileOutputStream(this.output).close();
        }
    }

    static class ClasspathResourceReadingBuilder {
        static AtomicInteger COUNTER = new AtomicInteger();
        @Parameter
        String file;

        ClasspathResourceReadingBuilder() {
        }

        @Builder(name="test")
        public void execute() {
            new File(this.file).lastModified();
            COUNTER.incrementAndGet();
        }
    }

    static class CompileSourceRootsBuilder {
        @InputDirectory(value={"${project.compileSourceRoots}"}, includes={"**.*"})
        private List<File> compileSourceRoots;
        @InputDirectory(value={"${project.testCompileSourceRoots}"}, includes={"**.*"})
        private List<File> testCompileSourceRoots;
        @InputFile
        private File expectedMain;
        @InputFile
        private File expectedTest;

        CompileSourceRootsBuilder() {
        }

        @Builder(name="generate")
        public void generate() throws IOException {
            Assertions.assertThat(this.compileSourceRoots).containsExactly((Object[])new File[]{this.expectedMain});
            Assertions.assertThat(this.testCompileSourceRoots).containsExactly((Object[])new File[]{this.expectedTest});
        }
    }

    static class CopyFilesBuilder {
        @InputFile
        List<File> files;
        @OutputDirectory
        File directory;

        CopyFilesBuilder() {
        }

        @Builder(name="copy-files")
        public void copy() throws IOException {
            for (File file : this.files) {
                File outputFile = new File(this.directory, file.getName());
                if (outputFile.isFile() && outputFile.length() == file.length() && outputFile.lastModified() == file.lastModified()) continue;
                Files.copy(file.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    static class CounterBuilder {
        static final AtomicInteger COUNTER = new AtomicInteger();
        @Parameter(defaultValue={"1"})
        int step;

        CounterBuilder() {
        }

        @Builder(name="static-counter")
        public void count() {
            COUNTER.addAndGet(this.step);
        }
    }

    static class CounterFailingBuilder {
        static final AtomicInteger COUNTER = new AtomicInteger();
        @Parameter(defaultValue={"1"})
        int step;

        CounterFailingBuilder() {
        }

        @Builder(name="static-failing-counter")
        public void count() throws CounterFailingException {
            COUNTER.addAndGet(this.step);
            throw new CounterFailingException();
        }
    }

    static class CounterFailingException
    extends RuntimeException {
        CounterFailingException() {
        }
    }

    static class CrashError
    extends Error {
        CrashError() {
        }
    }

    static class CrashingBuilder {
        public static boolean CRASH = false;
        @OutputFile
        private File output;

        CrashingBuilder() {
        }

        @Builder(name="build")
        public void execute() throws IOException {
            if (this.output != null) {
                Files.newOutputStream(this.output.toPath(), new OpenOption[0]).close();
            }
            if (CRASH) {
                throw new CrashError();
            }
        }
    }

    static class CreateDirectoriesAndFilesBuilder {
        @OutputDirectory(defaultValue={"${project.build.outputDirectory}"})
        private File outputDirectory;
        @Parameter(required=false)
        private String[] directories;
        @Parameter(required=false)
        private String[] files;

        CreateDirectoriesAndFilesBuilder() {
        }

        @Builder(name="temporary-directory")
        public void createTemporaryDirectoryAndFiles() throws Exception {
            int n;
            int n2;
            String[] stringArray;
            if (this.directories != null) {
                stringArray = this.directories;
                n2 = this.directories.length;
                n = 0;
                while (n < n2) {
                    String directory = stringArray[n];
                    Files.createDirectories(new File(this.outputDirectory, directory).toPath(), new FileAttribute[0]);
                    ++n;
                }
            }
            if (this.files != null) {
                stringArray = this.files;
                n2 = this.files.length;
                n = 0;
                while (n < n2) {
                    String file = stringArray[n];
                    Path path = new File(this.outputDirectory, file).toPath();
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.newOutputStream(path, new OpenOption[0]).close();
                    ++n;
                }
            }
        }
    }

    static class CustomIOException
    extends IOException {
        CustomIOException() {
        }
    }

    static class GeneratedResourcesBuilder {
        @GeneratedResourcesDirectory(defaultValue={"main"}, includes={"**/*.main"}, defaultExcludes={"**/*.main.exclude"})
        private File main;
        @GeneratedResourcesDirectory(defaultValue={"test"}, type=ResourceType.TEST)
        private File test;

        GeneratedResourcesBuilder() {
        }

        @Builder(name="generate")
        public void generate() throws IOException {
            new File(this.main, "main.txt").createNewFile();
            new File(this.test, "test.txt").createNewFile();
        }
    }

    static class GeneratedSourcesBuilder {
        @GeneratedSourcesDirectory(defaultValue={"main"})
        private File main;
        @GeneratedSourcesDirectory(defaultValue={"test"}, sourceType=ResourceType.TEST)
        private File test;

        GeneratedSourcesBuilder() {
        }

        @Builder(name="generate")
        public void generate() throws IOException {
            new File(this.main, "main.txt").createNewFile();
            new File(this.test, "test.txt").createNewFile();
        }
    }

    static class IncrementalBuilderExceptionBuilder {
        IncrementalBuilderExceptionBuilder() {
        }

        @Builder(name="builder")
        public void execute() {
            throw new IncrementalBuildException((IOException)new CustomIOException());
        }
    }

    static class InputOutputBuilder {
        @Parameter(required=true)
        boolean write;
        @OutputDirectory(required=true)
        File dir;

        InputOutputBuilder() {
        }

        @NonDeterministic
        @Builder(name="input-output")
        public void execute() throws IOException {
            if (this.write) {
                this.incrementFile(new File(this.dir, "a"));
            }
        }

        private void incrementFile(File file) throws IOException, FileNotFoundException {
            int current;
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                current = Character.getNumericValue(reader.read());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var4_5 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write(Character.forDigit(current + 1, 10));
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    static class InvalidThreadedBuilder {
        @OutputFile
        File output;

        InvalidThreadedBuilder() {
        }

        @Builder(name="threade")
        public void execute() throws Exception {
            final AtomicReference exception = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            Files.write(output.toPath(), "test".getBytes(), new OpenOption[0]);
                        }
                        catch (Exception e) {
                            exception.set(e);
                            latch.countDown();
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }.start();
            latch.await();
            if (exception.get() != null) {
                throw (Exception)exception.get();
            }
        }
    }

    static class NoOpBuilder {
        @OutputFile
        File file;
        @OutputDirectory
        File directory;

        NoOpBuilder() {
        }

        @Builder(name="no-op")
        public void copy() throws IOException {
        }
    }

    static class OutputFilesystemWorkspace
    extends FilesystemWorkspace {
        List<File> files = new ArrayList<File>();

        public void processOutput(File outputFile) {
            this.files.add(outputFile);
        }
    }

    static class SourceModeDependenciesBuilder {
        @Dependencies(scope=ResolutionScope.COMPILE)
        private List<File> dependencies;

        SourceModeDependenciesBuilder() {
        }

        @Builder(name="build")
        public void execute() throws Exception {
            this.dependencies.forEach(f -> this.walkit((File)f));
        }

        private void walkit(File file) {
            try {
                Files.walk(file.toPath(), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(path -> {
                    try {
                        Files.readAllBytes(path);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static class SourceModeDependencyMapBuilder {
        @Dependencies(scope=ResolutionScope.COMPILE)
        private Map<IArtifactMetadata, File> dependencyMap;

        SourceModeDependencyMapBuilder() {
        }

        @Builder(name="build")
        public void execute() throws Exception {
            this.dependencyMap.values().forEach(f -> this.walkit((File)f));
        }

        private void walkit(File file) {
            try {
                Files.walk(file.toPath(), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(path -> {
                    try {
                        Files.readAllBytes(path);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static class StaticInitializationBuilder {
        public static final File TEMP;

        static {
            File temp = null;
            try {
                String key = StaticInitializationBuilder.class.getName();
                temp = new File(System.getProperty(key), "tmp-file");
                temp.createNewFile();
            }
            catch (IOException iOException) {}
            TEMP = temp;
        }

        StaticInitializationBuilder() {
        }

        @Builder(name="static-initialization")
        public void execute() {
        }
    }

    static class SystemPropertiesBuilder {
        static final AtomicInteger COUNTER = new AtomicInteger();

        SystemPropertiesBuilder() {
        }

        @Builder(name="system-properties")
        public void accessSystemProperty() {
            System.getProperty(BuilderRunnerTest.PROPERTY);
            COUNTER.incrementAndGet();
        }
    }

    static class TemporaryFileBuilder {
        TemporaryFileBuilder() {
        }

        @Builder(name="temporary-file")
        public void createTemporaryFile() throws IOException {
            Path file = Files.createTempFile("temporary", ".tmp", new FileAttribute[0]);
            Files.exists(file, new LinkOption[0]);
            FILE.set(file.toFile());
        }
    }

    static class UntrackedReadBuilder {
        static final AtomicInteger COUNTER = new AtomicInteger();
        @Parameter
        String file;

        UntrackedReadBuilder() {
        }

        @NonDeterministic
        @Builder(name="untracked-read")
        public void execute() throws IOException {
            Throwable throwable = null;
            Object var2_3 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(new File(this.file)));){
                COUNTER.incrementAndGet();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

