/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.Builder;
import io.takari.builder.InputDirectory;
import io.takari.builder.Messages;
import io.takari.builder.Parameter;
import io.takari.builder.internal.Reflection;
import io.takari.builder.internal.model.AbstractParameter;
import io.takari.builder.internal.model.BuilderMetadataVisitor;
import io.takari.builder.internal.model.BuilderMethod;
import io.takari.builder.internal.model.BuilderValidationVisitor;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BuilderValidationVisitorTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private BuilderValidationVisitor testee = new BuilderValidationVisitor(){

        protected void error(AbstractParameter parameter, String message) {
            throw new ParameterValidationException(parameter, message);
        }

        protected void error(BuilderMethod builder, String message) {
            throw new BuilderValidationException(message);
        }
    };

    private void validate(Class<?> type) {
        Reflection.createBuilderClass(type).accept((BuilderMetadataVisitor)this.testee);
    }

    @Test
    public void testAmbiguousParameterAnnotations() throws Exception {
        this.thrown.expect(ParameterValidationException.class);
        this.thrown.expectMessage("ambigous parameter annotation present: [InputDirectory, Parameter]");
        this.validate(_AmbiguousParameterAnnotations.class);
    }

    @Test
    public void testUnsupportedMultivalueType() throws Exception {
        this.thrown.expect(ParameterValidationException.class);
        this.thrown.expectMessage("multivalue prarmeter type must be concrete type or one of Collection, List and Set");
        this.validate(_UnsupportedMultivalueType.class);
    }

    @Test
    public void testUnsupportedInputDirectoryType() throws Exception {
        this.thrown.expect(ParameterValidationException.class);
        this.thrown.expectMessage("@InputDirectory paramerer must be of type File");
        this.validate(_UnsupportedInputDirectoryType.class);
    }

    @Test
    public void testUnsupportedBuilderMethodParameters() throws Exception {
        this.thrown.expect(BuilderValidationException.class);
        this.thrown.expectMessage("Buidler method must not take parameters");
        this.validate(_UnsupportedBuilderMethodParameters.class);
    }

    @Test
    public void testUnknownListElement() throws Exception {
        this.thrown.expect(ParameterValidationException.class);
        this.thrown.expectMessage("Raw Collection or wildcard Collection element type");
        this.validate(_UnknownListElement.class);
    }

    @Test
    public void testUnknownMapKeyValue() throws Exception {
        this.thrown.expect(ParameterValidationException.class);
        this.thrown.expectMessage("Raw Map or wildcard Map key and/or value types");
        this.validate(_UnknownMayKeyValue.class);
    }

    private static class BuilderValidationException
    extends RuntimeException {
        public BuilderValidationException(String message) {
            super(message);
        }
    }

    static interface CustomList<E>
    extends List<E> {
    }

    private static class ParameterValidationException
    extends RuntimeException {
        public ParameterValidationException(AbstractParameter parameter, String message) {
            super(message);
        }
    }

    static class _AmbiguousParameterAnnotations {
        @Parameter
        @InputDirectory(includes={"**/*"})
        File parameter;

        _AmbiguousParameterAnnotations() {
        }
    }

    static class _UnknownListElement {
        @Parameter
        List<?> list;

        _UnknownListElement() {
        }
    }

    static class _UnknownMayKeyValue {
        @Parameter
        Map<?, ?> map;

        _UnknownMayKeyValue() {
        }
    }

    static class _UnsupportedBuilderMethodParameters {
        _UnsupportedBuilderMethodParameters() {
        }

        @Builder(name="builder")
        public void method(Messages message) {
        }
    }

    static class _UnsupportedInputDirectoryType {
        @InputDirectory(includes={"**/*"})
        Date directory;

        _UnsupportedInputDirectoryType() {
        }
    }

    static class _UnsupportedMultivalueType {
        @Parameter
        CustomList<String> list;

        _UnsupportedMultivalueType() {
        }
    }
}

