/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.internal.BuilderExecutionState;
import io.takari.builder.internal.BuilderWorkspace;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Test;

public class BuilderWorkspaceTest {
    @Test
    public void testDeltaWorkspaceWithEscalatedExecutionState() {
        TestWorkspace workspace = new TestWorkspace(Workspace.Mode.DELTA);
        BuilderExecutionState state = BuilderExecutionState.load((Path)Paths.get("", new String[0]));
        BuilderWorkspace builderWorkspace = new BuilderWorkspace((Workspace)workspace, Paths.get("", new String[0]), state);
        Assert.assertEquals((Object)Workspace.Mode.ESCALATED, (Object)builderWorkspace.getMode(Paths.get("", new String[0])));
    }

    static class TestWorkspace
    implements Workspace {
        public Workspace.Mode mode;

        public TestWorkspace(Workspace.Mode mode) {
            this.mode = mode;
        }

        public Workspace.Mode getMode() {
            return this.mode;
        }

        public Workspace escalate() {
            return new TestWorkspace(Workspace.Mode.ESCALATED);
        }

        public boolean isPresent(File file) {
            return false;
        }

        public boolean isRegularFile(File file) {
            return false;
        }

        public boolean isDirectory(File file) {
            return false;
        }

        public void deleteFile(File file) throws IOException {
        }

        public void processOutput(File file) {
        }

        public OutputStream newOutputStream(File file) throws IOException {
            return null;
        }

        public Workspace.ResourceStatus getResourceStatus(File file, long lastModified, long length) {
            return null;
        }

        public void walk(File basedir, Workspace.FileVisitor visitor) throws IOException {
        }
    }
}

