/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.Parameter;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.TestInputBuilder;
import io.takari.maven.testing.TestMavenRuntime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.junit.Assert;
import org.junit.Test;

public class CollectionInputTest {
    static BuilderInputs.CollectionValue newCollectionInput(String ... values) {
        ArrayList<BuilderInputs.StringValue> members = new ArrayList<BuilderInputs.StringValue>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            members.add(new BuilderInputs.StringValue(value, String::new));
            ++n2;
        }
        return new BuilderInputs.CollectionValue(ArrayList::new, members);
    }

    @Test
    public void testDigest() throws Exception {
        BuilderInputs.Digest digest = BuilderInputs.digest((BuilderInputs.Value)CollectionInputTest.newCollectionInput("a", "a"));
        Assert.assertEquals((Object)digest, (Object)BuilderInputs.digest((BuilderInputs.Value)CollectionInputTest.newCollectionInput("a", "a")));
        Assert.assertNotEquals((Object)digest, (Object)BuilderInputs.digest((BuilderInputs.Value)CollectionInputTest.newCollectionInput("b", "b")));
    }

    @Test
    public void testList() throws Exception {
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom listConfiguration = new Xpp3Dom("list");
        configuration.addChild(listConfiguration);
        listConfiguration.addChild(TestMavenRuntime.newParameter((String)"value1", (String)"value1"));
        listConfiguration.addChild(TestMavenRuntime.newParameter((String)"value2", (String)"value2"));
        BuilderInputs.CollectionValue input = (BuilderInputs.CollectionValue)TestInputBuilder.builder().withConfiguration(configuration).build(_ListData.class, "list");
        Assert.assertEquals((Object)"value1", (Object)((BuilderInputs.Value)input.configuration.get(0)).value());
        Assert.assertEquals((Object)"value2", (Object)((BuilderInputs.Value)input.configuration.get(1)).value());
    }

    @Test(expected=BuilderInputsBuilder.InvalidConfigurationException.class)
    public void testList_noConfiguration() throws Exception {
        TestInputBuilder.builder().build(_ListData.class, "list");
    }

    @Test(expected=BuilderInputsBuilder.InvalidConfigurationException.class)
    public void testList_emptyConfiguration() throws Exception {
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom listConfiguration = new Xpp3Dom("list");
        configuration.addChild(listConfiguration);
        TestInputBuilder.builder().withConfiguration(configuration).build(_ListData.class, "list");
    }

    @Test(expected=BuilderInputsBuilder.InvalidModelException.class)
    public void testListOfLists() throws Exception {
        TestInputBuilder.builder().build(_ListOfListsData.class, "list");
    }

    @Test(expected=BuilderInputsBuilder.InvalidModelException.class)
    public void testListOfRawLists() throws Exception {
        TestInputBuilder.builder().build(_ListOfRawListsData.class, "list");
    }

    @Test
    public void testCommaSeparatedList() throws Exception {
        BuilderInputs.CollectionValue input = (BuilderInputs.CollectionValue)TestInputBuilder.builder().build(_CommaSeparatedListData.class, "list");
        Assert.assertEquals((Object)"a", (Object)((BuilderInputs.Value)input.configuration.get(0)).value());
        Assert.assertEquals((Object)"b", (Object)((BuilderInputs.Value)input.configuration.get(1)).value());
        Assert.assertEquals((Object)"c", (Object)((BuilderInputs.Value)input.configuration.get(2)).value());
    }

    @Test(expected=BuilderInputsBuilder.InvalidConfigurationException.class)
    public void testCommaSeparatedList_illegalConfiguration() throws Exception {
        TestInputBuilder.builder().withConfigurationXml("<list><l>element</l></list>").build(_CommaSeparatedListData.class, "list");
    }

    @Test
    public void testOptional() throws Exception {
        BuilderInputs.CollectionValue input = (BuilderInputs.CollectionValue)TestInputBuilder.builder().build(_OptionalListData.class, "list");
        Assert.assertNull((Object)input);
    }

    @Test
    public void testSupportedTypes() throws Exception {
        Assert.assertEquals(Collections.singletonList("1"), (Object)TestInputBuilder.builder().build(_SupportedTypesData.class, "list").value());
        Assert.assertEquals(Collections.singleton("1"), (Object)TestInputBuilder.builder().build(_SupportedTypesData.class, "set").value());
        Assert.assertEquals(Collections.singletonList("1"), (Object)TestInputBuilder.builder().build(_SupportedTypesData.class, "collection").value());
        Assert.assertEquals(Collections.singletonList("1"), (Object)TestInputBuilder.builder().build(_SupportedTypesData.class, "concrete").value());
    }

    @Test
    public void testArray() throws Exception {
        Object[] strings = (String[])TestInputBuilder.builder().build(_ArrayData.class, "strings").value();
        Assertions.assertThat((Object[])strings).contains((Object[])new String[]{"1", "2"});
    }

    static class _ArrayData {
        @Parameter(value={"1", "2"})
        String[] strings;

        _ArrayData() {
        }
    }

    static class _CommaSeparatedListData {
        @Parameter(value={"a", "b", "c"})
        List<String> list;

        _CommaSeparatedListData() {
        }
    }

    static class _ListData {
        @Parameter
        List<String> list;

        _ListData() {
        }
    }

    static class _ListOfListsData {
        @Parameter
        List<List<String>> list;

        _ListOfListsData() {
        }
    }

    static class _ListOfRawListsData {
        @Parameter
        List<List> list;

        _ListOfRawListsData() {
        }
    }

    static class _OptionalListData {
        @Parameter(required=false)
        List<String> list = Collections.emptyList();

        _OptionalListData() {
        }
    }

    static class _SupportedTypesData {
        @Parameter(value={"1"})
        List<String> list;
        @Parameter(value={"1"})
        Set<String> set;
        @Parameter(value={"1"})
        Collection<String> collection;
        @Parameter(value={"1"})
        LinkedList<String> concrete;

        _SupportedTypesData() {
        }
    }
}

