/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.InputDirectory;
import io.takari.builder.Parameter;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.DirAssert;
import io.takari.builder.internal.TestInputBuilder;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CompositeInputTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    static <T extends BuilderInputs.Value<?>> T getMember(BuilderInputs.CompositeValue input, Class<?> type, String name) throws ReflectiveOperationException {
        return (T)((BuilderInputs.Value)input.configuration.get(type.getDeclaredField(name)));
    }

    static BuilderInputs.CompositeValue newCompositeInput(String n1, String v1, String n2, String v2) throws Exception {
        HashMap<Field, BuilderInputs.StringValue> members = new HashMap<Field, BuilderInputs.StringValue>();
        members.put(_Composite.class.getField(n1), new BuilderInputs.StringValue(v2, String::new));
        members.put(_Composite.class.getField(n2), new BuilderInputs.StringValue(v2, String::new));
        return new BuilderInputs.CompositeValue(_Composite.class, members);
    }

    @Test
    public void testDigest() throws Exception {
        BuilderInputs.Digest digest = BuilderInputs.digest((BuilderInputs.Value)CompositeInputTest.newCompositeInput("string", "a", "directory", "a"));
        Assert.assertEquals((Object)digest, (Object)BuilderInputs.digest((BuilderInputs.Value)CompositeInputTest.newCompositeInput("string", "a", "directory", "a")));
        Assert.assertNotEquals((Object)digest, (Object)BuilderInputs.digest((BuilderInputs.Value)CompositeInputTest.newCompositeInput("string", "b", "directory", "b")));
    }

    @Test
    public void testComplexParameter() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        new File(basedir, "1.txt").createNewFile();
        BuilderInputs.CompositeValue input = (BuilderInputs.CompositeValue)TestInputBuilder.builder(basedir).withConfigurationXml("<parameter><string>string-value</string></parameter>").build(_Data.class, "parameter");
        BuilderInputs.StringValue string = (BuilderInputs.StringValue)CompositeInputTest.getMember(input, _Composite.class, "string");
        BuilderInputs.InputDirectoryValue directory = (BuilderInputs.InputDirectoryValue)CompositeInputTest.getMember(input, _Composite.class, "directory");
        Assert.assertEquals((Object)"string-value", (Object)string.configuration);
        DirAssert.assertFiles(directory.files(), new File(basedir, "1.txt"));
    }

    @Test
    public void testComplexListParameter() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        new File(basedir, "dir-1").mkdirs();
        new File(basedir, "dir-1/1.txt").createNewFile();
        new File(basedir, "dir-2").mkdirs();
        new File(basedir, "dir-2/2.txt").createNewFile();
        BuilderInputs.CollectionValue list = (BuilderInputs.CollectionValue)TestInputBuilder.builder(basedir).withConfigurationXml("<parameter><entry><string>entry-1</string><inputDirectory><location>dir-1</location></inputDirectory></entry><entry><string>entry-2</string><inputDirectory><location>dir-2</location></inputDirectory></entry></parameter>").build(_ListData.class, "parameter");
        Assert.assertEquals((long)2L, (long)list.configuration.size());
        BuilderInputs.CompositeValue composite1 = (BuilderInputs.CompositeValue)list.configuration.get(0);
        Assert.assertEquals(_Composite.class, (Object)composite1.type);
        BuilderInputs.InputDirectoryValue directory1 = (BuilderInputs.InputDirectoryValue)CompositeInputTest.getMember(composite1, _Composite.class, "directory");
        Assert.assertEquals((Object)"entry-1", (Object)((BuilderInputs.StringValue)CompositeInputTest.getMember((BuilderInputs.CompositeValue)composite1, _Composite.class, (String)"string")).configuration);
        DirAssert.assertFiles(directory1.files(), new File(basedir, "dir-1/1.txt"), new File(basedir, "dir-2/2.txt"));
        Assert.assertEquals((long)2L, (long)((List)list.value()).size());
    }

    @Test
    public void testOptionalCompositeParameter() throws Exception {
        Assert.assertNull(TestInputBuilder.builder().build(_OptionalCompositeParameterData.class, "parameter"));
    }

    @Test
    public void testPrimitiveMemberComposite() throws Exception {
        _PrimitiveMemberComposite parameter = (_PrimitiveMemberComposite)TestInputBuilder.builder().withConfigurationXml("<parameter><string>string</string></parameter>").build(_PrimitiveMemberData.class, "parameter").value();
        Assert.assertEquals((long)123L, (long)parameter.member);
    }

    @Test(expected=BuilderInputsBuilder.InvalidModelException.class)
    public void testIllegalAnnotationValue() throws Exception {
        TestInputBuilder.builder().withConfigurationXml("<value><string>s</string><directory>.</directory></value>").build(_IllegalAnnotationValueData.class, "value");
    }

    @Test(expected=BuilderInputsBuilder.InvalidModelException.class)
    public void testIllegalAnnotationDefaultValue() throws Exception {
        TestInputBuilder.builder().withConfigurationXml("<defaultValue><string>s</string><directory>.</directory></defaultValue>").build(_IllegalAnnotationValueData.class, "defaultValue");
    }

    @Test
    public void testPrivateMember() throws Exception {
        _PrivateMemberComposite parameter = (_PrivateMemberComposite)TestInputBuilder.builder().withConfigurationXml("<parameter><privateMember>value</privateMember></parameter>").build(_PrivateMemberCompositeData.class, "parameter").value();
        Assert.assertEquals((Object)"value", (Object)parameter.getPrivateMember());
    }

    static class _Composite {
        public String string;
        @InputDirectory(defaultValue={"."}, includes={"**/*.txt"})
        public File directory;

        _Composite() {
        }
    }

    static class _Data {
        @Parameter
        private _Composite parameter;

        _Data() {
        }
    }

    static class _IllegalAnnotationValueData {
        @Parameter(value={"illegal"})
        _Composite value;
        @Parameter(defaultValue={"illegal"})
        _Composite defaultValue;

        _IllegalAnnotationValueData() {
        }
    }

    static class _ListData {
        @Parameter
        public List<_Composite> parameter;

        _ListData() {
        }
    }

    static class _OptionalCompositeParameterData {
        @Parameter(required=false)
        _Composite parameter;

        _OptionalCompositeParameterData() {
        }
    }

    static class _PrimitiveMemberComposite {
        String string;
        int member = 123;

        _PrimitiveMemberComposite() {
        }
    }

    static class _PrimitiveMemberData {
        @Parameter
        _PrimitiveMemberComposite parameter;

        _PrimitiveMemberData() {
        }
    }

    static class _PrivateMemberComposite {
        private String privateMember;

        _PrivateMemberComposite() {
        }

        public String getPrivateMember() {
            return this.privateMember;
        }
    }

    static class _PrivateMemberCompositeData {
        @Parameter
        _PrivateMemberComposite parameter;

        _PrivateMemberCompositeData() {
        }
    }
}

