/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.Dependencies;
import io.takari.builder.IArtifactMetadata;
import io.takari.builder.ResolutionScope;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.TestInputBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DependenciesInputTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    private IArtifactMetadata newArtifact(String gac) {
        return new TestInputBuilder.TestArtifactMetadata(gac);
    }

    @Test
    public void testDigest() throws Exception {
        Path path = this.temp.newFile().toPath();
        Files.write(path, "content".getBytes(), new OpenOption[0]);
        BuilderInputs.Digest digest = BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.DependencyValue(File.class, this.newArtifact("g:a"), path));
        BuilderInputs.Digest metadataDigest = BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.DependencyValue(IArtifactMetadata.class, this.newArtifact("g:a"), path));
        Assertions.assertThat((Object)digest).isEqualTo((Object)BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.DependencyValue(File.class, this.newArtifact("g:a"), path)));
        ((AbstractObjectAssert)Assertions.assertThat((Object)digest).as("same location, same artifact, IArtifactMetadata", new Object[0])).isNotEqualTo((Object)metadataDigest);
        ((AbstractObjectAssert)Assertions.assertThat((Object)digest).as("same location, different artifact", new Object[0])).isNotEqualTo((Object)BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.DependencyValue(File.class, this.newArtifact("g:b"), path)));
        Path htap = this.temp.newFile().toPath();
        ((AbstractObjectAssert)Assertions.assertThat((Object)digest).as("same artifact, different location", new Object[0])).isNotEqualTo((Object)BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.DependencyValue(File.class, this.newArtifact("g:a"), htap)));
        Files.write(path, "changed-content".getBytes(), new OpenOption[0]);
        ((AbstractObjectAssert)Assertions.assertThat((Object)digest).as("same artifact, same location, different content", new Object[0])).isNotEqualTo((Object)BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.DependencyValue(File.class, this.newArtifact("g:a"), path)));
        ((AbstractObjectAssert)Assertions.assertThat((Object)metadataDigest).as("same artifact, same location, different content, IArtifactMetadata", new Object[0])).isEqualTo((Object)BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.DependencyValue(IArtifactMetadata.class, this.newArtifact("g:a"), path)));
    }

    @Test
    public void testDependenciesInput() throws Exception {
        String dependency1 = "dependency1";
        String dependency2 = "dependency2";
        File depFile1 = this.temp.newFile(dependency1).getCanonicalFile();
        File depFile2 = this.temp.newFile(dependency2).getCanonicalFile();
        List input = (List)TestInputBuilder.builder().withDependencies(depFile1.getCanonicalPath(), depFile2.getCanonicalPath()).build(_LocationData.class, "dependencies").value();
        Assertions.assertThat((List)input).containsExactly((Object[])new File[]{depFile1, depFile2});
    }

    @Test(expected=BuilderInputsBuilder.InvalidConfigurationException.class)
    public void testFailureOnConfiguration() throws Exception {
        TestInputBuilder.builder().withConfigurationXml("<dependencies>TEST</dependencies>").build(_LocationData.class, "dependencies");
    }

    @Test
    public void testEmptyDependencies() throws Exception {
        Assert.assertNull(TestInputBuilder.builder().build(_LocationData.class, "dependencies"));
    }

    @Test
    public void testExplodedDependency() throws Exception {
        File dep = this.temp.newFolder();
        Files.write(new File(dep, "entry.txt").toPath(), "content".getBytes(), new OpenOption[0]);
        BuilderInputs inputs = TestInputBuilder.builder().withDependency("g:a", dep).build(_LocationData.class);
        inputs.inputFiles.forEach(f -> {
            AbstractPathAssert abstractPathAssert = Assertions.assertThat((Path)f).hasParent(dep.toPath());
        });
        BuilderInputs.Digest digest = inputs.getDigest();
        Files.write(new File(dep, "entry.txt").toPath(), "changed-content".getBytes(), new OpenOption[0]);
        Assertions.assertThat((Object)digest).isNotEqualTo((Object)TestInputBuilder.builder().withDependency("g:a", dep).build(_LocationData.class).getDigest());
    }

    @Test
    public void testPathDependenciesInput() throws Exception {
        String dependency1 = "dependency1";
        String dependency2 = "dependency2";
        File depFile1 = this.temp.newFile(dependency1).getCanonicalFile();
        File depFile2 = this.temp.newFile(dependency2).getCanonicalFile();
        List input = (List)TestInputBuilder.builder().withDependencies(depFile1.getCanonicalPath(), depFile2.getCanonicalPath()).build(_PathLocationData.class, "dependencies").value();
        Assertions.assertThat((List)input).containsExactly((Object[])new Path[]{depFile1.toPath(), depFile2.toPath()});
    }

    @Test
    public void testPathDependencyInput_directory() throws Exception {
        File dirDep = this.temp.newFolder().getCanonicalFile();
        Files.createFile(dirDep.toPath().resolve("file"), new FileAttribute[0]);
        File fileDep = this.temp.newFile();
        BuilderInputs inputs = TestInputBuilder.builder().withDependencies(dirDep.getCanonicalPath(), fileDep.getCanonicalPath()).build(_PathLocationData.class);
        Assertions.assertThat((Iterable)inputs.getInputFiles()).contains((Object[])new Path[]{dirDep.getCanonicalFile().toPath().resolve("file"), fileDep.getCanonicalFile().toPath()});
    }

    @Test
    public void testDependencyMetadatasInput() throws Exception {
        String metadata1 = "a";
        String metadata2 = "b";
        File depFile1 = this.temp.newFile(metadata1).getCanonicalFile();
        File depFile2 = this.temp.newFile(metadata2).getCanonicalFile();
        List input = (List)TestInputBuilder.builder().withDependencies(depFile1.getCanonicalPath(), depFile2.getCanonicalPath()).build(_MetadataData.class, "dependencies").value();
        Assertions.assertThat((List)input).hasSize(2);
        Assertions.assertThat((String)((IArtifactMetadata)input.get(0)).getArtifactId()).isEqualTo((Object)"a");
        Assertions.assertThat((String)((IArtifactMetadata)input.get(1)).getArtifactId()).isEqualTo((Object)"b");
    }

    @Test
    public void testDependencyMetadatasInput_directory() throws Exception {
        File dirDep = this.temp.newFolder().getCanonicalFile();
        Files.createFile(dirDep.toPath().resolve("file"), new FileAttribute[0]);
        File fileDep = this.temp.newFile();
        BuilderInputs inputs = TestInputBuilder.builder().withDependencies(dirDep.getCanonicalPath(), fileDep.getCanonicalPath()).build(_MetadataData.class);
        Assertions.assertThat((Iterable)inputs.getInputFiles()).isEmpty();
    }

    @Test(expected=BuilderInputsBuilder.InvalidModelException.class)
    public void testFailOnNonDependencyCollectionType() throws Exception {
        TestInputBuilder.builder().withDependencies("dependency").build(_InvalidData.class, "dependencies");
    }

    @Test
    public void testDependencyMap() throws Exception {
        String metadata1 = "a:b:c";
        String metadata2 = "d:e:f";
        File fileDep = this.temp.newFile();
        File dirDep = this.temp.newFolder();
        new File(dirDep, "test.txt").createNewFile();
        Map input = (Map)TestInputBuilder.builder().withDependency(metadata1, fileDep).withDependency(metadata2, dirDep).build(_MapData.class, "dependencies").value();
        Assertions.assertThat((Map)input).hasSize(2);
        Iterator it = input.entrySet().iterator();
        Map.Entry entry1 = it.next();
        Map.Entry entry2 = it.next();
        Assertions.assertThat((Object)((IArtifactMetadata)entry1.getKey())).isEqualTo((Object)new TestInputBuilder.TestArtifactMetadata(metadata1));
        Assertions.assertThat((Object)((IArtifactMetadata)entry2.getKey())).isEqualTo((Object)new TestInputBuilder.TestArtifactMetadata(metadata2));
        Assertions.assertThat((File)((File)entry1.getValue())).isEqualTo((Object)fileDep);
        Assertions.assertThat((File)((File)entry2.getValue())).isEqualTo((Object)dirDep);
    }

    @Test
    public void testDependencyMapPath() throws Exception {
        String metadata1 = "a:b:c";
        String metadata2 = "d:e:f";
        File fileDep = this.temp.newFile();
        File dirDep = this.temp.newFolder();
        new File(dirDep, "test.txt").createNewFile();
        Map input = (Map)TestInputBuilder.builder().withDependency(metadata1, fileDep).withDependency(metadata2, dirDep).build(_MapPathData.class, "dependencies").value();
        Assertions.assertThat((Map)input).hasSize(2);
        Iterator it = input.entrySet().iterator();
        Map.Entry entry1 = it.next();
        Map.Entry entry2 = it.next();
        Assertions.assertThat((Object)((IArtifactMetadata)entry1.getKey())).isEqualTo((Object)new TestInputBuilder.TestArtifactMetadata(metadata1));
        Assertions.assertThat((Object)((IArtifactMetadata)entry2.getKey())).isEqualTo((Object)new TestInputBuilder.TestArtifactMetadata(metadata2));
        Assertions.assertThat((Path)((Path)entry1.getValue())).isEqualTo((Object)fileDep.toPath());
        Assertions.assertThat((Path)((Path)entry2.getValue())).isEqualTo((Object)dirDep.toPath());
    }

    static class _InvalidData {
        @Dependencies(scope=ResolutionScope.COMPILE)
        public List<Date> dependencies;

        _InvalidData() {
        }
    }

    static class _LocationData {
        @Dependencies(scope=ResolutionScope.COMPILE)
        public List<File> dependencies;

        _LocationData() {
        }
    }

    static class _MapData {
        @Dependencies(scope=ResolutionScope.COMPILE)
        public Map<IArtifactMetadata, File> dependencies;

        _MapData() {
        }
    }

    static class _MapPathData {
        @Dependencies(scope=ResolutionScope.COMPILE)
        public Map<IArtifactMetadata, Path> dependencies;

        _MapPathData() {
        }
    }

    static class _MetadataData {
        @Dependencies(scope=ResolutionScope.COMPILE)
        public List<IArtifactMetadata> dependencies;

        _MetadataData() {
        }
    }

    static class _PathLocationData {
        @Dependencies(scope=ResolutionScope.COMPILE)
        public List<Path> dependencies;

        _PathLocationData() {
        }
    }
}

