/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.DependencyResources;
import io.takari.builder.IArtifactMetadata;
import io.takari.builder.IArtifactResources;
import io.takari.builder.ResolutionScope;
import io.takari.builder.internal.ArtifactResourceURLStreamHandler;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.TestInputBuilder;
import io.takari.builder.internal.utils.JarBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class DependencyResourcesInputTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    File newDirArtifact(String ... entries) throws IOException {
        File dir = this.temp.newFolder().getCanonicalFile();
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            Files.createFile(dir.toPath().resolve(entry), new FileAttribute[0]);
            ++n2;
        }
        return dir;
    }

    File newJarArtifact(String ... entries) throws IOException {
        return JarBuilder.create((File)this.temp.newFile().getCanonicalFile()).withEntries(entries).build();
    }

    URL newResource(String name, String content) throws IOException {
        File file = this.temp.newFile().getCanonicalFile();
        Files.write(file.toPath(), content.getBytes(), new OpenOption[0]);
        TestInputBuilder.TestArtifactMetadata artifact = new TestInputBuilder.TestArtifactMetadata("g:a");
        return ArtifactResourceURLStreamHandler.newURL((IArtifactMetadata)artifact, (String)name, (URL)file.toURI().toURL());
    }

    static BuilderInputs.ArtifactResourcesValue newArtifactResourcesValue(String artifactId, URL ... resources) {
        TestInputBuilder.TestArtifactMetadata artifact = new TestInputBuilder.TestArtifactMetadata("g:" + artifactId);
        return new BuilderInputs.ArtifactResourcesValue(Collections.emptySet(), (IArtifactMetadata)artifact, Arrays.asList(resources));
    }

    @Test
    public void testArtifactResourcesDigest() throws Exception {
        URL a = this.newResource("a", "a");
        URL a_copy = this.newResource("acopy", "a");
        URL a_diff = this.newResource("a", "a diff");
        URL b = this.newResource("b", "b");
        BuilderInputs.ArtifactResourcesValue value = DependencyResourcesInputTest.newArtifactResourcesValue("artifactA", a, b);
        Assertions.assertThat((Object)BuilderInputs.digest((BuilderInputs.Value)value)).isEqualTo((Object)BuilderInputs.digest((BuilderInputs.Value)DependencyResourcesInputTest.newArtifactResourcesValue("artifactA", a, b)));
        ((AbstractObjectAssert)Assertions.assertThat((Object)BuilderInputs.digest((BuilderInputs.Value)value)).as("same bytes, different resources names", new Object[0])).isNotEqualTo((Object)BuilderInputs.digest((BuilderInputs.Value)DependencyResourcesInputTest.newArtifactResourcesValue("artifactA", a_copy, b)));
        ((AbstractObjectAssert)Assertions.assertThat((Object)BuilderInputs.digest((BuilderInputs.Value)value)).as("same resources, different artifacts", new Object[0])).isNotEqualTo((Object)BuilderInputs.digest((BuilderInputs.Value)DependencyResourcesInputTest.newArtifactResourcesValue("artifactB", a, b)));
        ((AbstractObjectAssert)Assertions.assertThat((Object)BuilderInputs.digest((BuilderInputs.Value)value)).as("same resources names, different bytes", new Object[0])).isNotEqualTo((Object)BuilderInputs.digest((BuilderInputs.Value)DependencyResourcesInputTest.newArtifactResourcesValue("artifactA", a_diff, b)));
    }

    @Test
    public void testSpecificDependency() throws Exception {
        File dependency = this.newJarArtifact("test.xml");
        TestInputBuilder builder = TestInputBuilder.builder().withConfigurationXml("<resources><dependency><groupId>g</groupId><artifactId>a</artifactId></dependency><include>test.xml</include></resources>").withDependency("g:a", dependency);
        List value = (List)builder.build(_ListURLData.class, "resources").value();
        Assertions.assertThat((List)value).hasSize(1);
        Assertions.assertThat((String)((URL)value.get(0)).getPath()).isEqualTo((Object)"test.xml");
    }

    @Test
    public void testAllDependency() throws Exception {
        File dependency = this.newJarArtifact("test.xml");
        TestInputBuilder builder = TestInputBuilder.builder().withConfigurationXml("<resources><include>test.xml</include></resources>").withDependency("g:a", dependency);
        List value = (List)builder.build(_ListURLData.class, "resources").value();
        Assertions.assertThat((List)value).hasSize(1);
        Assertions.assertThat((String)((URL)value.get(0)).getPath()).isEqualTo((Object)"test.xml");
    }

    @Test
    public void testSubdirDependency() throws Exception {
        File dependency = this.newJarArtifact("dir/test.xml");
        TestInputBuilder builder = TestInputBuilder.builder().withConfigurationXml("<resources><include>dir/test.xml</include></resources>").withDependency("g:a", dependency);
        List value = (List)builder.build(_ListURLData.class, "resources").value();
        Assertions.assertThat((List)value).hasSize(1);
        Assertions.assertThat((String)((URL)value.get(0)).getPath()).isEqualTo((Object)"dir/test.xml");
    }

    @Test
    public void testDependencyWithOpenEndedMatcher() throws Exception {
        File dependency = this.newJarArtifact("dir/test.xml");
        TestInputBuilder builder = TestInputBuilder.builder().withConfigurationXml("<resources><include>dir/**/test.xml</include></resources>").withDependency("g:a", dependency);
        List value = (List)builder.build(_ListURLData.class, "resources").value();
        Assertions.assertThat((List)value).hasSize(1);
        Assertions.assertThat((String)((URL)value.get(0)).getPath()).isEqualTo((Object)"dir/test.xml");
    }

    @Test
    public void testDependencies() throws Exception {
        File dependency = this.newJarArtifact("a.txt");
        TestInputBuilder builder = TestInputBuilder.builder().withConfigurationXml("<resources><dependencies><dependency><groupId>g</groupId><artifactId>a</artifactId></dependency></dependencies><includes><include>a.txt</include></includes></resources>").withDependency("g:a", dependency);
        List value = (List)builder.build(_ListURLData.class, "resources").value();
        Assertions.assertThat((List)value).hasSize(1);
        Assertions.assertThat((String)((URL)value.get(0)).getPath()).isEqualTo((Object)"a.txt");
    }

    @Test
    public void testDependencyResources_inputFiles_jar() throws Exception {
        File dependency = this.newJarArtifact("a.txt");
        BuilderInputs inputs = TestInputBuilder.builder().withConfigurationXml("<resources><include>**/*</include></resources>").withDependency("g:a", dependency).build(_ListURLData.class);
        Assertions.assertThat((Iterable)inputs.inputFiles).contains((Object[])new Path[]{dependency.toPath()});
    }

    @Test
    public void testDependencyResources_inputFiles_dir() throws Exception {
        File dependency = this.newDirArtifact("a.txt");
        BuilderInputs inputs = TestInputBuilder.builder().withConfigurationXml("<resources><include>**/*</include></resources>").withDependency("g:a", dependency).build(_ListURLData.class);
        Assertions.assertThat((Iterable)inputs.inputFiles).contains((Object[])new Path[]{new File(dependency, "a.txt").toPath()});
    }

    @Test
    public void testMissingDependency() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("dependency g:a does not exist");
        TestInputBuilder.builder().withConfigurationXml("<resources><dependency><groupId>g</groupId><artifactId>a</artifactId></dependency><include>file.txt</include></resources>").build(_ListURLData.class, "resources");
    }

    @Test
    public void testMissingRequiredIncludes() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("_ListURLData.resources: <includes> is required");
        File dependency = this.newJarArtifact(new String[0]);
        TestInputBuilder.builder().withConfigurationXml("<resources><dependency><groupId>g</groupId><artifactId>a</artifactId></dependency></resources>").withDependency("g:a", dependency).build(_ListURLData.class, "resources");
    }

    @Test
    public void testEmptyDependencies() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("_ListURLData.resources: is required");
        TestInputBuilder.builder().withConfigurationXml("<resources><dependencies/><includes><include>a.txt</include></includes></resources>").build(_ListURLData.class, "resources");
    }

    @Test
    public void testDependenciesAndDependency() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("Use <dependencies> or <dependency>");
        TestInputBuilder.builder().withConfigurationXml("<resources><dependencies><dependency><groupId>g</groupId><artifactId>a</artifactId></dependency></dependencies><dependency><groupId>g</groupId><artifactId>a1</artifactId></dependency><includes><include>a.txt</include></includes></resources>").build(_ListURLData.class, "resources");
    }

    @Test
    public void testDependencyURLPath_dir() throws Exception {
        File dependency = this.newDirArtifact("a.txt");
        List resources = (List)TestInputBuilder.builder().withConfigurationXml("<resources><include>**/*</include></resources>").withDependency("g:a", dependency).build(_ListURLData.class, "resources").value();
        Assertions.assertThat((List)resources).extracting(u -> u.getPath()).containsExactly((Object[])new String[]{"a.txt"});
    }

    @Test
    public void testDependencyURLPath_jar() throws Exception {
        File dependency = this.newJarArtifact("a.txt");
        List resources = (List)TestInputBuilder.builder().withConfigurationXml("<resources><include>**/*</include></resources>").withDependency("g:a", dependency).build(_ListURLData.class, "resources").value();
        Assertions.assertThat((List)resources).extracting(u -> u.getPath()).containsExactly((Object[])new String[]{"a.txt"});
    }

    @Test
    public void testListURLOrder() throws Exception {
        File jarA = this.newJarArtifact("a.txt");
        File jarB = this.newJarArtifact("a.txt");
        List ab = (List)TestInputBuilder.builder().withConfigurationXml("<resources><include>**/*</include></resources>").withDependency("g:a", jarA).withDependency("g:b", jarB).build(_ListURLData.class, "resources").value();
        Assertions.assertThat((List)ab).extracting(u -> u.getHost()).containsExactly((Object[])new String[]{"[g:a:null]", "[g:b:null]"});
        List ba = (List)TestInputBuilder.builder().withConfigurationXml("<resources><include>**/*</include></resources>").withDependency("g:b", jarB).withDependency("g:a", jarA).build(_ListURLData.class, "resources").value();
        Assertions.assertThat((List)ba).extracting(u -> u.getHost()).containsExactly((Object[])new String[]{"[g:b:null]", "[g:a:null]"});
    }

    @Test
    public void testCollectionDependencyResources() throws Exception {
        File dependencyA = this.newJarArtifact("a.txt");
        File dependencyB = this.newJarArtifact("b.txt");
        TestInputBuilder builder = TestInputBuilder.builder().withConfigurationXml("<resources><resources><dependency><groupId>g</groupId><artifactId>a</artifactId></dependency><includes><include>**/a.txt</include></includes></resources><resources><dependency>g:b</dependency><include>**/b.txt</include></resources></resources>").withDependency("g:a", dependencyA).withDependency("g:b", dependencyB);
        List list = (List)builder.build(_ListArtifactResourcesData.class, "resources").value();
        Assertions.assertThat((List)list).hasSize(2);
        Assertions.assertThat((String)((URL)((IArtifactResources)list.get(0)).resources().iterator().next()).getPath()).isEqualTo((Object)"a.txt");
        Assertions.assertThat((String)((URL)((IArtifactResources)list.get(1)).resources().iterator().next()).getPath()).isEqualTo((Object)"b.txt");
    }

    @Test
    public void testDependencyWithoutMatchingResources() throws Exception {
        File dependencyA = this.newJarArtifact("a.txt");
        File dependencyB = this.newJarArtifact("b.txt");
        TestInputBuilder builder = TestInputBuilder.builder().withConfigurationXml("<resources><dependency>g:a</dependency><dependency>g:b</dependency><include>a.txt</include></resources>").withDependency("g:a", dependencyA).withDependency("g:b", dependencyB);
        List list = (List)builder.build(_ListArtifactResourcesData.class, "resources").value();
        ((ObjectAssert)((AbstractListAssert)Assertions.assertThat((List)list).hasSize(1)).extracting(r -> r.artifact().getArtifactId()).element(0)).isEqualTo((Object)"a");
    }

    @Test
    public void testNoMatchingDependencies() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(".resources: is required");
        File dependencyA = this.newJarArtifact("a.txt");
        File dependencyB = this.newJarArtifact("b.txt");
        TestInputBuilder.builder().withConfigurationXml("<resources><dependency>g:a</dependency><dependency>g:b</dependency><include>no-such-resource</include></resources>").withDependency("g:a", dependencyA).withDependency("g:b", dependencyB).build(_ListArtifactResourcesData.class, "resources");
    }

    @Test
    public void testResourceNameIncludesExcludes() throws Exception {
        File dependency = this.newJarArtifact("test.txt", "broken.txt");
        List urls = (List)TestInputBuilder.builder().withDependencies(dependency.getAbsolutePath()).build(_DataWithIncludesExcludes.class, "resources").value();
        Assertions.assertThat((List)urls).hasSize(1);
    }

    @Test
    public void testIncludesExcludesConfigurationNotAllowed() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        TestInputBuilder.builder().withConfigurationXml("<resources><includes><include>a.txt</include></includes></resources>").build(_DataWithIncludesExcludes.class, "resources");
    }

    @Test
    public void testArtifactResources() throws Exception {
        File dependencyA = this.newJarArtifact("a.txt");
        IArtifactResources resources = (IArtifactResources)TestInputBuilder.builder().withDependency("g:a", dependencyA).build(_ArtifactResourcesData.class, "resources").value();
        Assertions.assertThat((String)resources.artifact().getArtifactId()).isEqualTo((Object)"a");
        Assertions.assertThat((Iterable)resources.resources()).hasSize(1);
    }

    @Test
    public void testArtifactResources_noMatchingResources() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(".resources: is required");
        File dependencyA = this.newJarArtifact("a.not-txt");
        TestInputBuilder.builder().withDependency("g:a", dependencyA).build(_ArtifactResourcesData.class, "resources");
    }

    @Test
    public void testArrayResources() throws Exception {
        File dependency = this.newJarArtifact("a.txt");
        Object[] urls = (URL[])TestInputBuilder.builder().withDependencies(dependency.getAbsolutePath()).build(_ArrayResourceData.class, "resources").value();
        Assertions.assertThat((Object[])urls).hasSize(1);
    }

    static class _ArrayResourceData {
        @DependencyResources(includes={"**/*.txt"}, scope=ResolutionScope.COMPILE)
        URL[] resources;

        _ArrayResourceData() {
        }
    }

    static class _ArtifactResourcesData {
        @DependencyResources(resourcesRequired=true, scope=ResolutionScope.COMPILE, includes={"**/*.txt"})
        IArtifactResources resources;

        _ArtifactResourcesData() {
        }
    }

    static class _DataWithIncludesExcludes {
        @DependencyResources(resourcesRequired=true, includes={"**/*.txt"}, excludes={"**/broken.txt"}, scope=ResolutionScope.COMPILE)
        List<URL> resources;

        _DataWithIncludesExcludes() {
        }
    }

    static class _ListArtifactResourcesData {
        @DependencyResources(resourcesRequired=true, scope=ResolutionScope.COMPILE)
        List<IArtifactResources> resources;

        _ListArtifactResourcesData() {
        }
    }

    static class _ListURLData {
        @DependencyResources(resourcesRequired=true, scope=ResolutionScope.COMPILE)
        List<URL> resources;

        _ListURLData() {
        }
    }
}

