/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.InputFile;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.TestInputBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class FileInputTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDigest() throws Exception {
        BuilderInputs.Digest digest = BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.InputFileValue(File.class, new File("a").toPath()));
        Assert.assertEquals((Object)digest, (Object)BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.InputFileValue(File.class, new File("a").toPath())));
        Assert.assertNotEquals((Object)digest, (Object)BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.InputFileValue(File.class, new File("b").toPath())));
    }

    @Test
    public void testInputFile() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File file = new File(basedir, "a.txt");
        file.createNewFile();
        BuilderInputs.InputFileValue fileInput = (BuilderInputs.InputFileValue)TestInputBuilder.builder(basedir).withConfigurationXml("<file>a.txt</file>").build(_Data.class, "file");
        Assert.assertEquals((Object)file, (Object)fileInput.value());
    }

    @Test
    public void testInputFile_isDirectory() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("a.txt is a directory");
        File basedir = this.temp.newFolder().getCanonicalFile();
        new File(basedir, "a.txt").mkdirs();
        TestInputBuilder.builder(basedir).withConfigurationXml("<file>a.txt</file>").build(_Data.class, "file");
    }

    @Test
    public void testInputFileDoesNotExist() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("_Data.file: is required");
        File basedir = this.temp.newFolder().getCanonicalFile();
        TestInputBuilder.builder(basedir).withConfigurationXml("<file>a.txt</file>").build(_Data.class, "file");
    }

    @Test
    public void testPathInputFile() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        Path path = Paths.get(basedir.getCanonicalPath(), "a.txt");
        Files.createFile(path, new FileAttribute[0]);
        BuilderInputs.InputFileValue fileInput = (BuilderInputs.InputFileValue)TestInputBuilder.builder(basedir).withConfigurationXml("<file>a.txt</file>").build(_PathData.class, "file");
        Assert.assertEquals((Object)path, (Object)fileInput.value());
    }

    @Test
    public void testOptionalFile() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderInputs.InputFileValue fileInput = (BuilderInputs.InputFileValue)TestInputBuilder.builder(basedir).build(_OptionalData.class, "file");
        Assert.assertNull((Object)fileInput);
    }

    @Test
    public void testOptionalFileDoesNotExist() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderInputs.InputFileValue fileInput = (BuilderInputs.InputFileValue)TestInputBuilder.builder(basedir).withConfigurationXml("<file>a.txt</file>").build(_OptionalData.class, "file");
        Assert.assertEquals((Object)new File(basedir, "a.txt"), (Object)fileInput.value());
    }

    @Test
    public void testOptionalFileExists() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        new File(basedir, "a.txt").createNewFile();
        File file = (File)TestInputBuilder.builder(basedir).withConfigurationXml("<file>a.txt</file>").build(_OptionalData.class, "file").value();
        Assert.assertEquals((Object)new File(basedir, "a.txt"), (Object)file);
    }

    @Test
    public void testOptionalFile_isDirectory() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("a.txt is a directory");
        File basedir = this.temp.newFolder().getCanonicalFile();
        new File(basedir, "a.txt").mkdirs();
        TestInputBuilder.builder(basedir).withConfigurationXml("<file>a.txt</file>").build(_OptionalData.class, "file");
    }

    @Test
    public void testDefaultValueInputFile() throws Exception {
        File basedir = this.temp.newFolder();
        File file = new File(basedir, "1.txt");
        file.createNewFile();
        BuilderInputs.InputFileValue input = (BuilderInputs.InputFileValue)TestInputBuilder.builder(basedir).build(_DefaultValueData.class, "parameter");
        Assert.assertEquals((Object)file.getCanonicalFile(), (Object)input.value());
    }

    @Test
    public void testMultivalueInputFile() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        new File(basedir, "1.txt").createNewFile();
        new File(basedir, "2.txt").createNewFile();
        BuilderInputs.CollectionValue input = (BuilderInputs.CollectionValue)TestInputBuilder.builder(basedir).build(_ListFileData.class, "parameter");
        Assert.assertEquals((Object)new File(basedir, "1.txt"), (Object)((BuilderInputs.Value)input.configuration.get(0)).value());
        Assert.assertEquals((Object)new File(basedir, "2.txt"), (Object)((BuilderInputs.Value)input.configuration.get(1)).value());
    }

    @Test
    public void testListFileOptional_emptyConfiguration() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderInputs.CollectionValue value = (BuilderInputs.CollectionValue)TestInputBuilder.builder(basedir).build(_ListFileOptionalData.class, "files");
        Assert.assertNull((Object)value);
    }

    @Test
    public void testListFileOptional_allFilesDoNotExist() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderInputs.CollectionValue value = (BuilderInputs.CollectionValue)TestInputBuilder.builder(basedir).withConfigurationXml("<files><file>1.txt</file><file>2.txt</file></files>").build(_ListFileOptionalData.class, "files");
        Assert.assertEquals(Arrays.asList(new File(basedir, "1.txt"), new File(basedir, "2.txt")), (Object)value.value());
    }

    @Test
    public void testListFileOptional_someFilesDoNotExist() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        new File(basedir, "1.txt").createNewFile();
        List files = (List)TestInputBuilder.builder(basedir).withConfigurationXml("<files><file>1.txt</file><file>2.txt</file></files>").build(_ListFileOptionalData.class, "files").value();
        Assert.assertEquals(Arrays.asList(new File(basedir, "1.txt"), new File(basedir, "2.txt")), (Object)files);
    }

    @Test
    public void testCompileSourceRootsAsInputFileFails() throws Exception {
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(String.format("_CompileSourceRoots.thisShouldFail.thisShouldFail: %s expression is not allowed here", "${project.compileSourceRoots}"));
        TestInputBuilder.builder(this.temp.getRoot()).withCompileSourceRoot(dir1.getCanonicalPath()).withCompileSourceRoot(dir2.getCanonicalPath()).build(_CompileSourceRoots.class, "thisShouldFail");
    }

    @Test
    public void testTestCompileSourceRootsAsInputFileFails() throws Exception {
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(String.format("_CompileSourceRoots.thisToo.thisToo: %s expression is not allowed here", "${project.testCompileSourceRoots}"));
        TestInputBuilder.builder(this.temp.getRoot()).withTestCompileSourceRoot(dir1.getCanonicalPath()).withTestCompileSourceRoot(dir2.getCanonicalPath()).build(_CompileSourceRoots.class, "thisToo");
    }

    static class _CompileSourceRoots {
        @InputFile(value={"${project.compileSourceRoots}"})
        public List<File> thisShouldFail;
        @InputFile(value={"${project.testCompileSourceRoots}"})
        public List<File> thisToo;

        _CompileSourceRoots() {
        }
    }

    static class _Data {
        @InputFile(fileRequired=true)
        File file;

        _Data() {
        }
    }

    static class _DefaultValueData {
        @InputFile(defaultValue={"1.txt"})
        public File parameter;

        _DefaultValueData() {
        }
    }

    static class _ListFileData {
        @InputFile(defaultValue={"1.txt", "2.txt"})
        public List<File> parameter;

        _ListFileData() {
        }
    }

    static class _ListFileOptionalData {
        @InputFile(fileRequired=false)
        public List<File> files;

        _ListFileOptionalData() {
        }
    }

    static class _OptionalData {
        @InputFile(fileRequired=false)
        File file;

        _OptionalData() {
        }
    }

    static class _PathData {
        @InputFile(fileRequired=true)
        Path file;

        _PathData() {
        }
    }
}

