/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.GeneratedResourcesDirectory;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.ResourceRoot;
import io.takari.builder.internal.TestInputBuilder;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GeneratedResourcesDirectoryTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testConfigurationOverrides() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderInputs.GeneratedResourcesDirectoryValue value = (BuilderInputs.GeneratedResourcesDirectoryValue)TestInputBuilder.builder(basedir).withConfigurationXml("<resources>config</resources>").build(_DefaultTestData.class, "resources");
        this.assertValue(value, new File(basedir, "config"), "[**/*.default.include]", "[**/*.default.exclude]");
        value = (BuilderInputs.GeneratedResourcesDirectoryValue)TestInputBuilder.builder(basedir).withConfigurationXml("<resources><location>config</location></resources>").build(_DefaultTestData.class, "resources");
        this.assertValue(value, new File(basedir, "config"), "[**/*.default.include]", "[**/*.default.exclude]");
        value = (BuilderInputs.GeneratedResourcesDirectoryValue)TestInputBuilder.builder(basedir).withConfigurationXml("<resources><location>config</location><includes><include>**/*.config.include</include></includes><excludes><exclude>**/*.config.exclude</exclude></excludes></resources>").build(_DefaultTestData.class, "resources");
        this.assertValue(value, new File(basedir, "config"), "[**/*.config.include]", "[**/*.config.exclude]");
    }

    @Test
    public void testInvalidResourcesConfiguration() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderInputs.GeneratedResourcesDirectoryValue value = (BuilderInputs.GeneratedResourcesDirectoryValue)TestInputBuilder.builder(basedir).withConfigurationXml("<resources>config</resources>").build(_TestData.class, "resources");
        this.assertValue(value, new File(basedir, "value"), "[**/*.include]", "[**/*.exclude]");
    }

    @Test
    public void testInvalidLocationConfiguration() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderInputs.GeneratedResourcesDirectoryValue value = (BuilderInputs.GeneratedResourcesDirectoryValue)TestInputBuilder.builder(basedir).withConfigurationXml("<resources><location>config</location></resources>").build(_TestData.class, "resources");
        this.assertValue(value, new File(basedir, "value"), "[**/*.include]", "[**/*.exclude]");
    }

    @Test(expected=BuilderInputsBuilder.InvalidConfigurationException.class)
    public void testInvalidIncludesExcludesConfiguration() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        TestInputBuilder.builder(basedir).withConfigurationXml("<resources><includes><include>**/*.config.include</include></includes><excludes><exclude>**/*.config.exclude</exclude></excludes></resources>").build(_TestData.class, "resources");
    }

    @Test
    public void testResourceRoots() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderInputs inputs = TestInputBuilder.builder(basedir).withConfigurationXml("<resources><location>config</location><includes><include>**/*.config.include</include></includes><excludes><exclude>**/*.config.exclude</exclude></excludes></resources>").build(_DefaultTestData.class);
        ArrayList roots = new ArrayList(inputs.getResourceRoots());
        Assert.assertEquals((long)1L, (long)roots.size());
        Assert.assertEquals((Object)new File(basedir, "config").getCanonicalPath(), (Object)((ResourceRoot)roots.get(0)).getLocation());
        Assert.assertEquals((Object)"[**/*.config.include]", (Object)((ResourceRoot)roots.get(0)).getIncludes().toString());
        Assert.assertEquals((Object)"[**/*.config.exclude]", (Object)((ResourceRoot)roots.get(0)).getExcludes().toString());
    }

    @Test
    public void testPathTarget() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderInputs.GeneratedResourcesDirectoryValue value = (BuilderInputs.GeneratedResourcesDirectoryValue)TestInputBuilder.builder(basedir).withConfigurationXml("<resources>config</resources>").build(_DefaultPathTestData.class, "resources");
        Assert.assertEquals((Object)Paths.get(basedir.getCanonicalPath(), "config"), (Object)value.value());
    }

    private void assertValue(BuilderInputs.GeneratedResourcesDirectoryValue value, File file, String includes, String excludes) {
        Assert.assertEquals((Object)file, (Object)value.value());
        Assert.assertEquals((Object)includes, (Object)value.includes.toString());
        Assert.assertEquals((Object)excludes, (Object)value.excludes.toString());
    }

    class _DefaultPathTestData {
        @GeneratedResourcesDirectory(defaultValue={"default"}, defaultIncludes={"**/*.default.include"}, defaultExcludes={"**/*.default.exclude"})
        Path resources;

        _DefaultPathTestData() {
        }
    }

    class _DefaultTestData {
        @GeneratedResourcesDirectory(defaultValue={"default"}, defaultIncludes={"**/*.default.include"}, defaultExcludes={"**/*.default.exclude"})
        File resources;

        _DefaultTestData() {
        }
    }

    class _TestData {
        @GeneratedResourcesDirectory(value={"value"}, includes={"**/*.include"}, excludes={"**/*.exclude"})
        File resources;

        _TestData() {
        }
    }
}

