/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.GeneratedSourcesDirectory;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.CompileSourceRoot;
import io.takari.builder.internal.TestInputBuilder;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GeneratedSourcesDirectoryTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testAnnotation() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderInputs.GeneratedSourcesDirectoryValue value = (BuilderInputs.GeneratedSourcesDirectoryValue)TestInputBuilder.builder(basedir).withConfigurationXml("<dir>generated</dir>").build(_Data.class, "dir");
        Assert.assertEquals((Object)new File(basedir, "generated"), (Object)value.value());
    }

    @Test
    public void testCompileSourceRoots() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderInputs inputs = TestInputBuilder.builder(basedir).withConfigurationXml("<dir>generated</dir>").build(_Data.class);
        ArrayList roots = new ArrayList(inputs.getCompileSourceRoots());
        Assert.assertEquals((long)1L, (long)roots.size());
        Assert.assertEquals((Object)new File(basedir, "generated").getCanonicalPath(), (Object)((CompileSourceRoot)roots.get(0)).getPath());
    }

    @Test
    public void testPathAnnotation() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        BuilderInputs.GeneratedSourcesDirectoryValue value = (BuilderInputs.GeneratedSourcesDirectoryValue)TestInputBuilder.builder(basedir).withConfigurationXml("<dir>generated</dir>").build(_PathData.class, "dir");
        Assert.assertEquals((Object)Paths.get(basedir.getCanonicalPath(), "generated"), (Object)value.value());
    }

    static class _Data {
        @GeneratedSourcesDirectory
        File dir;

        _Data() {
        }
    }

    static class _PathData {
        @GeneratedSourcesDirectory
        Path dir;

        _PathData() {
        }
    }
}

