/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.IDirectoryFiles;
import io.takari.builder.InputDirectoryFiles;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.DirAssert;
import io.takari.builder.internal.TestInputBuilder;
import io.takari.maven.testing.TestMavenRuntime;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class InputDirectoryFilesTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDirectoryFiles() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        new File(basedir, "1.txt").createNewFile();
        BuilderInputs.InputDirectoryValue input = (BuilderInputs.InputDirectoryValue)TestInputBuilder.builder(basedir).build(_Data.class, "files");
        Assert.assertEquals((Object)basedir.getCanonicalFile(), (Object)input.location());
        Assert.assertNull((Object)input.excludes);
        Assert.assertEquals(Collections.singleton("**/*.txt"), (Object)input.includes);
        DirAssert.assertFiles(input.files(), new File(basedir, "1.txt"));
    }

    @Test
    public void testDirectoryFiles_directoryDoesNotExist() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("_Data.files: is required");
        TestInputBuilder.builder(new File(this.temp.newFolder(), "not-there")).build(_Data.class, "files");
    }

    @Test
    public void testDirectoryFiles_isFile() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("is a regular file");
        TestInputBuilder.builder(this.temp.newFile()).build(_Data.class, "files");
    }

    @Test
    public void testDirectoryFiles_noMatchingFiles() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("_Data.files: is required");
        TestInputBuilder.builder(this.temp.newFolder()).build(_Data.class, "files");
    }

    @Test
    public void testInputDirectories() throws Exception {
        File dir1 = this.temp.newFolder().getCanonicalFile();
        new File(dir1, "1.txt").createNewFile();
        File dir2 = this.temp.newFolder().getCanonicalFile();
        new File(dir2, "2.txt").createNewFile();
        new File(dir2, "2.not-txt").createNewFile();
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom directories = new Xpp3Dom("directories");
        configuration.addChild(directories);
        directories.addChild(this.newDirectory(dir1));
        directories.addChild(this.newDirectory(dir2));
        BuilderInputs.CollectionValue input = (BuilderInputs.CollectionValue)TestInputBuilder.builder(this.temp.getRoot()).withConfiguration(configuration).build(_ListDirectoryFilesData.class, "directories");
        Assert.assertEquals((long)2L, (long)input.configuration.size());
        Assert.assertEquals((Object)dir1, (Object)((BuilderInputs.InputDirectoryValue)input.configuration.get(0)).location());
        Assert.assertEquals((Object)dir2, (Object)((BuilderInputs.InputDirectoryValue)input.configuration.get(1)).location());
    }

    @Test
    public void testInputDirectories_someDoNotExistOrEmpty() throws Exception {
        File dir1 = this.temp.newFolder().getCanonicalFile();
        new File(dir1, "1.txt").createNewFile();
        File empty = this.temp.newFolder().getCanonicalFile();
        File notthere = new File(this.temp.newFolder().getCanonicalFile(), "not-there");
        Xpp3Dom configurationXml = new Xpp3Dom("configuration");
        Xpp3Dom directoriesXml = new Xpp3Dom("directories");
        configurationXml.addChild(directoriesXml);
        directoriesXml.addChild(this.newDirectory(dir1));
        directoriesXml.addChild(this.newDirectory(empty));
        directoriesXml.addChild(this.newDirectory(notthere));
        List directories = (List)TestInputBuilder.builder(this.temp.getRoot()).withConfiguration(configurationXml).build(_ListDirectoryFilesData.class, "directories").value();
        ((ObjectAssert)((AbstractListAssert)Assertions.assertThat((List)directories).hasSize(1)).extracting(d -> d.location()).element(0)).isEqualTo((Object)dir1);
    }

    @Test
    public void testInputDirectories_allDoNotExistOrEmpty() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("_ListDirectoryFilesData.directories: is required");
        File empty = this.temp.newFolder().getCanonicalFile();
        File notthere = new File(this.temp.newFolder().getCanonicalFile(), "not-there");
        Xpp3Dom configurationXml = new Xpp3Dom("configuration");
        Xpp3Dom directoriesXml = new Xpp3Dom("directories");
        configurationXml.addChild(directoriesXml);
        directoriesXml.addChild(this.newDirectory(empty));
        directoriesXml.addChild(this.newDirectory(notthere));
        TestInputBuilder.builder(this.temp.getRoot()).withConfiguration(configurationXml).build(_ListDirectoryFilesData.class, "directories").value();
    }

    private Xpp3Dom newDirectory(File location) {
        Xpp3Dom dir = new Xpp3Dom("files");
        dir.addChild(TestMavenRuntime.newParameter((String)"location", (String)location.getAbsolutePath()));
        return dir;
    }

    @Test
    public void testMultivalueWithoutLocation_required() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        TestInputBuilder.builder(this.temp.getRoot()).withConfigurationXml("<directories><files><excludes><e>e.txt</e></excludes></files></directories>").build(_ListDirectoryFilesData.class, "directories");
    }

    @Test
    public void testOptional() throws Exception {
        File basedir = this.temp.newFolder();
        new File(basedir, "1.txt").createNewFile();
        Assert.assertNull(TestInputBuilder.builder(basedir).build(_OptionalData.class, "directory"));
        Assert.assertNull(TestInputBuilder.builder(basedir).build(_OptionalData.class, "directories"));
    }

    @Test
    public void testOptional_isFile() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("is a regular file");
        TestInputBuilder.builder(this.temp.newFile()).withConfigurationXml("<directory>.</directory>").build(_OptionalData.class, "directory");
    }

    @Test
    public void testMultivalueWithoutLocation_optional() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("<location> element is required");
        TestInputBuilder.builder(this.temp.getRoot()).withConfigurationXml("<directories><files><excludes><e>e.txt</e></excludes></files></directories>").build(_OptionalData.class, "directories");
    }

    @Test
    public void testOptional_directoryDoesNotExist() throws Exception {
        File basedir = this.temp.getRoot().getCanonicalFile();
        IDirectoryFiles files = (IDirectoryFiles)TestInputBuilder.builder(basedir).withConfigurationXml("<directory>not-there</directory>").build(_OptionalData.class, "directory").value();
        Assertions.assertThat((File)files.location()).doesNotExist();
        Assertions.assertThat((File)files.location()).isEqualTo((Object)new File(basedir, "not-there"));
        Assertions.assertThat((Iterable)files.files()).isEmpty();
    }

    @Test
    public void testOptional_directoriesDoNotExist() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        List directories = (List)TestInputBuilder.builder(basedir).withConfigurationXml("<directories><location>not-there</location></directories>").build(_OptionalData.class, "directories").value();
        Assertions.assertThat((List)directories).hasSize(1);
        Assertions.assertThat((File)((IDirectoryFiles)directories.get(0)).location()).doesNotExist();
        Assertions.assertThat((File)((IDirectoryFiles)directories.get(0)).location()).isEqualTo((Object)new File(basedir, "not-there"));
        Assertions.assertThat((Iterable)((IDirectoryFiles)directories.get(0)).files()).isEmpty();
    }

    @Test
    public void testListFile() throws Exception {
        File dir1 = this.temp.newFolder().getCanonicalFile();
        new File(dir1, "1.txt").createNewFile();
        new File(dir1, "2.txt").createNewFile();
        List files = (List)TestInputBuilder.builder(this.temp.getRoot()).build(_ListFileData.class, "files").value();
        Assertions.assertThat((List)files).hasSize(2);
        Assertions.assertThat((File)((File)files.get(0))).isInstanceOf(File.class);
    }

    @Test
    public void testListFile_requiredEmpty() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(".files: is required");
        TestInputBuilder.builder(this.temp.newFolder()).build(_ListFileData.class, "files");
    }

    @Test
    public void testArrayFile() throws Exception {
        File dir1 = this.temp.newFolder().getCanonicalFile();
        new File(dir1, "1.txt").createNewFile();
        new File(dir1, "2.txt").createNewFile();
        Object[] files = (File[])TestInputBuilder.builder(this.temp.getRoot()).build(_ArrayFileData.class, "files").value();
        Assertions.assertThat((Object[])files).hasSize(2);
        Assertions.assertThat((Object[])files).isInstanceOf(File[].class);
    }

    @Test
    public void testListPath() throws Exception {
        File dir1 = this.temp.newFolder().getCanonicalFile();
        new File(dir1, "1.txt").createNewFile();
        new File(dir1, "2.txt").createNewFile();
        List files = (List)TestInputBuilder.builder(this.temp.getRoot()).build(_ListPathData.class, "files").value();
        Assertions.assertThat((List)files).hasSize(2);
        Assertions.assertThat(Path.class).isAssignableFrom(new Class[]{((Path)files.get(0)).getClass()});
    }

    @Test
    public void testNoIncludes() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("<includes> is required");
        File basedir = this.temp.newFolder();
        new File(basedir, "1.txt").createNewFile();
        TestInputBuilder.builder(basedir).build(_NoIncludesData.class, "files");
    }

    @Test
    public void testCompileSourceRoots() throws Exception {
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        File file = new File(dir1, "file.txt");
        file.createNewFile();
        BuilderInputs.CollectionValue input = (BuilderInputs.CollectionValue)TestInputBuilder.builder(this.temp.getRoot()).withCompileSourceRoot(dir1.getCanonicalPath()).withCompileSourceRoot(dir2.getCanonicalPath()).build(_CompileSourceRoots.class, "compileSourceRootFiles");
        Assertions.assertThat((List)input.configuration).hasSize(1);
        Assert.assertEquals((Object)dir1.getCanonicalPath(), (Object)((IDirectoryFiles)input.configuration.get(0)).location().getCanonicalPath());
    }

    @Test
    public void testTestCompileSourceRoots() throws Exception {
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        File file = new File(dir1, "file.txt");
        file.createNewFile();
        BuilderInputs.CollectionValue input = (BuilderInputs.CollectionValue)TestInputBuilder.builder(this.temp.getRoot()).withTestCompileSourceRoot(dir1.getCanonicalPath()).withTestCompileSourceRoot(dir2.getCanonicalPath()).build(_CompileSourceRoots.class, "testCompileSourceRootFiles");
        Assertions.assertThat((List)input.configuration).hasSize(1);
        Assert.assertEquals((Object)dir1.getCanonicalPath(), (Object)((IDirectoryFiles)input.configuration.get(0)).location().getCanonicalPath());
    }

    @Test
    public void testCompileSourceRootsExtraParams() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(String.format("%s can not have other values provided along with it", "${project.compileSourceRoots}"));
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        TestInputBuilder.builder(this.temp.getRoot()).withCompileSourceRoot(dir1.getCanonicalPath()).withCompileSourceRoot(dir2.getCanonicalPath()).build(_CompileSourceRoots.class, "compileSourceRootBadFiles");
    }

    @Test
    public void testTestCompileSourceRootsExtraParams() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(String.format("%s can not have other values provided along with it", "${project.testCompileSourceRoots}"));
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        TestInputBuilder.builder(this.temp.getRoot()).withTestCompileSourceRoot(dir1.getCanonicalPath()).withTestCompileSourceRoot(dir2.getCanonicalPath()).build(_CompileSourceRoots.class, "testCompileSourceRootBadFiles");
    }

    @Test
    public void testRequiredCompileSourceRootFailsWithoutSourceRoots() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("_CompileSourceRoots.compileSourceRootFiles: is required");
        TestInputBuilder.builder(this.temp.getRoot()).build(_CompileSourceRoots.class, "compileSourceRootFiles");
    }

    @Test
    public void testConfiguredCompileSourceRootsFails() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(String.format("_Data.files: %s expression is not allowed in configuration", "${project.compileSourceRoots}"));
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        TestInputBuilder.builder(this.temp.getRoot()).withCompileSourceRoot(dir1.getCanonicalPath()).withCompileSourceRoot(dir2.getCanonicalPath()).withConfigurationXml(String.format("<files><files><location>%s</location></files></files>", "${project.compileSourceRoots}")).build(_Data.class, "files");
    }

    @Test
    public void testConfiguredTestCompileSourceRootsFails() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(String.format("_Data.files: %s expression is not allowed in configuration", "${project.testCompileSourceRoots}"));
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        TestInputBuilder.builder(this.temp.getRoot()).withTestCompileSourceRoot(dir1.getCanonicalPath()).withTestCompileSourceRoot(dir2.getCanonicalPath()).withConfigurationXml(String.format("<files><files><location>%s</location></files></files>", "${project.testCompileSourceRoots}")).build(_Data.class, "files");
    }

    @Test
    public void testSpecificFile() throws Exception {
        File dir = this.temp.newFolder().getCanonicalFile();
        File file = new File(dir, "1.txt");
        file.createNewFile();
        new File(dir, "2.txt").createNewFile();
        Object[] files = (File[])TestInputBuilder.builder(dir).build(_ArraySpecificFileData.class, "files").value();
        Assertions.assertThat((Object[])files).containsExactly((Object[])new File[]{file});
    }

    static class _ArrayFileData {
        @InputDirectoryFiles(defaultValue={"."}, includes={"**/*.txt"})
        File[] files;

        _ArrayFileData() {
        }
    }

    static class _ArraySpecificFileData {
        @InputDirectoryFiles(defaultValue={"."}, includes={"1.txt"})
        File[] files;

        _ArraySpecificFileData() {
        }
    }

    static class _CompileSourceRoots {
        @InputDirectoryFiles(filesRequired=true, value={"${project.compileSourceRoots}"}, includes={"**/*"})
        public List<IDirectoryFiles> compileSourceRootFiles;
        @InputDirectoryFiles(filesRequired=true, value={"${project.compileSourceRoots}", "/bad"}, includes={"**/*"})
        public List<IDirectoryFiles> compileSourceRootBadFiles;
        @InputDirectoryFiles(filesRequired=true, value={"${project.testCompileSourceRoots}"}, includes={"**/*"})
        public List<IDirectoryFiles> testCompileSourceRootFiles;
        @InputDirectoryFiles(filesRequired=true, value={"${project.testCompileSourceRoots}", "/bad"}, includes={"**/*"})
        public List<IDirectoryFiles> testCompileSourceRootBadFiles;

        _CompileSourceRoots() {
        }
    }

    static class _Data {
        @InputDirectoryFiles(filesRequired=true, defaultValue={"."}, includes={"**/*.txt"})
        public IDirectoryFiles files;

        _Data() {
        }
    }

    static class _ListDirectoryFilesData {
        @InputDirectoryFiles(filesRequired=true, defaultValue={"."}, includes={"**/*.txt"})
        public List<IDirectoryFiles> directories;

        _ListDirectoryFilesData() {
        }
    }

    static class _ListFileData {
        @InputDirectoryFiles(filesRequired=true, defaultValue={"."}, includes={"**/*.txt"})
        List<File> files;

        _ListFileData() {
        }
    }

    static class _ListPathData {
        @InputDirectoryFiles(filesRequired=true, defaultValue={"."}, includes={"**/*.txt"})
        List<Path> files;

        _ListPathData() {
        }
    }

    static class _NoIncludesData {
        @InputDirectoryFiles(defaultValue={"."})
        public IDirectoryFiles files;

        _NoIncludesData() {
        }
    }

    static class _OptionalData {
        @InputDirectoryFiles(filesRequired=false, includes={"**/*"})
        public IDirectoryFiles directory;
        @InputDirectoryFiles(filesRequired=false, includes={"**/*"})
        public List<IDirectoryFiles> directories;

        _OptionalData() {
        }
    }
}

