/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.InputDirectory;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.DirAssert;
import io.takari.builder.internal.TestInputBuilder;
import io.takari.maven.testing.TestMavenRuntime;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class InputDirectoryTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testInputDirectory() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        new File(basedir, "1.txt").createNewFile();
        BuilderInputs.InputDirectoryValue input = (BuilderInputs.InputDirectoryValue)TestInputBuilder.builder(basedir).build(_Data.class, "directory");
        Assert.assertEquals((Object)basedir.getCanonicalFile(), (Object)input.value());
        Assert.assertNull((Object)input.excludes);
        Assert.assertEquals(Collections.singleton("**/*.txt"), (Object)input.includes);
        DirAssert.assertFiles(input.files(), new File(basedir, "1.txt"));
        BuilderInputs inputs = TestInputBuilder.builder(basedir).build(_Data.class);
        DirAssert.assertFiles(this.pathToFile(inputs.inputFiles), new File(basedir, "1.txt"));
    }

    @Test
    public void testInputDirectory_noMatchingFiles() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("_Data.directory: is required");
        File basedir = this.temp.newFolder().getCanonicalFile();
        new File(basedir, "data.bin").createNewFile();
        TestInputBuilder.builder(basedir).build(_Data.class, "directory");
    }

    @Test
    public void testInputDirectory_isFile() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("is a regular file");
        TestInputBuilder.builder(this.temp.newFile()).build(_Data.class, "directory");
    }

    @Test
    public void testInputDirectory_doesNotExist() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("_Data.directory: is required");
        File basedir = new File(this.temp.newFolder(), "nothing");
        BuilderInputs.InputDirectoryValue input = (BuilderInputs.InputDirectoryValue)TestInputBuilder.builder(basedir).build(_Data.class, "directory");
        Assert.assertEquals((Object)basedir.getCanonicalFile(), (Object)input.location);
        Assert.assertNull((Object)input.excludes);
        Assert.assertEquals(Collections.singleton("**/*.txt"), (Object)input.includes);
        DirAssert.assertFiles(input.files, new File[0]);
    }

    @Test
    public void testPathInputDirectory() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        Path path = Paths.get(basedir.getCanonicalPath(), new String[0]);
        new File(basedir, "1.txt").createNewFile();
        BuilderInputs.InputDirectoryValue input = (BuilderInputs.InputDirectoryValue)TestInputBuilder.builder(basedir).build(_PathData.class, "directory");
        Assert.assertEquals((Object)path, (Object)input.value());
        Assert.assertNull((Object)input.excludes);
        Assert.assertEquals(Collections.singleton("**/*.txt"), (Object)input.includes);
        DirAssert.assertFiles(input.files(), new File(basedir, "1.txt"));
        BuilderInputs inputs = TestInputBuilder.builder(basedir).build(_PathData.class);
        DirAssert.assertFiles(this.pathToFile(inputs.inputFiles), new File(basedir, "1.txt"));
    }

    @Test
    public void testInputDirectories() throws Exception {
        File dir1 = this.temp.newFolder().getCanonicalFile();
        new File(dir1, "1.txt").createNewFile();
        File dir2 = this.temp.newFolder().getCanonicalFile();
        new File(dir2, "2.txt").createNewFile();
        new File(dir2, "2.not-txt").createNewFile();
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom directories = new Xpp3Dom("directories");
        configuration.addChild(directories);
        directories.addChild(this.newDirectory(dir1));
        directories.addChild(this.newDirectory(dir2));
        BuilderInputs.CollectionValue input = (BuilderInputs.CollectionValue)TestInputBuilder.builder(this.temp.getRoot()).withConfiguration(configuration).build(_ListFileData.class, "directories");
        Assert.assertEquals((long)2L, (long)input.configuration.size());
        Assert.assertEquals((Object)dir1, (Object)((BuilderInputs.InputDirectoryValue)input.configuration.get(0)).value());
        Assert.assertEquals((Object)dir2, (Object)((BuilderInputs.InputDirectoryValue)input.configuration.get(1)).value());
    }

    private Xpp3Dom newDirectory(File location) {
        Xpp3Dom dir = new Xpp3Dom("directory");
        dir.addChild(TestMavenRuntime.newParameter((String)"location", (String)location.getAbsolutePath()));
        return dir;
    }

    @Test
    public void testInputDirectories_noLocationConfiguration() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        TestInputBuilder.builder(this.temp.getRoot()).withConfigurationXml("<directories><d><excludes><e>e.txt</e></excludes></d></directories>").build(_ListFileData.class, "directories");
    }

    @Test
    public void testOptional_noConfiguration() throws Exception {
        File basedir = this.temp.newFolder();
        new File(basedir, "1.txt").createNewFile();
        Assert.assertNull(TestInputBuilder.builder(basedir).build(_OptionalData.class, "directory"));
        Assert.assertNull(TestInputBuilder.builder(basedir).build(_OptionalData.class, "directories"));
    }

    @Test
    public void testOptionalInputDirectories_noLocationConfiguration() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        TestInputBuilder.builder(this.temp.getRoot()).withConfigurationXml("<directories><d><excludes><e>e.txt</e></excludes></d></directories>").build(_OptionalData.class, "directories");
    }

    @Test
    public void testOptional_directoryDoesNotExist() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File dir1 = new File(basedir, "not-there-1");
        File dir2 = new File(basedir, "not-there-2");
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom directories = new Xpp3Dom("directories");
        configuration.addChild(directories);
        directories.addChild(this.newDirectory(dir1));
        directories.addChild(this.newDirectory(dir2));
        BuilderInputs.CollectionValue input = (BuilderInputs.CollectionValue)TestInputBuilder.builder(basedir).withConfiguration(configuration).build(_OptionalData.class, "directories");
        Assert.assertEquals((long)2L, (long)input.configuration.size());
        Assert.assertEquals((Object)dir1, (Object)((BuilderInputs.InputDirectoryValue)input.configuration.get(0)).value());
        Assert.assertEquals((Object)dir2, (Object)((BuilderInputs.InputDirectoryValue)input.configuration.get(1)).value());
        BuilderInputs inputs = TestInputBuilder.builder(basedir).withConfiguration(configuration).build(_OptionalData.class);
        Assert.assertTrue((boolean)inputs.inputFiles.isEmpty());
    }

    static BuilderInputs.InputDirectoryValue newInputDirectoryFiles(Path location, String includes, String excludes) {
        return new BuilderInputs.InputDirectoryValue(File.class, location, Collections.singletonList(includes), Collections.singletonList(excludes), Collections.emptySet(), Collections.emptySet());
    }

    @Test
    public void testDigest() throws Exception {
        BuilderInputs.Digest digest = BuilderInputs.digest((BuilderInputs.Value)InputDirectoryTest.newInputDirectoryFiles(new File("a").toPath(), "i", "e"));
        Assert.assertEquals((Object)digest, (Object)BuilderInputs.digest((BuilderInputs.Value)InputDirectoryTest.newInputDirectoryFiles(new File("a").toPath(), "i", "e")));
        Assert.assertNotEquals((Object)digest, (Object)BuilderInputs.digest((BuilderInputs.Value)InputDirectoryTest.newInputDirectoryFiles(new File("b").toPath(), "i", "e")));
    }

    @Test
    public void testCompileSourceRoots() throws Exception {
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        File file = new File(dir1, "file.txt");
        file.createNewFile();
        BuilderInputs.CollectionValue input = (BuilderInputs.CollectionValue)TestInputBuilder.builder(this.temp.getRoot()).withCompileSourceRoot(dir1.getCanonicalPath()).withCompileSourceRoot(dir2.getCanonicalPath()).build(_CompileSourceRoots.class, "compileSourceRoots");
        Assertions.assertThat((List)input.configuration).hasSize(1);
        Assert.assertEquals((Object)dir1.getCanonicalPath(), (Object)((BuilderInputs.InputDirectoryValue)input.configuration.get((int)0)).location.toRealPath(new LinkOption[0]).toString());
    }

    @Test
    public void testTestCompileSourceRoots() throws Exception {
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        File file = new File(dir1, "file.txt");
        file.createNewFile();
        BuilderInputs.CollectionValue input = (BuilderInputs.CollectionValue)TestInputBuilder.builder(this.temp.getRoot()).withTestCompileSourceRoot(dir1.getCanonicalPath()).withTestCompileSourceRoot(dir2.getCanonicalPath()).build(_CompileSourceRoots.class, "testCompileSourceRoots");
        Assertions.assertThat((List)input.configuration).hasSize(1);
        Assert.assertEquals((Object)dir1.getCanonicalPath(), (Object)((BuilderInputs.InputDirectoryValue)input.configuration.get((int)0)).location.toRealPath(new LinkOption[0]).toString());
    }

    @Test
    public void testCompileSourceRootsExtraParams() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(String.format("%s can not have other values provided along with it", "${project.compileSourceRoots}"));
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        TestInputBuilder.builder(this.temp.getRoot()).withCompileSourceRoot(dir1.getCanonicalPath()).withCompileSourceRoot(dir2.getCanonicalPath()).build(_CompileSourceRoots.class, "badCompileSourceRoots");
    }

    @Test
    public void testTestCompileSourceRootsExtraParams() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(String.format("%s can not have other values provided along with it", "${project.testCompileSourceRoots}"));
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        TestInputBuilder.builder(this.temp.getRoot()).withTestCompileSourceRoot(dir1.getCanonicalPath()).withTestCompileSourceRoot(dir2.getCanonicalPath()).build(_CompileSourceRoots.class, "badTestCompileSourceRoots");
    }

    @Test
    public void testRequiredCompileSourceRootFailsWithoutSourceRoots() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage("_CompileSourceRoots.compileSourceRoots.compileSourceRoots: is required");
        TestInputBuilder.builder(this.temp.getRoot()).build(_CompileSourceRoots.class, "compileSourceRoots");
    }

    @Test
    public void testConfiguredCompileSourceRootsFails() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(String.format("_Data.directory: %s expression is not allowed in configuration", "${project.compileSourceRoots}"));
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        TestInputBuilder.builder(this.temp.getRoot()).withCompileSourceRoot(dir1.getCanonicalPath()).withCompileSourceRoot(dir2.getCanonicalPath()).withConfigurationXml(String.format("<directory><location>%s</location></directory>", "${project.compileSourceRoots}")).build(_Data.class, "directory");
    }

    @Test
    public void testConfiguredTestCompileSourceRootsFails() throws Exception {
        this.thrown.expect(BuilderInputsBuilder.InvalidConfigurationException.class);
        this.thrown.expectMessage(String.format("_Data.directory: %s expression is not allowed in configuration", "${project.testCompileSourceRoots}"));
        File dir1 = this.temp.newFolder();
        File dir2 = this.temp.newFolder();
        TestInputBuilder.builder(this.temp.getRoot()).withCompileSourceRoot(dir1.getCanonicalPath()).withCompileSourceRoot(dir2.getCanonicalPath()).withConfigurationXml(String.format("<directory><location>%s</location></directory>", "${project.testCompileSourceRoots}")).build(_Data.class, "directory");
    }

    private Set<File> pathToFile(Set<Path> files) {
        return files.stream().map(file -> file.toFile()).collect(Collectors.toSet());
    }

    @Test
    public void testSpecificIncludes() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        new File(basedir, "dir").mkdirs();
        new File(basedir, "dir/1.txt").createNewFile();
        BuilderInputs.InputDirectoryValue input = (BuilderInputs.InputDirectoryValue)TestInputBuilder.builder(basedir).build(_SpecificIncludesData.class, "directory");
        Assert.assertEquals((Object)new File(basedir, "dir"), (Object)input.value());
        DirAssert.assertFiles(input.files(), new File(basedir, "dir/1.txt"));
        Assertions.assertThat((Iterable)input.filenames()).containsExactly((Object[])new String[]{"1.txt"});
    }

    static class _CompileSourceRoots {
        @InputDirectory(filesRequired=true, value={"${project.compileSourceRoots}"}, includes={"**/*"})
        public List<File> compileSourceRoots;
        @InputDirectory(filesRequired=true, value={"${project.compileSourceRoots}", "/bad"}, includes={"**/*"})
        public List<File> badCompileSourceRoots;
        @InputDirectory(filesRequired=true, value={"${project.testCompileSourceRoots}"}, includes={"**/*"})
        public List<File> testCompileSourceRoots;
        @InputDirectory(filesRequired=true, value={"/bad", "${project.testCompileSourceRoots}"}, includes={"**/*"})
        public List<File> badTestCompileSourceRoots;

        _CompileSourceRoots() {
        }
    }

    static class _Data {
        @InputDirectory(filesRequired=true, defaultValue={"."}, includes={"**/*.txt"})
        public File directory;

        _Data() {
        }
    }

    static class _ListFileData {
        @InputDirectory(defaultValue={"."}, includes={"**/*.txt"})
        public List<File> directories;

        _ListFileData() {
        }
    }

    static class _OptionalData {
        @InputDirectory(filesRequired=false, includes={"**/*"})
        public File directory;
        @InputDirectory(filesRequired=false, includes={"**/*"})
        public List<File> directories;

        _OptionalData() {
        }
    }

    static class _PathData {
        @InputDirectory(filesRequired=true, defaultValue={"."}, includes={"**/*.txt"})
        public Path directory;

        _PathData() {
        }
    }

    static class _SpecificIncludesData {
        @InputDirectory(filesRequired=true, value={"dir"}, includes={"1.txt"})
        public File directory;

        _SpecificIncludesData() {
        }
    }
}

