/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.Parameter;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.TestInputBuilder;
import io.takari.maven.testing.TestMavenRuntime;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.junit.Assert;
import org.junit.Test;

public class MapInputTest {
    static BuilderInputs.MapValue newMapInput(String ... values) {
        LinkedHashMap<String, String> members = new LinkedHashMap<String, String>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            members.put(value, value);
            ++n2;
        }
        return new BuilderInputs.MapValue(LinkedHashMap::new, members, v -> v);
    }

    @Test
    public void testDigest() throws Exception {
        BuilderInputs.Digest digest = BuilderInputs.digest((BuilderInputs.Value)MapInputTest.newMapInput("a", "b"));
        Assert.assertEquals((Object)digest, (Object)BuilderInputs.digest((BuilderInputs.Value)MapInputTest.newMapInput("a", "b")));
        Assert.assertNotEquals((Object)digest, (Object)BuilderInputs.digest((BuilderInputs.Value)MapInputTest.newMapInput("c", "d")));
    }

    @Test
    public void testMap() throws Exception {
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom listConfiguration = new Xpp3Dom("map");
        configuration.addChild(listConfiguration);
        listConfiguration.addChild(TestMavenRuntime.newParameter((String)"key1", (String)"value1"));
        listConfiguration.addChild(TestMavenRuntime.newParameter((String)"key2", (String)"value2"));
        BuilderInputs.MapValue input = (BuilderInputs.MapValue)TestInputBuilder.builder().withConfiguration(configuration).build(_MapData.class, "map");
        Assert.assertEquals((Object)"value1", input.configuration.get("key1"));
        Assert.assertEquals((Object)"value2", input.configuration.get("key2"));
    }

    @Test
    public void testMapWithIntegerValue() throws Exception {
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom listConfiguration = new Xpp3Dom("map");
        configuration.addChild(listConfiguration);
        listConfiguration.addChild(TestMavenRuntime.newParameter((String)"key1", (String)"1"));
        listConfiguration.addChild(TestMavenRuntime.newParameter((String)"key2", (String)"2"));
        BuilderInputs.MapValue input = (BuilderInputs.MapValue)TestInputBuilder.builder().withConfiguration(configuration).build(_IntegerMapData.class, "map");
        Assert.assertEquals((Object)1, input.value().get("key1"));
        Assert.assertEquals((Object)2, input.value().get("key2"));
    }

    @Test
    public void testMapWithOmittedOptionalValue() throws Exception {
        Assert.assertNull(TestInputBuilder.builder().build(_MapData.class, "map"));
    }

    @Test
    public void testMapWrapper() throws Exception {
        BuilderInputs.CompositeValue composite = (BuilderInputs.CompositeValue)TestInputBuilder.builder().withConfigurationXml("<custom><map><key>value</key></map></custom>").build(_MapWrapperData.class, "custom");
        _MapWrapper value = (_MapWrapper)composite.value();
        Assert.assertEquals((Object)"value", (Object)value.map.get("key"));
    }

    static class _IntegerMapData {
        @Parameter(required=false)
        Map<String, Integer> map;

        _IntegerMapData() {
        }
    }

    static class _MapData {
        @Parameter(required=false)
        Map<String, String> map;

        _MapData() {
        }
    }

    static class _MapWrapper {
        Map<String, String> map;

        _MapWrapper() {
        }
    }

    static class _MapWrapperData {
        @Parameter
        _MapWrapper custom;

        _MapWrapperData() {
        }
    }
}

