/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.internal.Message;
import io.takari.builder.internal.MessageCollector;
import io.takari.builder.testing.BuilderExecutionException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class MessageCollectorTest {
    MessageCollector testee = new MessageCollector((Logger)NOPLogger.NOP_LOGGER);

    @Test
    public void testThrowExceptionIfThereWereErrorMessages_success() throws Exception {
        this.testee.info(new File(""), 0, 0, "info", null);
        this.testee.warn(new File(""), 0, 0, "warn", null);
        this.testee.throwExceptionIfThereWereErrorMessages(BuilderExecutionException::new);
    }

    @Test(expected=BuilderExecutionException.class)
    public void testThrowExceptionIfThereWereErrorMessages_error() throws Exception {
        this.testee.error(new File(""), 0, 0, "error", null);
        this.testee.throwExceptionIfThereWereErrorMessages(BuilderExecutionException::new);
    }

    @Test(expected=BuilderExecutionException.class)
    public void testMessageReplay_error() throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(new Message(new File("").toString(), 0, 0, "error", Message.MessageSeverity.ERROR, null));
        this.testee.replayMessages(BuilderExecutionException::new, messages);
    }

    @Test
    public void testConcurrentModification() throws Exception {
        AtomicInteger count = new AtomicInteger();
        Runnable worker = () -> {
            int no;
            do {
                no = count.incrementAndGet();
                File file = new File(Integer.toString(no));
                int i = 0;
                while (i < 10) {
                    this.testee.info(file, i, 0, "message", null);
                    ++i;
                }
            } while (no < 1000);
        };
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < 32) {
            Thread thread = new Thread(worker);
            threads.add(thread);
            thread.start();
            ++i;
        }
        while (count.get() < 1000) {
            this.testee.throwExceptionIfThereWereErrorMessages(Exception::new);
        }
        for (Thread thread : threads) {
            thread.join();
        }
        Assertions.assertThat((List)this.testee.getCollectedMessages()).hasSize(count.get() * 10);
    }
}

