/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.OutputDirectory;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.TestInputBuilder;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class OutputDirectoryParameterTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testOutputDirectory() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File target = new File(basedir, "target");
        BuilderInputs.OutputDirectoryValue outputDirectory = (BuilderInputs.OutputDirectoryValue)TestInputBuilder.builder(basedir).build(_Data.class, "outputDirectory");
        Assert.assertEquals((Object)target, (Object)outputDirectory.value());
    }

    @Test
    public void testPathOutputDirectory() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        Path target = Paths.get(basedir.getCanonicalPath(), "target");
        BuilderInputs.OutputDirectoryValue outputDirectory = (BuilderInputs.OutputDirectoryValue)TestInputBuilder.builder(basedir).build(_PathData.class, "outputDirectory");
        Assert.assertEquals((Object)target, (Object)outputDirectory.value());
    }

    static class _Data {
        @OutputDirectory(defaultValue={"target"})
        File outputDirectory;

        _Data() {
        }
    }

    static class _PathData {
        @OutputDirectory(defaultValue={"target"})
        Path outputDirectory;

        _PathData() {
        }
    }
}

