/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.OutputFile;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.TestInputBuilder;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class OutputFileParameterTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testOutputFile() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File target = new File(basedir, "target");
        File file = new File(target, "file.txt");
        BuilderInputs.OutputFileValue outputFile = (BuilderInputs.OutputFileValue)TestInputBuilder.builder(basedir).build(_Data.class, "outputDirectory");
        Assert.assertEquals((Object)file, (Object)outputFile.value());
    }

    @Test
    public void testPathOutputFile() throws Exception {
        File basedir = this.temp.newFolder().getCanonicalFile();
        File target = new File(basedir, "target");
        Path path = Paths.get(target.getCanonicalPath(), "file.txt");
        BuilderInputs.OutputFileValue outputFile = (BuilderInputs.OutputFileValue)TestInputBuilder.builder(basedir).build(_PathData.class, "outputDirectory");
        Assert.assertEquals((Object)path, (Object)outputFile.value());
    }

    static class _Data {
        @OutputFile(defaultValue={"target/file.txt"})
        File outputDirectory;

        _Data() {
        }
    }

    static class _PathData {
        @OutputFile(defaultValue={"target/file.txt"})
        Path outputDirectory;

        _PathData() {
        }
    }
}

