/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.Parameter;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.TestInputBuilder;
import java.net.URI;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class SimpleInputTest {
    @Test
    public void testDigest() throws Exception {
        BuilderInputs.Digest digest = BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.StringValue("a", String::new));
        Assert.assertEquals((Object)digest, (Object)BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.StringValue("a", String::new)));
        Assert.assertNotEquals((Object)digest, (Object)BuilderInputs.digest((BuilderInputs.Value)new BuilderInputs.StringValue("b", String::new)));
    }

    static BuilderInputs.Value<?> build(String name, String value) throws Exception {
        return TestInputBuilder.builder().withConfigurationXml(String.format("<%s>%s</%s>", name, value, name)).build(_Data.class, name);
    }

    @Test
    public void testString() throws Exception {
        Assert.assertEquals((Object)"string", (Object)SimpleInputTest.build("_string", "string").value());
    }

    @Test
    public void testBooleanTypes() throws Exception {
        Assert.assertEquals((Object)true, (Object)SimpleInputTest.build("_boolean", "true").value());
        Assert.assertEquals((Object)false, (Object)SimpleInputTest.build("_boolean", "false").value());
        Assert.assertEquals((Object)true, (Object)SimpleInputTest.build("_Boolean", "true").value());
        Assert.assertEquals((Object)false, (Object)SimpleInputTest.build("_Boolean", "false").value());
    }

    @Test
    public void testIntegerTypes() throws Exception {
        Assert.assertEquals((Object)1, (Object)SimpleInputTest.build("_int", "1").value());
        Assert.assertEquals((Object)1, (Object)SimpleInputTest.build("_Integer", "1").value());
        Assert.assertEquals((Object)1L, (Object)SimpleInputTest.build("_long", "1").value());
        Assert.assertEquals((Object)1L, (Object)SimpleInputTest.build("_Long", "1").value());
    }

    @Test
    public void testURL() throws Exception {
        String url = "https://www.eclipse.org";
        Assert.assertEquals((Object)new URL(url), (Object)SimpleInputTest.build("_url", url).value());
    }

    @Test
    public void testURI() throws Exception {
        String url = "https://www.eclipse.org";
        Assert.assertEquals((Object)new URI(url), (Object)SimpleInputTest.build("_uri", url).value());
    }

    static class _Data {
        @Parameter(required=false)
        String _string;
        @Parameter
        boolean _boolean;
        @Parameter(required=false)
        Boolean _Boolean;
        @Parameter
        int _int;
        @Parameter
        long _long;
        @Parameter(required=false)
        Integer _Integer;
        @Parameter(required=false)
        Long _Long;
        @Parameter(required=false)
        URL _url;
        @Parameter(required=false)
        URI _uri;

        _Data() {
        }
    }
}

