/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.IArtifactMetadata;
import io.takari.builder.ResolutionScope;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderInputsBuilder;
import io.takari.builder.internal.BuilderWorkspace;
import io.takari.builder.internal.ExpressionEvaluator;
import io.takari.builder.internal.ProjectModelProvider;
import io.takari.builder.internal.Reflection;
import io.takari.builder.internal.model.AbstractParameter;
import io.takari.builder.internal.model.BuilderClass;
import io.takari.builder.internal.resolver.DependencyResolver;
import io.takari.builder.internal.workspace.FilesystemWorkspace;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Function;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

class TestInputBuilder {
    private File basedir;
    private final DependencyResolver dependencyResolver = new TestDependencyResolver();
    private final ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(Arrays.asList(new TestPropertyResolver()));
    private final List<String> compileSourceRoots = new ArrayList<String>();
    private final List<String> testCompileSourceRoots = new ArrayList<String>();
    private final ProjectModelProvider projectModelProvider = new ProjectModelProvider(){

        public List<String> getTestCompileSourceRoots() {
            return TestInputBuilder.this.testCompileSourceRoots;
        }

        public List<String> getCompileSourceRoots() {
            return TestInputBuilder.this.compileSourceRoots;
        }

        public Path getBasedir() {
            return TestInputBuilder.this.basedir.toPath();
        }
    };
    private Xpp3Dom configuration;
    private final Map<ResolutionScope, Map<String, Path>> scopedDependencies = new LinkedHashMap<ResolutionScope, Map<String, Path>>();
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private String goal = "goal";
    private final BuilderWorkspace workspace;

    public TestInputBuilder(File basedir) {
        this.basedir = basedir != null ? basedir : new File("/");
        this.workspace = new BuilderWorkspace((Workspace)new FilesystemWorkspace(), this.basedir.toPath(), null);
    }

    public <T extends BuilderInputs.Value<?>> T build(Class<?> type, String fieldName) throws IOException {
        BuilderClass metadata = Reflection.createBuilderClass(type);
        AbstractParameter parameter = metadata.parameters().stream().filter(p -> fieldName.equals(p.name())).findAny().get();
        metadata = new BuilderClass(metadata.type(), metadata.builders(), Collections.singletonList(parameter));
        BuilderInputs inputs = BuilderInputsBuilder.build((String)this.goal, (ProjectModelProvider)this.projectModelProvider, (DependencyResolver)this.dependencyResolver, (ExpressionEvaluator)this.expressionEvaluator, type, (Xpp3Dom)this.configuration, Collections.emptyMap(), (BuilderClass)metadata, (BuilderWorkspace)this.workspace);
        return (T)((BuilderInputs.Value)inputs.members.get(TestInputBuilder.getField(type, fieldName)));
    }

    public BuilderInputs build(Class<?> type) throws IOException {
        return BuilderInputsBuilder.build((String)this.goal, (ProjectModelProvider)this.projectModelProvider, (DependencyResolver)this.dependencyResolver, (ExpressionEvaluator)this.expressionEvaluator, type, (Xpp3Dom)this.configuration, Collections.emptyMap(), (BuilderWorkspace)this.workspace);
    }

    static Field getField(Class<?> type, String name) {
        return Reflection.getAllFields(type).stream().filter(f -> name.equals(f.getName())).findFirst().get();
    }

    public static TestInputBuilder builder(File basedir) {
        return new TestInputBuilder(basedir);
    }

    public static TestInputBuilder builder() {
        return new TestInputBuilder(null);
    }

    public TestInputBuilder withBasedir(File basedir) {
        this.basedir = basedir;
        return this;
    }

    public TestInputBuilder withConfiguration(Xpp3Dom configuration) {
        this.configuration = configuration;
        return this;
    }

    public TestInputBuilder withCompileSourceRoot(String sourceRoot) {
        this.compileSourceRoots.add(sourceRoot);
        return this;
    }

    public TestInputBuilder withTestCompileSourceRoot(String sourceRoot) {
        this.testCompileSourceRoots.add(sourceRoot);
        return this;
    }

    public TestInputBuilder withConfigurationXml(String xml) throws XmlPullParserException, IOException {
        this.configuration = Xpp3DomBuilder.build((Reader)new StringReader("<configuration>" + xml + "</configuration>"));
        return this;
    }

    public TestInputBuilder withDependencies(String ... dependencies) {
        return this.withDependencies(ResolutionScope.COMPILE, dependencies);
    }

    public TestInputBuilder withDependency(String gac, File dependency) {
        return this.withDependency(gac, dependency, ResolutionScope.COMPILE);
    }

    public TestInputBuilder withDependencies(ResolutionScope scope, String ... dependencies) {
        String[] stringArray = dependencies;
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            String dependency = stringArray[n2];
            Path path = Paths.get(dependency, new String[0]);
            this.getDependencies(scope).put("g:" + path.getFileName().toString(), path);
            ++n2;
        }
        return this;
    }

    public TestInputBuilder withDependency(String gac, File dependency, ResolutionScope scope) {
        this.getDependencies(scope).put(gac, dependency.toPath());
        return this;
    }

    public TestInputBuilder withProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public TestInputBuilder withGoal(String goal) {
        this.goal = goal;
        return this;
    }

    private Map<String, Path> getDependencies(ResolutionScope scope) {
        Map<String, Path> dependencies = this.scopedDependencies.get(scope);
        if (dependencies == null) {
            dependencies = new LinkedHashMap<String, Path>();
            this.scopedDependencies.put(scope, dependencies);
        }
        return dependencies;
    }

    public static class TestArtifactMetadata
    implements IArtifactMetadata {
        private final String groupId;
        private final String artifactId;

        public TestArtifactMetadata(String gac) {
            StringTokenizer st = new StringTokenizer(gac, ":");
            this.groupId = st.nextToken();
            this.artifactId = st.nextToken();
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return null;
        }

        public String getType() {
            return null;
        }

        public String getClassifier() {
            return null;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestArtifactMetadata other = (TestArtifactMetadata)obj;
            if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                return false;
            }
            return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
        }
    }

    class TestDependencyResolver
    implements DependencyResolver {
        TestDependencyResolver() {
        }

        public Map<IArtifactMetadata, Path> getProjectDependencies(boolean transitive, ResolutionScope scope) {
            LinkedHashMap<IArtifactMetadata, Path> result = new LinkedHashMap<IArtifactMetadata, Path>();
            if (scope == null) {
                return result;
            }
            Map dependencies = TestInputBuilder.this.getDependencies(scope);
            dependencies.forEach((gac, path) -> result.put(new TestArtifactMetadata((String)gac), (Path)path));
            return result;
        }

        public AbstractMap.SimpleEntry<IArtifactMetadata, Path> getProjectDependency(String groupId, String artifactId, String classifier, ResolutionScope scope) {
            Path path;
            String gac = String.valueOf(groupId) + ":" + artifactId;
            if (classifier != null) {
                gac = String.valueOf(gac) + ":" + classifier;
            }
            return (path = (Path)TestInputBuilder.this.getDependencies(scope).get(gac)) != null ? new AbstractMap.SimpleEntry<TestArtifactMetadata, Path>(new TestArtifactMetadata(gac), path) : null;
        }
    }

    class TestPropertyResolver
    implements Function<String, String> {
        TestPropertyResolver() {
        }

        @Override
        public String apply(String name) {
            if (TestInputBuilder.this.properties.containsKey(name)) {
                return (String)TestInputBuilder.this.properties.get(name);
            }
            return null;
        }
    }
}

