/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.maven;

import io.takari.builder.internal.ExpressionEvaluationException;
import io.takari.builder.internal.ExpressionEvaluator;
import io.takari.builder.internal.maven.MavenProjectPropertyResolver;
import io.takari.maven.testing.TestMavenRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.function.Function;
import org.apache.maven.project.MavenProject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class ExpressionEvaluatorTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    @Rule
    public final TestMavenRuntime maven = new TestMavenRuntime();
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();
    private MavenProject project;

    @Before
    public void setup() throws Exception {
        File basedir = this.temp.newFolder();
        File file = new File(basedir, "1.txt");
        file.createNewFile();
        this.project = this.maven.readMavenProject(basedir);
        this.project.setArtifactId("artifact1");
        this.project.setGroupId("group1");
        this.project.setVersion("1.0");
    }

    private ExpressionEvaluator newEvaluator() {
        return this.newEvaluator(new Properties());
    }

    private ExpressionEvaluator newEvaluator(Properties properties) {
        ArrayList<Function<String, String>> resolvers = new ArrayList<Function<String, String>>();
        resolvers.add(s -> properties.getProperty((String)s));
        resolvers.add((Function<String, String>)new MavenProjectPropertyResolver(this.project));
        return new ExpressionEvaluator(resolvers);
    }

    @Test
    public void testProjectExpressionAtStart() throws Exception {
        String expression = "${project.build.directory}";
        ExpressionEvaluator evaluator = this.newEvaluator();
        String evaluatedExpression = evaluator.evaluate(expression);
        String expectedResult = this.project.getBuild().getDirectory();
        Assert.assertEquals((Object)expectedResult, (Object)evaluatedExpression);
    }

    @Test
    public void testProjectExpressionInMiddle() throws Exception {
        String expression = "/sometext/${project.build.directory}/somemore.txt";
        ExpressionEvaluator evaluator = this.newEvaluator();
        String evaluatedExpression = evaluator.evaluate(expression);
        String expectedResult = "/sometext/" + this.project.getBuild().getDirectory() + "/somemore.txt";
        Assert.assertEquals((Object)expectedResult, (Object)evaluatedExpression);
    }

    @Test
    public void testProjectExpressionAtEnd() throws Exception {
        String expression = "/sometext/${project.build.directory}";
        ExpressionEvaluator evaluator = this.newEvaluator();
        String evaluatedExpression = evaluator.evaluate(expression);
        String expectedResult = "/sometext/" + this.project.getBuild().getDirectory();
        Assert.assertEquals((Object)expectedResult, (Object)evaluatedExpression);
    }

    @Test
    public void testInvalidExpression() throws Exception {
        String expression = "${settings.localRepository}";
        ExpressionEvaluator evaluator = this.newEvaluator();
        this.expectedEx.expect(ExpressionEvaluationException.class);
        this.expectedEx.expectMessage(expression);
        evaluator.evaluate(expression);
    }

    @Test
    public void testUserOrSystemPropertiesExpression() throws Exception {
        String propertyName = "my.user.property";
        String expression = String.format("${%s}", propertyName);
        Properties properties = new Properties();
        String propertyValue = "Something";
        properties.put(propertyName, propertyValue);
        ExpressionEvaluator evaluator = this.newEvaluator(properties);
        String evaluatedExpression = evaluator.evaluate(expression);
        String expectedResult = propertyValue;
        Assert.assertEquals((Object)expectedResult, (Object)evaluatedExpression);
    }

    @Test
    public void testProjectPropertiesExpression() throws Exception {
        String propertyName = "my.project.property";
        String expression = String.format("${%s}", propertyName);
        String propertyValue = "Something";
        this.project.getProperties().put(propertyName, propertyValue);
        ExpressionEvaluator evaluator = this.newEvaluator();
        String evaluatedExpression = evaluator.evaluate(expression);
        String expectedResult = propertyValue;
        Assert.assertEquals((Object)expectedResult, (Object)evaluatedExpression);
    }

    @Test
    public void testArtifactId() throws Exception {
        this.verifySimpleExpression("${project.artifactId}", this.project.getArtifactId());
    }

    @Test
    public void testBasedir() throws Exception {
        this.verifySimpleExpression("${project.basedir}", this.project.getBasedir().getAbsolutePath());
    }

    @Test
    public void testGroupId() throws Exception {
        this.verifySimpleExpression("${project.groupId}", this.project.getGroupId());
    }

    @Test
    public void testBuildDirectory() throws Exception {
        this.verifySimpleExpression("${project.build.directory}", this.project.getBuild().getDirectory());
    }

    @Test
    public void testOutputDirectory() throws Exception {
        this.verifySimpleExpression("${project.build.outputDirectory}", this.project.getBuild().getOutputDirectory());
    }

    @Test
    public void testTestOutputDirectory() throws Exception {
        this.verifySimpleExpression("${project.build.testOutputDirectory}", this.project.getBuild().getTestOutputDirectory());
    }

    @Test
    public void testVersion() throws Exception {
        this.verifySimpleExpression("${project.version}", this.project.getVersion());
    }

    @Test
    public void test$$escape() throws Exception {
        this.verifySimpleExpression("$${project.version}", "${project.version}");
        this.verifySimpleExpression("$$${project.version}", "$" + this.project.getVersion());
    }

    @Test
    public void testNoExpression() throws Exception {
        this.verifySimpleExpression("", "");
        this.verifySimpleExpression("t", "t");
        this.verifySimpleExpression("text", "text");
        this.verifySimpleExpression("$", "$");
        this.verifySimpleExpression("${", "${");
        this.verifySimpleExpression("${project.version", "${project.version");
    }

    @Test
    public void testEmptyExpression() throws Exception {
        this.expectedEx.expect(ExpressionEvaluationException.class);
        this.expectedEx.expectMessage("${}");
        this.newEvaluator().evaluate("${}");
    }

    private void verifySimpleExpression(String expression, Object expectedResult) throws Exception {
        ExpressionEvaluator evaluator = this.newEvaluator();
        String evaluatedExpression = evaluator.evaluate(expression);
        Assert.assertEquals((Object)expectedResult, (Object)evaluatedExpression);
    }
}

