/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.maven;

import io.takari.maven.testing.TestResources;
import io.takari.maven.testing.executor.MavenRuntime;
import io.takari.maven.testing.executor.MavenVersions;
import io.takari.maven.testing.executor.junit.MavenJUnitTestRunner;
import java.io.File;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=MavenJUnitTestRunner.class)
@MavenVersions(value={"3.3.9"})
public class LegacyMojoWhitelistMavenTest {
    @Rule
    public final TestResources resources = new TestResources();
    private final MavenRuntime verifier;

    public LegacyMojoWhitelistMavenTest(MavenRuntime.MavenRuntimeBuilder verifierBuilder) throws Exception {
        this.verifier = verifierBuilder.withCliOptions(new String[]{"-B", "-e"}).build();
    }

    @Test
    public void testImportedModuleIsNotSubjectToMojoWhitelist() throws Exception {
        File basedir = this.resources.getBasedir("whiltelist-module-import");
        this.verifier.forProject(basedir).execute(new String[]{"validate"}).assertErrorFreeLog();
    }

    @Test
    public void testRedundantWhitelist() throws Exception {
        File basedir = this.resources.getBasedir("redundant-whitelist");
        this.verifier.forProject(basedir).execute(new String[]{"package"}).assertLogText("[ERROR]").assertLogText("Redundant whitelist entry");
    }

    @Test
    public void testWhitelistedExecution() throws Exception {
        File basedir = this.resources.getBasedir("whitelist-multi-module");
        this.verifier.forProject(basedir).execute(new String[]{"validate"}).assertLogText("[INFO] whitelist-multi-module ............................. SUCCESS").assertLogText("[INFO] whitelisted-executions ............................. SUCCESS").assertLogText("[INFO] non-whitelisted-executions ......................... FAILURE").assertLogText("Unsupported legacy mojo org.apache.maven.plugins:maven-resources-plugin:2.7:resources {execution: not-allowed} @ non-whitelisted-executions");
    }
}

