/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.maven;

import io.takari.builder.internal.maven.LegacyMojoWhitelist;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class LegacyMojoWhitelistTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testWhitelistParse() throws Exception {
        LegacyMojoWhitelist testee = new LegacyMojoWhitelist(this.newConfig("g:a:g1", "g:a:g2"));
        Assertions.assertThat((Map)testee.whitelist).containsKeys((Object[])new String[]{"g:a:g1", "g:a:g2"});
        Assertions.assertThat((Iterable)((Iterable)testee.whitelist.get("g:a:g1"))).isEmpty();
        Assertions.assertThat((Iterable)((Iterable)testee.whitelist.get("g:a:g2"))).isEmpty();
    }

    @Test
    public void testWhitelistExecutionParse() throws Exception {
        LegacyMojoWhitelist testee = new LegacyMojoWhitelist(this.newConfig("g:a:g1:e:pg:pa", "g:a:g2", "g:a:g1:e1:pg1:pa1"));
        Assertions.assertThat((Map)testee.whitelist).containsKeys((Object[])new String[]{"g:a:g1", "g:a:g2"});
        Assertions.assertThat((Iterable)((Iterable)testee.whitelist.get("g:a:g1"))).contains((Object[])new String[]{"e:pg:pa", "e1:pg1:pa1"});
        Assertions.assertThat((Iterable)((Iterable)testee.whitelist.get("g:a:g2"))).isEmpty();
    }

    @Test
    public void testWhitelistParse_configDoesNotExist() throws Exception {
        LegacyMojoWhitelist testee = new LegacyMojoWhitelist(Paths.get(this.temp.getRoot().getCanonicalPath(), "no-such-file"));
        Assertions.assertThat((Map)testee.whitelist).isNull();
    }

    @Test
    public void testWhitelistParse_comments() throws Exception {
        LegacyMojoWhitelist testee = new LegacyMojoWhitelist(this.newConfig("#", "", "#"));
        Assertions.assertThat((Map)testee.whitelist).isEmpty();
    }

    @Test
    public void testWhitelistParse_tooFewTokens() throws Exception {
        this.thrown.expect(MojoExecutionException.class);
        new LegacyMojoWhitelist(this.newConfig("g:a"));
    }

    @Test
    public void testWhitelistParse_tooManyTokens() throws Exception {
        this.thrown.expect(MojoExecutionException.class);
        new LegacyMojoWhitelist(this.newConfig("a:b:c:d"));
    }

    @Test
    public void testExecutionWhitelist() throws Exception {
        LegacyMojoWhitelist testee = new LegacyMojoWhitelist(this.newConfig("g:a:g1:e:pg:pa"));
        Assert.assertTrue((boolean)testee.isExecutionWhitelisted("g:a:g1", "e", "pg", "pa"));
        Assert.assertFalse((boolean)testee.isExecutionWhitelisted("g:a:g1", "e1", "pg", "pa"));
        Assert.assertFalse((boolean)testee.isExecutionWhitelisted("g:a:g1", "e", "pg1", "pa"));
        Assert.assertFalse((boolean)testee.isExecutionWhitelisted("g:a:g1", "e", "pg", "pa1"));
    }

    @Test
    public void testExecutionWhitelistNoExecutionSpecified() throws Exception {
        LegacyMojoWhitelist testee = new LegacyMojoWhitelist(this.newConfig("g:a:g1"));
        Assert.assertTrue((boolean)testee.isExecutionWhitelisted("g:a:g1", "e", "pg", "pa"));
    }

    @Test
    public void testExecutionWhitelistWildcard() throws Exception {
        LegacyMojoWhitelist testee = new LegacyMojoWhitelist(this.newConfig("g:a:g1:e:*:*"));
        Assert.assertTrue((boolean)testee.isExecutionWhitelisted("g:a:g1", "e", "pg", "pa"));
        Assert.assertTrue((boolean)testee.isExecutionWhitelisted("g:a:g1", "e", "pg1", "pa"));
        Assert.assertTrue((boolean)testee.isExecutionWhitelisted("g:a:g1", "e", "pg", "pa1"));
        Assert.assertFalse((boolean)testee.isExecutionWhitelisted("g:a:g1", "e1", "pg", "pa"));
    }

    private Path newConfig(String ... lines) throws IOException {
        Path file = this.temp.newFile().toPath();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter w = Files.newBufferedWriter(file, LegacyMojoWhitelist.UTF_8, new OpenOption[0]);){
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                w.write(line);
                w.newLine();
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return file;
    }
}

