/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.maven;

import io.takari.builder.ResolutionScope;
import io.takari.builder.internal.cache.ScopedProjectDependencyCache;
import io.takari.builder.internal.maven.MavenDependencyResolver;
import io.takari.builder.internal.resolver.DependencyResolver;
import io.takari.maven.testing.TestMavenRuntime;
import io.takari.maven.testing.TestResources;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.junit.Rule;
import org.junit.Test;

public class MavenDependencyResolverTest {
    @Rule
    public final TestMavenRuntime maven = new TestMavenRuntime();
    @Rule
    public final TestResources resources = new TestResources();
    private DependencyResolver resolver;
    private File jarfile;
    private File dirfiledirect;
    private File dirfiletransitive;

    public void setup(String projectdir) throws Exception {
        File basedir = this.resources.getBasedir("dependency-resolution");
        File projectfile = new File(basedir, projectdir);
        File repodir = new File(basedir, "repository");
        this.jarfile = new File(repodir, "junit/junit/4.12/junit-4.12.jar");
        MavenProject directProject = this.maven.readMavenProject(new File(basedir, "direct"));
        MavenProject transitiveProject = this.maven.readMavenProject(new File(basedir, "transitive"));
        this.dirfiledirect = new File(directProject.getBuild().getOutputDirectory());
        this.dirfiletransitive = new File(transitiveProject.getBuild().getOutputDirectory());
        MavenProject project = this.maven.readMavenProject(projectfile);
        RepositorySystem repoSystem = (RepositorySystem)this.maven.lookup(RepositorySystem.class);
        LocalRepository localRepo = new LocalRepository(repodir);
        DefaultRepositorySystemSession repoSession = MavenRepositorySystemUtils.newSession();
        TestWorkspaceReader reader = new TestWorkspaceReader(Arrays.asList(directProject, transitiveProject));
        repoSession.setWorkspaceReader((WorkspaceReader)reader);
        LocalRepositoryManager lrm = repoSystem.newLocalRepositoryManager((RepositorySystemSession)repoSession, localRepo);
        repoSession.setLocalRepositoryManager(lrm);
        this.resolver = new MavenDependencyResolver(project, (RepositorySystemSession)repoSession, repoSystem, new ScopedProjectDependencyCache());
    }

    @Test(expected=NoSuchElementException.class)
    public void testResourceNotFound() throws Exception {
        this.setup("transitive");
        this.resolver.getProjectDependency("g", "a", "c", ResolutionScope.COMPILE);
    }

    @Test
    public void testResolveAllCompileDependencies() throws Exception {
        this.setup("all-compile");
        Map resolved = this.resolver.getProjectDependencies(true, ResolutionScope.COMPILE);
        Assertions.assertThat((Map)resolved).containsValue((Object)this.jarfile.toPath());
        Assertions.assertThat((Map)resolved).containsValue((Object)this.dirfiledirect.toPath());
        Assertions.assertThat((Map)resolved).containsValue((Object)this.dirfiletransitive.toPath());
    }

    @Test
    public void testResolveDirectDependencies() throws Exception {
        this.setup("all-compile");
        Map resolved = this.resolver.getProjectDependencies(false, ResolutionScope.COMPILE);
        Assertions.assertThat((Map)resolved).containsValue((Object)this.jarfile.toPath());
        Assertions.assertThat((Map)resolved).containsValue((Object)this.dirfiledirect.toPath());
        Assertions.assertThat((Map)resolved).doesNotContainValue((Object)this.dirfiletransitive.toPath());
    }

    @Test
    public void testTestScopeNotResolved() throws Exception {
        this.setup("mixed-scope");
        Map resolved = this.resolver.getProjectDependencies(false, ResolutionScope.COMPILE);
        Assertions.assertThat((Map)resolved).doesNotContainValue((Object)this.jarfile.toPath());
        Assertions.assertThat((Map)resolved).containsValue((Object)this.dirfiledirect.toPath());
    }

    @Test
    public void testTestScopeResolvesCompileScope() throws Exception {
        this.setup("mixed-scope");
        Map resolved = this.resolver.getProjectDependencies(false, ResolutionScope.TEST);
        Assertions.assertThat((Map)resolved).containsValue((Object)this.jarfile.toPath());
        Assertions.assertThat((Map)resolved).containsValue((Object)this.dirfiledirect.toPath());
    }

    private class TestWorkspaceReader
    implements WorkspaceReader {
        private final Map<String, MavenProject> projectsByGAV = new HashMap<String, MavenProject>();
        private final Map<String, MavenProject> projectsByGA = new HashMap<String, MavenProject>();
        private final WorkspaceRepository repository = new WorkspaceRepository("reactor", new HashSet<String>(this.projectsByGAV.keySet()));

        private TestWorkspaceReader(List<MavenProject> projects) throws Exception {
            projects.forEach(p -> {
                this.putProject((MavenProject)p);
                this.putVersionlessProject((MavenProject)p);
            });
        }

        private void putProject(MavenProject p) {
            this.projectsByGAV.put(ArtifactUtils.key((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion()), p);
        }

        private void putVersionlessProject(MavenProject p) {
            this.projectsByGA.put(ArtifactUtils.versionlessKey((String)p.getGroupId(), (String)p.getArtifactId()), p);
        }

        public WorkspaceRepository getRepository() {
            return this.repository;
        }

        public List<String> findVersions(Artifact artifact) {
            String key = ArtifactUtils.versionlessKey((String)artifact.getGroupId(), (String)artifact.getArtifactId());
            if (this.projectsByGA.containsKey(key)) {
                return Arrays.asList(this.projectsByGA.get(key).getVersion());
            }
            return Collections.emptyList();
        }

        public File findArtifact(Artifact artifact) {
            MavenProject project = this.projectsByGAV.get(ArtifactUtils.key((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion()));
            if (project == null) {
                return null;
            }
            if (artifact.getExtension().equals("pom")) {
                return project.getFile();
            }
            return new File(project.getBuild().getOutputDirectory());
        }
    }
}

