/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.model;

import io.takari.builder.internal.model.MemberAdapter;
import io.takari.builder.internal.model.TypeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTypeAdapterTest {
    protected abstract Collection<MemberAdapter> listMembers(Class<?> var1);

    protected MemberAdapter getMember(Class<?> type, String memberName) {
        return this.listMembers(type).stream().filter(m -> memberName.equals(m.getName())).findFirst().get();
    }

    @Test
    public void testParameterTypes_map() {
        MemberAdapter member = this.getMember(_ParameterTypesData.class, "map");
        Assert.assertTrue((boolean)member.getType().isMap());
        List parameterTypes = member.getParameterTypes();
        Assert.assertEquals((long)2L, (long)parameterTypes.size());
        Assert.assertTrue((boolean)((TypeAdapter)parameterTypes.get(0)).isSameType(String.class));
        Assert.assertTrue((boolean)((TypeAdapter)parameterTypes.get(1)).isSameType(String.class));
    }

    @Test
    public void testParameterTypes_rawMap() {
        MemberAdapter member = this.getMember(_ParameterTypesData.class, "rawMap");
        Assert.assertTrue((boolean)member.getType().isMap());
        List parameterTypes = member.getParameterTypes();
        Assert.assertEquals((long)0L, (long)parameterTypes.size());
    }

    @Test
    public void testParameterTypes_wildcardMap() {
        MemberAdapter member = this.getMember(_ParameterTypesData.class, "wildcardMap");
        Assert.assertTrue((boolean)member.getType().isMap());
        List parameterTypes = member.getParameterTypes();
        Assert.assertEquals((long)0L, (long)parameterTypes.size());
    }

    @Test
    public void testParameterTypes_wildcardValueMap() {
        MemberAdapter member = this.getMember(_ParameterTypesData.class, "wildcardValueMap");
        Assert.assertTrue((boolean)member.getType().isMap());
        List parameterTypes = member.getParameterTypes();
        Assert.assertEquals((long)1L, (long)parameterTypes.size());
        Assert.assertTrue((boolean)((TypeAdapter)parameterTypes.get(0)).isSameType(String.class));
    }

    @Test
    public void testParameterTypes_list() {
        MemberAdapter member = this.getMember(_ParameterTypesData.class, "list");
        Assert.assertTrue((boolean)member.getType().isIterable());
        List parameterTypes = member.getParameterTypes();
        Assert.assertEquals((long)1L, (long)parameterTypes.size());
        Assert.assertTrue((boolean)((TypeAdapter)parameterTypes.get(0)).isSameType(String.class));
    }

    @Test
    public void testParameterTypes_listOfRaw() {
        MemberAdapter member = this.getMember(_ParameterTypesData.class, "listOfRaw");
        Assert.assertTrue((boolean)member.getType().isIterable());
        List parameterTypes = member.getParameterTypes();
        Assert.assertEquals((long)1L, (long)parameterTypes.size());
        Assert.assertTrue((boolean)((TypeAdapter)parameterTypes.get(0)).isSameType(List.class));
    }

    @Test
    public void testParameterTypes_listOfWildcard() {
        MemberAdapter member = this.getMember(_ParameterTypesData.class, "listOfWildcard");
        Assert.assertTrue((boolean)member.getType().isIterable());
        List parameterTypes = member.getParameterTypes();
        Assert.assertEquals((long)1L, (long)parameterTypes.size());
        Assert.assertTrue((boolean)((TypeAdapter)parameterTypes.get(0)).isSameType(List.class));
    }

    @Test
    public void testParameterTypes_rawList() {
        MemberAdapter member = this.getMember(_ParameterTypesData.class, "rawList");
        Assert.assertTrue((boolean)member.getType().isIterable());
        List parameterTypes = member.getParameterTypes();
        Assert.assertEquals((long)0L, (long)parameterTypes.size());
    }

    @Test
    public void testParameterTypes_iterable() {
        MemberAdapter member = this.getMember(_ParameterTypesData.class, "iterable");
        Assert.assertTrue((boolean)member.getType().isIterable());
        List parameterTypes = member.getParameterTypes();
        Assert.assertEquals((long)1L, (long)parameterTypes.size());
        Assert.assertTrue((boolean)((TypeAdapter)parameterTypes.get(0)).isSameType(String.class));
    }

    @Test
    public void testParameterTypes_array() {
        MemberAdapter member = this.getMember(_ParameterTypesData.class, "array");
        Assert.assertTrue((boolean)member.getType().isArray());
        List parameterTypes = member.getParameterTypes();
        Assert.assertEquals((long)1L, (long)parameterTypes.size());
        Assert.assertTrue((boolean)((TypeAdapter)parameterTypes.get(0)).isSameType(String.class));
    }

    @Test
    public void testMemberInheritance() throws Exception {
        ArrayList<MemberAdapter> members = new ArrayList<MemberAdapter>(this.listMembers(_InheritanceChild.class));
        Assert.assertEquals((long)2L, (long)members.size());
        Assert.assertEquals((Object)"parentString", (Object)((MemberAdapter)members.get(0)).getName());
        Assert.assertEquals((Object)"_InheritanceParent", (Object)((MemberAdapter)members.get(0)).getDeclaringType().simpleName());
        Assert.assertEquals((Object)"childString", (Object)((MemberAdapter)members.get(1)).getName());
        Assert.assertEquals((Object)"_InheritanceChild", (Object)((MemberAdapter)members.get(1)).getDeclaringType().simpleName());
    }

    static class _InheritanceChild
    extends _InheritanceParent {
        String childString;

        _InheritanceChild() {
        }
    }

    static class _InheritanceParent {
        String parentString;

        _InheritanceParent() {
        }
    }

    static class _ParameterTypesData {
        Map<String, String> map;
        Map rawMap;
        Map<?, ?> wildcardMap;
        Map<String, ?> wildcardValueMap;
        List<String> list;
        List rawList;
        List<List> listOfRaw;
        List<List<?>> listOfWildcard;
        Iterable<String> iterable;
        String[] array;

        _ParameterTypesData() {
        }
    }
}

