/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.testing;

import io.takari.builder.Builder;
import io.takari.builder.Dependencies;
import io.takari.builder.DependencyResources;
import io.takari.builder.IArtifactMetadata;
import io.takari.builder.IArtifactResources;
import io.takari.builder.Parameter;
import io.takari.builder.ResolutionScope;
import io.takari.builder.testing.BuilderExecution;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BuilderExecutionTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testDependencies_withParameter() throws Exception {
        BuilderExecution.builderExecution((File)this.temp.newFolder(), _ArtifactMetadataBuilder.class).withParameterValue("dependencies", Arrays.asList(BuilderExecution.newArtifactMetadata((String)"g:a:1"))).execute();
    }

    @Test
    public void testDependencies_withDependency() throws Exception {
        BuilderExecution.builderExecution((File)this.temp.newFolder(), _ArtifactMetadataBuilder.class).withDependency("g:a:1", this.temp.newFile()).execute();
    }

    @Test
    public void testDependencies_withTransitiveDependency() throws Exception {
        BuilderExecution.builderExecution((File)this.temp.newFolder(), _TransitiveArtifactMetadataBuilder.class).withTransitiveDependency("gt:at:1", this.temp.newFile()).execute();
    }

    @Test
    public void testDependencyResources_withParameter() throws Exception {
        URL url = this.temp.newFile().toURI().toURL();
        BuilderExecution.builderExecution((File)this.temp.newFolder(), _ArtifactResourcesBuilder.class).withParameterValue("dependencies", Arrays.asList(BuilderExecution.newArtifactResources((String)"g:a:1", (URL[])new URL[]{url}))).execute();
    }

    @Test
    public void testDependencyResources_withDependency() throws Exception {
        File dep = this.temp.newFolder();
        new File(dep, "a.txt").createNewFile();
        BuilderExecution.builderExecution((File)this.temp.newFolder(), _ArtifactResourcesBuilder.class).withDependency("g:a:1", dep).execute();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithUnknownParameter() throws Exception {
        BuilderExecution.builderExecution((File)this.temp.newFolder(), _SimpleBuilder.class).withParameterValue("unknown", (Object)"value").execute();
    }

    static class _ArtifactMetadataBuilder {
        @Dependencies(scope=ResolutionScope.COMPILE)
        List<IArtifactMetadata> dependencies;

        _ArtifactMetadataBuilder() {
        }

        @Builder(name="test")
        public void execute() {
            Assertions.assertThat(this.dependencies).hasSize(1);
        }
    }

    static class _ArtifactResourcesBuilder {
        @DependencyResources(scope=ResolutionScope.COMPILE, includes={"**/*"})
        List<IArtifactResources> dependencies;

        _ArtifactResourcesBuilder() {
        }

        @Builder(name="test")
        public void execute() {
            Assertions.assertThat(this.dependencies).hasSize(1);
        }
    }

    static class _SimpleBuilder {
        @Parameter(required=false)
        String parameter;

        _SimpleBuilder() {
        }

        @Builder(name="test")
        public void execute() {
        }
    }

    static class _TransitiveArtifactMetadataBuilder {
        @Dependencies(scope=ResolutionScope.COMPILE)
        List<IArtifactMetadata> dependencies;
        @Dependencies(scope=ResolutionScope.COMPILE, transitive=false)
        List<IArtifactMetadata> directDependencies;

        _TransitiveArtifactMetadataBuilder() {
        }

        @Builder(name="test")
        public void execute() {
            Assertions.assertThat(this.dependencies).hasSize(1);
            Assertions.assertThat(this.directDependencies).isNull();
        }
    }
}

