/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.testing;

import io.takari.builder.Builder;
import io.takari.builder.DependencyResources;
import io.takari.builder.ResolutionScope;
import io.takari.builder.enforcer.ComposableSecurityManagerPolicy;
import io.takari.builder.enforcer.Policy;
import io.takari.builder.testing.BuilderExecution;
import io.takari.maven.testing.TestResources;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;

public class ReadFromJarTest {
    @Rule
    public final TestResources resources = new TestResources();

    @Test
    public void testReadJarDoesNotTriggerWriteCheck() throws Exception {
        File basedir = this.resources.getBasedir("jar-reader");
        File junitJar = new File(basedir, "junit-4.12.jar");
        ReadFromJarTest.enterTestScope();
        try {
            BuilderExecution.builderExecution((File)basedir, _Builder.class).withDependency("junit:junit:4.12", junitJar).executeWithoutRuntime();
        }
        finally {
            ReadFromJarTest.leaveTestScope();
        }
    }

    private static void enterTestScope() {
        ComposableSecurityManagerPolicy.setSystemSecurityManager();
        ComposableSecurityManagerPolicy.setDefaultPolicy((Policy)new Policy(){

            public void checkWrite(String file) {
            }

            public void checkSocketPermission() {
            }

            public void checkRead(String file) {
            }

            public void checkPropertyPermission(String action, String name) {
            }

            public void checkExec(String cmd) {
            }
        });
    }

    private static void leaveTestScope() {
        ComposableSecurityManagerPolicy.setDefaultPolicy(null);
        ComposableSecurityManagerPolicy.removeSystemSecurityManager();
    }

    public static class _Builder {
        @DependencyResources(includes={"LICENSE-junit.txt"}, scope=ResolutionScope.COMPILE)
        List<URL> resources;

        @Builder(name="build")
        void build() {
        }
    }
}

