/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.mailconnector.imap;

import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.exceptions.SystemException;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.mailconnector.util.AbstractInboxConnector;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Store;

public class ImapMailConnector
extends AbstractInboxConnector
implements Loggable {
    public ImapMailConnector() {
        this.init();
    }

    private void init() {
        this.setServer(PropertyManager.getProperty((String)"IMAP_SERVER", null));
        this.setPort(PropertyManager.getProperty((String)"IMAP_SERVER_PORT", null));
        this.setInboxFolder(PropertyManager.getProperty((String)"IMAP_FOLDER_INBOX", null));
        this.setUsername(PropertyManager.getProperty((String)"IMAP_USERNAME", null));
        this.setPassword(PropertyManager.getProperty((String)"IMAP_PASSWORD", null));
        this.setSslEnabled(PropertyManager.getBooleanProperty((String)"IMAP_SSL_ENABLED", (boolean)true));
        this.setDebug(PropertyManager.getBooleanProperty((String)"DEBUG_SETTING", (boolean)false));
    }

    @Override
    protected void openSession() {
        Properties mailprops = new Properties();
        if (this.isSslEnabled()) {
            mailprops.put("mail.store.protocol", "imaps");
        } else {
            mailprops.put("mail.store.protocol", "imap");
        }
        this.setSession(this.createDefaultSession(mailprops, mailprops.getProperty("mail.store.protocol")));
    }

    public void markAllMailsAsSeen() throws SystemException {
        this.pMarkAllMailsAsSeen();
    }

    private void pMarkAllMailsAsSeen() throws SystemException {
        try {
            Message[] messages;
            Store store = this.getSession().getStore();
            store.connect(this.getServer(), this.getUsername(), this.getPassword());
            Folder root = store.getDefaultFolder();
            Folder folder = root.getFolder(this.getInboxFolder());
            folder.open(2);
            for (Message message : messages = folder.getMessages()) {
                message.setFlag(Flags.Flag.SEEN, true);
            }
            store.close();
        }
        catch (NoSuchProviderException e) {
            this.log().error(e.getMessage());
            throw new SystemException((Throwable)e);
        }
        catch (MessagingException e) {
            this.log().error(e.getMessage());
            throw new SystemException((Throwable)e);
        }
    }
}

