/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.mailconnector.smtp;

import eu.tsystems.mms.tic.testframework.common.PropertyManager;
import eu.tsystems.mms.tic.testframework.exceptions.SystemException;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.mailconnector.util.AbstractMailConnector;
import java.io.File;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.iharder.Base64;

public class SMTPMailConnector
extends AbstractMailConnector
implements Loggable {
    private String messageID;
    private MimeMessage lastSentMessage;

    public SMTPMailConnector() {
        this.init();
    }

    private void init() {
        this.setUsername(PropertyManager.getProperty((String)"SMTP_USERNAME", null));
        this.setPassword(PropertyManager.getProperty((String)"SMTP_PASSWORD", null));
        this.setServer(PropertyManager.getProperty((String)"SMTP_SERVER", null));
        this.setPort(PropertyManager.getProperty((String)"SMTP_SERVER_PORT", null));
        this.setDebug(PropertyManager.getBooleanProperty((String)"DEBUG_SETTING", (boolean)false));
        this.setSslEnabled(PropertyManager.getBooleanProperty((String)"SMTP_SSL_ENABLED", (boolean)false));
    }

    @Override
    protected void openSession() {
        Properties mailprops = new Properties();
        String protocol = this.isSslEnabled() ? "smtps" : "smtp";
        mailprops.setProperty("mail.transport.protocol", protocol);
        mailprops.put("mail." + protocol + ".auth", "true");
        this.setSession(this.createDefaultSession(mailprops, protocol));
    }

    public void sendMessage(MimeMessage message) throws SystemException {
        this.pSendMessage(message);
    }

    private void pSendMessage(MimeMessage message) throws SystemException {
        Transport transport = null;
        try {
            transport = this.getSession().getTransport();
            transport.connect();
            if (message.getMessageID() != null) {
                this.messageID = message.getMessageID();
            }
            transport.sendMessage((Message)message, message.getAllRecipients());
            this.log().info("Message sent! ");
            transport.close();
            this.lastSentMessage = message;
        }
        catch (Exception e) {
            this.log().error("Unable to send email", (Throwable)e);
        }
    }

    public MimeBodyPart createAttachment(File file) {
        return this.pCreateAttachment(file);
    }

    private MimeBodyPart pCreateAttachment(File file) {
        MimeBodyPart attachment = new MimeBodyPart();
        try {
            attachment.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
            attachment.setFileName(file.getName());
            attachment.setDisposition("attachment");
        }
        catch (MessagingException e) {
            this.log().error("Unable to create attachment", (Throwable)e);
        }
        return attachment;
    }

    public MimeMessage addAttachmentsToMessage(MimeBodyPart[] attachments, Message message) {
        return this.pAddAttachmentsToMessage(attachments, message);
    }

    private MimeMessage pAddAttachmentsToMessage(MimeBodyPart[] attachments, Message message) {
        try {
            MimeMultipart mimeMultipart = new MimeMultipart();
            MimeBodyPart text = new MimeBodyPart();
            text.setText(message.getContent().toString());
            text.setDisposition("inline");
            mimeMultipart.addBodyPart((BodyPart)text);
            for (MimeBodyPart attachment : attachments) {
                mimeMultipart.addBodyPart((BodyPart)attachment);
            }
            message.setContent((Multipart)mimeMultipart);
            message.saveChanges();
        }
        catch (Exception e) {
            this.log().error("Unable to add attachment", (Throwable)e);
        }
        return (MimeMessage)message;
    }

    public MimeMessage generateVirusMail(String from, String receiver, String ccReceiver, String bcc) throws SystemException, RuntimeException {
        return this.pGenerateVirusMail(from, receiver, ccReceiver, bcc);
    }

    private MimeMessage pGenerateVirusMail(String from, String receiver, String ccReceiver, String bcc) throws SystemException, RuntimeException {
        MimeMessage message = new MimeMessage(this.getSession());
        try {
            message.setFrom((Address)new InternetAddress(from));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(receiver));
            if (ccReceiver != null) {
                message.setRecipient(Message.RecipientType.CC, (Address)new InternetAddress(ccReceiver));
            }
            if (bcc != null) {
                message.setRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
            }
            String virusPattern = "X5O!P%@AP[4\\PZX54(P^)7CC)7}$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*";
            message.setSubject("Antivirus-Test");
            MimeMultipart multiPart = new MimeMultipart();
            MimeBodyPart bp1 = new MimeBodyPart();
            bp1.setContent(String.class, "text/plain");
            multiPart.addBodyPart((BodyPart)bp1);
            byte[] encoded = Base64.encodeBytes((byte[])"X5O!P%@AP[4\\PZX54(P^)7CC)7}$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*".getBytes()).getBytes();
            MimeBodyPart bp2 = new MimeBodyPart();
            bp2.setFileName("virus.exe");
            bp2.setContent((Object)encoded, "application/octet-stream");
            bp2.setHeader("Content-Transfer-Encoding", "base64");
            multiPart.addBodyPart((BodyPart)bp2);
            message.setContent((Multipart)multiPart);
            message.saveChanges();
        }
        catch (AddressException aex) {
            throw new RuntimeException("Some of the address parameters were wrong.", aex);
        }
        catch (MessagingException e) {
            throw new SystemException((Throwable)e);
        }
        return message;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public MimeMessage getLastSentMessage() {
        return this.lastSentMessage;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public void setLastSentMessage(MimeMessage lastSentMessage) {
        this.lastSentMessage = lastSentMessage;
    }
}

