/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.mailconnector.util;

import eu.tsystems.mms.tic.testframework.exceptions.SystemException;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.mailconnector.util.AbstractMailConnector;
import eu.tsystems.mms.tic.testframework.mailconnector.util.DeleteCriteriaType;
import eu.tsystems.mms.tic.testframework.mailconnector.util.Email;
import eu.tsystems.mms.tic.testframework.mailconnector.util.EmailQuery;
import eu.tsystems.mms.tic.testframework.mailconnector.util.SearchCriteria;
import eu.tsystems.mms.tic.testframework.mailconnector.util.SearchCriteriaType;
import eu.tsystems.mms.tic.testframework.utils.TimerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.AndTerm;
import javax.mail.search.FromTerm;
import javax.mail.search.MessageIDTerm;
import javax.mail.search.RecipientTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SubjectTerm;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractInboxConnector
extends AbstractMailConnector
implements Loggable {
    @Deprecated
    public List<Email> waitForMails(List<SearchCriteria> searchCriterias) throws AddressException {
        EmailQuery query = new EmailQuery();
        return this.waitForMails(searchCriterias, query.getRetryCount(), Math.round((float)query.getPauseMs() / 1000.0f));
    }

    @Deprecated
    public List<Email> waitForMails(SearchTerm searchTerm) {
        EmailQuery query = new EmailQuery();
        return this.waitForMails(searchTerm, query.getRetryCount(), Math.round((float)query.getPauseMs() / 1000.0f));
    }

    @Deprecated
    public List<Email> waitForMails(SearchTerm searchTerm, String folderName) {
        EmailQuery query = new EmailQuery();
        return this.waitForMails(searchTerm, query.getRetryCount(), Math.round((float)query.getPauseMs() / 1000.0f), folderName);
    }

    @Deprecated
    public List<Email> waitForMails(List<SearchCriteria> searchCriterias, int maxReadTries, int pollingTimerSeconds) throws AddressException {
        SearchTerm searchTerm = this.translateSearchCriterias(searchCriterias);
        return this.waitForMails(searchTerm, maxReadTries, pollingTimerSeconds);
    }

    private SearchTerm[] getSearchTermsFromSearchCriterias(SearchCriteria[] searchCriterias) throws AddressException {
        SearchTerm[] searchTerms = new SearchTerm[searchCriterias.length];
        for (int i = 0; i < searchCriterias.length; ++i) {
            searchTerms[i] = this.translateSearchCriterias(Collections.singletonList(searchCriterias[i]));
        }
        return searchTerms;
    }

    private SearchTerm translateSearchCriterias(List<SearchCriteria> searchCriterias) throws AddressException {
        SearchTerm searchTerm;
        int searchCriteriasSize = searchCriterias.size();
        switch (searchCriteriasSize) {
            case 0: {
                searchTerm = null;
                break;
            }
            case 1: {
                searchTerm = this.pTranslateSearchCriteriaToSearchTerm(searchCriterias.get(0));
                break;
            }
            default: {
                SearchTerm[] searchTerms = new SearchTerm[searchCriteriasSize];
                for (int i = 0; i < searchCriteriasSize; ++i) {
                    searchTerms[i] = this.pTranslateSearchCriteriaToSearchTerm(searchCriterias.get(i));
                }
                searchTerm = new AndTerm(searchTerms);
            }
        }
        return searchTerm;
    }

    private SearchTerm pTranslateSearchCriteriaToSearchTerm(SearchCriteria searchCriteria) throws AddressException {
        SearchCriteriaType searchCriteriaType = searchCriteria.getSearchCriteriaType();
        switch (searchCriteriaType) {
            case SENDER: {
                String sender = searchCriteria.getStringValue();
                return new FromTerm((Address)new InternetAddress(sender));
            }
            case RECIPIENT: {
                String recipient = searchCriteria.getStringValue();
                return new RecipientTerm(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            }
            case SUBJECT: {
                String subject = searchCriteria.getStringValue();
                return new SubjectTerm(subject);
            }
            case AFTER_DATE: {
                Date expectedDate = (Date)searchCriteria.getValue();
                return new SentDateTerm(6, expectedDate);
            }
            case MESSAGEID: {
                String messageId = searchCriteria.getStringValue();
                return new MessageIDTerm(messageId);
            }
        }
        throw new SystemException("Not yet implemented: " + (Object)((Object)searchCriteriaType));
    }

    public List<Email> waitForMails(SearchTerm searchTerm, int maxReadTries, int pollingTimerSeconds) {
        return this.waitForMails(searchTerm, maxReadTries, pollingTimerSeconds, this.getInboxFolder());
    }

    public List<Email> waitForMails(SearchTerm searchTerm, int maxReadTries, int pollingTimerSeconds, String folderName) {
        EmailQuery query = new EmailQuery().setSearchTerm(searchTerm).setRetryCount(maxReadTries).setPauseMs(pollingTimerSeconds * 1000).setFolderName(folderName);
        List<Email> emailList = this.query(query).collect(Collectors.toList());
        if (emailList.isEmpty()) {
            throw new RuntimeException(String.format("No messages found after %s seconds.", pollingTimerSeconds * maxReadTries));
        }
        return emailList;
    }

    public Stream<Email> query(EmailQuery query) {
        Stream<Email> emailStream;
        String folderName = query.getFolderName();
        if (folderName == null) {
            folderName = this.getInboxFolder();
        }
        try {
            Stream<MimeMessage> messageStream = this.waitForMessages(query.getSearchTerm(), query.getRetryCount(), query.getPauseMs(), folderName);
            emailStream = messageStream.map(Email::new);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Could not query emails", e);
        }
        return emailStream;
    }

    private Stream<MimeMessage> waitForMessages(SearchTerm searchTerm, int maxReadTries, long pauseMs, String foldername) throws MessagingException {
        Stream<MimeMessage> mimeMessages = Stream.empty();
        if (maxReadTries < 1) {
            maxReadTries = 1;
        }
        for (int i = 0; i < maxReadTries; ++i) {
            Session session = this.getSession();
            Store store = session.getStore();
            store.connect();
            Folder folder = store.getFolder(foldername);
            folder.open(1);
            Runnable closeStoreAndFolder = () -> {
                try {
                    folder.close();
                    store.close();
                }
                catch (MessagingException e) {
                    this.log().error("Unable to close", (Throwable)e);
                }
            };
            Message[] messages = searchTerm != null ? folder.search(searchTerm) : folder.getMessages();
            if (messages.length != 0) {
                mimeMessages = ((Stream)Stream.of(messages).onClose(closeStoreAndFolder)).map(message -> {
                    MimeMessage mimeMessage = null;
                    try {
                        mimeMessage = new MimeMessage((MimeMessage)message);
                    }
                    catch (MessagingException e) {
                        this.log().warn("Unable to create " + MimeMessage.class.getSimpleName(), (Throwable)e);
                    }
                    return Optional.ofNullable(mimeMessage);
                }).filter(Optional::isPresent).map(Optional::get);
                break;
            }
            TimerUtils.sleep((int)Long.valueOf(pauseMs).intValue(), (String)("waiting for emails (try: " + (i + 1) + "/" + maxReadTries + ")"));
            closeStoreAndFolder.run();
        }
        return mimeMessages;
    }

    public long getMessageCount() {
        return this.pGetMessageCount(this.getInboxFolder());
    }

    public long getMessageCount(String folderName) {
        return this.pGetMessageCount(folderName);
    }

    private int pGetMessageCount(String folderName) {
        int nrOfMessages;
        try {
            Store store = this.getSession().getStore();
            store.connect(this.getServer(), this.getUsername(), this.getPassword());
            Folder root = store.getDefaultFolder();
            Folder folder = root.getFolder(folderName);
            folder.open(1);
            nrOfMessages = folder.getMessageCount();
            store.close();
        }
        catch (NoSuchProviderException e) {
            this.log().error(e.getMessage());
            throw new RuntimeException(e);
        }
        catch (MessagingException e) {
            this.log().error("Error in getMessageCount", (Throwable)e);
            throw new RuntimeException(e);
        }
        return nrOfMessages;
    }

    public boolean deleteMessage(String recipient, Message.RecipientType recipientType, String subject, String messageId) {
        return this.pDeleteMessage(recipient, recipientType, subject, messageId);
    }

    public boolean deleteMessage(Email mail) {
        return this.deleteMessage((SearchTerm)new MessageIDTerm(mail.getMessageID()));
    }

    @Deprecated
    public boolean deleteMessage(List<List<SearchCriteria>> messagesCriterias) throws AddressException {
        boolean isDeleted = false;
        for (List<SearchCriteria> messageCriterias : messagesCriterias) {
            SearchTerm searchTerm = this.translateSearchCriterias(messageCriterias);
            isDeleted = this.deleteMessage(searchTerm);
        }
        return isDeleted;
    }

    public boolean deleteMessages(List<SearchTerm> searchTerms) {
        boolean isDeleted = false;
        for (SearchTerm searchTerm : searchTerms) {
            isDeleted = this.deleteMessage(searchTerm);
        }
        return isDeleted;
    }

    public boolean deleteMessage(SearchTerm searchTerm) {
        return this.pDeleteMessage(searchTerm);
    }

    public boolean deleteMessage(SearchTerm searchTerm, String folderName) {
        return this.pDeleteMessage(searchTerm, folderName);
    }

    public boolean moveMessage(String targetFolder, Email message) {
        MessageIDTerm messageIDTerm = new MessageIDTerm(message.getMessageID());
        return this.pMoveMessage(targetFolder, new SearchTerm[]{messageIDTerm}) == 1;
    }

    public int moveMessage(String targetFolder, SearchTerm ... searchTerms) {
        return this.pMoveMessage(targetFolder, searchTerms);
    }

    public int moveMessage(String targetFolder, SearchCriteria ... searchCriterias) throws AddressException {
        SearchTerm[] searchTerms = this.getSearchTermsFromSearchCriterias(searchCriterias);
        return this.moveMessage(targetFolder, searchTerms);
    }

    private int pMoveMessage(String targetFolderName, SearchTerm ... searchTerms) {
        int count;
        try {
            Store store = this.getSession().getStore();
            store.connect();
            Folder targetFolder = store.getFolder(targetFolderName);
            if (!targetFolder.exists()) {
                targetFolder.create(1);
            }
            Folder folder = store.getFolder(this.getInboxFolder());
            folder.open(2);
            this.log().info("Checking messages from " + this.getInboxFolder() + " for MessageID:");
            ArrayList<Message> copyList = new ArrayList<Message>();
            for (SearchTerm searchTerm : searchTerms) {
                Message[] messages = folder.search(searchTerm);
                copyList.addAll(Arrays.asList(messages));
            }
            Message[] msgArray = copyList.toArray(new Message[0]);
            folder.copyMessages(msgArray, targetFolder);
            count = msgArray.length;
            folder.setFlags(msgArray, new Flags(Flags.Flag.DELETED), true);
            folder.close(true);
            store.close();
        }
        catch (MessagingException e) {
            this.log().error(e.getMessage());
            throw new RuntimeException(e);
        }
        return count;
    }

    @Deprecated
    public boolean deleteMessages(List<String> deleteCriteriaValues, DeleteCriteriaType deleteCriteriaType) {
        ArrayList<Boolean> booleanValues = new ArrayList<Boolean>();
        for (String deleteCriteriaValue : deleteCriteriaValues) {
            boolean isDeleted;
            switch (deleteCriteriaType) {
                case RECIPIENT: {
                    isDeleted = this.deleteMessage(deleteCriteriaValue, Message.RecipientType.TO, null, null);
                    break;
                }
                case SUBJECT: {
                    isDeleted = this.deleteMessage(null, Message.RecipientType.TO, deleteCriteriaValue, null);
                    break;
                }
                case MESSAGEID: {
                    isDeleted = this.deleteMessage(null, Message.RecipientType.TO, null, deleteCriteriaValue);
                    break;
                }
                default: {
                    throw new SystemException("Not supported: " + (Object)((Object)deleteCriteriaType));
                }
            }
            booleanValues.add(isDeleted);
        }
        for (Boolean booleanValue : booleanValues) {
            if (booleanValue.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean deleteMessage(List<String> deleteCriteriaValues, DeleteCriteriaType deleteCriteriaType) {
        return this.deleteMessages(deleteCriteriaValues, deleteCriteriaType);
    }

    public boolean deleteAllMessages() {
        return this.pDeleteMessage(null);
    }

    private boolean pDeleteMessage(SearchTerm searchTerm) {
        return this.pDeleteMessage(searchTerm, this.getInboxFolder());
    }

    private boolean pDeleteMessage(SearchTerm searchTerm, String folderName) {
        boolean deleted = false;
        try {
            Store store = this.getSession().getStore();
            store.connect();
            Folder folder = store.getFolder(folderName);
            folder.open(2);
            Message[] messages = searchTerm != null ? folder.search(searchTerm) : folder.getMessages();
            this.log().info("Checking messages from " + this.getInboxFolder() + " for MessageID:");
            if (messages.length > 0) {
                String msg = "Message found, DELETING";
                for (Message message : messages) {
                    if (message.getSubject() != null) {
                        msg = msg + ": " + message.getSubject();
                    }
                    this.log().info(msg);
                    message.setFlag(Flags.Flag.DELETED, true);
                }
            } else {
                this.log().info("None.");
            }
            folder.close(true);
            store.close();
        }
        catch (MessagingException e) {
            this.log().error(e.getMessage());
            throw new RuntimeException(e);
        }
        return deleted;
    }

    @Deprecated
    private boolean pDeleteMessage(String recipient, Message.RecipientType recipientType, String subject, String messageId) {
        boolean deleted = false;
        try {
            Store store = this.getSession().getStore();
            store.connect();
            Folder folder = store.getFolder(this.getInboxFolder());
            folder.open(2);
            Message[] messages = folder.getMessages();
            this.log().info("Checking messages from " + this.getInboxFolder() + " for MessageID:");
            if (messages.length > 0) {
                for (Message message : messages) {
                    deleted = this.compareMessageAndDelete(message, recipient, recipientType, subject, messageId);
                }
            } else {
                this.log().info("None.");
            }
            folder.close(true);
            store.close();
        }
        catch (MessagingException e) {
            this.log().error(e.getMessage());
            throw new RuntimeException(e);
        }
        return deleted;
    }

    private boolean compareMessageAndDelete(Message message, String recipient, Message.RecipientType recipientType, String subject, String messageId) {
        try {
            boolean found;
            InternetAddress recipientAddress;
            if ((subject == null || message.getSubject() == null) && recipient != null) {
                recipientAddress = new InternetAddress(recipient);
                found = ArrayUtils.contains((Object[])message.getRecipients(recipientType), (Object)recipientAddress);
            } else if (subject != null && message.getSubject() != null && recipient == null) {
                found = message.getSubject().equals(subject);
            } else if (subject != null && recipient != null) {
                recipientAddress = new InternetAddress(recipient);
                found = message.getSubject().equals(subject) && ArrayUtils.contains((Object[])message.getRecipients(recipientType), (Object)recipientAddress);
            } else {
                found = true;
            }
            if (((MimeMessage)message).getMessageID() != null && messageId != null) {
                boolean bl = found = found && ((MimeMessage)message).getMessageID().equals(messageId);
            }
            if (found) {
                String msg = "Message found, DELETING";
                if (message.getSubject() != null) {
                    msg = msg + ": " + message.getSubject();
                }
                this.log().info(msg);
                message.setFlag(Flags.Flag.DELETED, true);
                return true;
            }
            return false;
        }
        catch (MessageRemovedException e) {
            this.log().error("Error deleting message: " + e.getMessage());
            return false;
        }
        catch (MessagingException e) {
            this.log().error("Error handling message", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

