/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.mailconnector.util;

import eu.tsystems.mms.tic.testframework.logging.Loggable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;

public class Email
implements Loggable {
    private final Map<String, String> attachments;
    private String messageText;
    private final MimeMessage message;
    private final List<String> recipientList = new LinkedList<String>();
    private final List<String> senderList = new LinkedList<String>();
    private String subject = null;
    private String messageID;
    private Date sentDate;

    public MimeMessage getMessage() {
        return this.message;
    }

    private void setRecipientsFromAddressArray(Address[] allRecipients) {
        if (allRecipients != null) {
            for (Address address : allRecipients) {
                this.recipientList.add(address.toString());
            }
        }
    }

    private void setSendersFromAddressArray(Address[] allSenders) {
        if (allSenders != null) {
            for (Address address : allSenders) {
                this.senderList.add(address.toString());
            }
        }
    }

    private void setSubject(String subject) {
        this.subject = subject;
    }

    public List<String> getRecipients() {
        return this.recipientList;
    }

    public List<String> getSenders() {
        return this.senderList;
    }

    public String getSubject() {
        return this.subject;
    }

    public Email(MimeMessage javaMessage) {
        this.attachments = new HashMap<String, String>();
        this.message = javaMessage;
        this.readMessageContents();
        try {
            this.setSubject(javaMessage.getSubject());
        }
        catch (MessagingException e) {
            this.setSubject("");
        }
        try {
            this.setMessageID(javaMessage.getMessageID());
        }
        catch (MessagingException e) {
            this.setMessageID(null);
        }
        try {
            this.setSentDate(javaMessage.getSentDate());
        }
        catch (MessagingException e) {
            this.setSentDate(null);
        }
        try {
            Address[] allRecipients = javaMessage.getAllRecipients();
            this.setRecipientsFromAddressArray(allRecipients);
        }
        catch (MessagingException e) {
            this.setRecipientsFromAddressArray(null);
        }
        try {
            Address[] allSenders = javaMessage.getFrom();
            this.setSendersFromAddressArray(allSenders);
        }
        catch (MessagingException e) {
            this.setSendersFromAddressArray(null);
        }
    }

    private void readMessageContents() {
        block7: {
            try {
                if (this.message.getContentType().startsWith("multipart")) {
                    Multipart multipart = (Multipart)this.message.getContent();
                    for (int j = 0; j < multipart.getCount(); ++j) {
                        String mail;
                        InputStream is = ((Multipart)this.message.getContent()).getBodyPart(j).getInputStream();
                        String encoding = ((Multipart)this.message.getContent()).getBodyPart(j).getContentType();
                        encoding = this.getCharSetForEncoding(encoding);
                        try {
                            mail = IOUtils.toString((InputStream)is, (String)encoding).replaceAll("\r", "");
                        }
                        catch (IllegalCharsetNameException e) {
                            this.log().error("Unable to encode attachement", (Throwable)e);
                            mail = null;
                        }
                        String attachmentName = ((Multipart)this.message.getContent()).getBodyPart(j).getFileName();
                        if (j == 0) {
                            this.messageText = mail;
                            continue;
                        }
                        this.attachments.put(attachmentName, mail);
                    }
                    break block7;
                }
                InputStream is = this.message.getInputStream();
                String encoding = this.message.getContentType();
                encoding = this.getCharSetForEncoding(encoding);
                this.messageText = IOUtils.toString((InputStream)is, (String)encoding).replaceAll("\r", "");
            }
            catch (IOException | MessagingException ex) {
                this.log().error("Unable to read email details", ex);
            }
        }
    }

    private String getCharSetForEncoding(String encoding) {
        int indexOfEncoding = encoding.lastIndexOf("charset=");
        if (indexOfEncoding > -1) {
            int index = (encoding = encoding.substring(indexOfEncoding + 8)).indexOf(59);
            if (index > 0) {
                encoding = encoding.substring(0, encoding.indexOf(59));
            }
            encoding = encoding.replace("\"", "");
        } else {
            this.log().warn("No encoding found in email. Using '" + StandardCharsets.UTF_8.name() + "' instead");
            encoding = StandardCharsets.UTF_8.name();
        }
        return encoding;
    }

    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public String getAttachmentsContent(String fileName) {
        return this.attachments.get(fileName);
    }

    public String getMessageText() {
        return this.messageText;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }
}

