/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.mailconnector.util;

import com.sun.mail.util.BASE64DecoderStream;
import eu.tsystems.mms.tic.testframework.exceptions.SystemException;
import eu.tsystems.mms.tic.testframework.mailconnector.util.Email;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.iharder.Base64;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.examples.ExampleUtils;
import org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailUtils.class);

    private MailUtils() {
    }

    public static String encodeBase64(String password) {
        return MailUtils.pEncodeBase64(password);
    }

    private static String pEncodeBase64(String password) {
        String encode = Base64.encodeBytes((byte[])password.getBytes());
        encode = encode.replaceAll("\n", "").replaceAll("\r", "");
        return encode;
    }

    public static boolean compareSentAndReceivedEmailContents(MimeMessage sent, Email received) {
        return MailUtils.pCompareSentAndReceivedEmailContents(sent, received);
    }

    public static boolean compareSentAndReceivedEmailContents(MimeMessage sent, Message received) {
        return MailUtils.pCompareSentAndReceivedEmailContents(sent, received);
    }

    private static boolean pCompareSentAndReceivedEmailContents(MimeMessage sent, Email received) {
        try {
            String contentTypeSentMessage = sent.getContentType();
            String contentTypeReceivedMessage = received.getMessage().getContentType();
            if (!contentTypeSentMessage.equals(contentTypeReceivedMessage)) {
                LOGGER.error("Content types not equal: " + contentTypeSentMessage + "<>" + contentTypeReceivedMessage);
                return false;
            }
            Object contentMailSent = sent.getContent();
            if (contentMailSent instanceof BASE64DecoderStream) {
                LOGGER.info("Content is an instance of BASE64DecoderStream");
                InputStream sentB64 = (InputStream)contentMailSent;
                InputStream receivedB64 = (InputStream)received.getMessage().getContent();
                return IOUtils.contentEquals((InputStream)sentB64, (InputStream)receivedB64);
            }
            if (contentMailSent instanceof MimeMultipart) {
                LOGGER.info("Content is an instance of MimeMultipart");
                MimeMultipart sentMulti = (MimeMultipart)contentMailSent;
                MimeMultipart receivedMulti = (MimeMultipart)received.getMessage().getContent();
                ByteArrayOutputStream sentOutStream = new ByteArrayOutputStream();
                ByteArrayOutputStream received2OutStream = new ByteArrayOutputStream();
                sentMulti.writeTo((OutputStream)sentOutStream);
                receivedMulti.writeTo((OutputStream)received2OutStream);
                byte[] sentBytes = sentOutStream.toByteArray();
                byte[] receivedBytes = received2OutStream.toByteArray();
                ByteArrayInputStream sentInStream = new ByteArrayInputStream(sentBytes);
                ByteArrayInputStream receivedInStream = new ByteArrayInputStream(receivedBytes);
                return IOUtils.contentEquals((InputStream)sentInStream, (InputStream)receivedInStream);
            }
            if (contentMailSent instanceof String) {
                LOGGER.info("Content is an instance of String");
                String sentStr = contentMailSent.toString().trim();
                String receivedStr = received.getMessageText().trim();
                String contentType = contentTypeSentMessage;
                contentType = contentType.split("charset=")[1];
                return Arrays.equals(sentStr.getBytes(contentType), receivedStr.getBytes(contentType));
            }
            LOGGER.error("Content type is unknown: " + sent.getContent());
        }
        catch (Exception e) {
            throw new SystemException("Error comparing messages.", (Throwable)e);
        }
        return false;
    }

    private static boolean pCompareSentAndReceivedEmailContents(MimeMessage sent, Message received) {
        try {
            String contentTypeSentMessage = sent.getContentType().toLowerCase();
            String contentTypeReceivedMessage = received.getContentType().toLowerCase();
            if (!contentTypeSentMessage.equals(contentTypeReceivedMessage)) {
                LOGGER.error("Content types not equal: " + sent.getContentType() + "<>" + received.getContentType());
                return false;
            }
            if (sent.getContent() instanceof BASE64DecoderStream) {
                LOGGER.info("Content is an instance of BASE64DecoderStream");
                InputStream sentB64 = (InputStream)sent.getContent();
                InputStream receivedB64 = (InputStream)received.getContent();
                return IOUtils.contentEquals((InputStream)sentB64, (InputStream)receivedB64);
            }
            if (sent.getContent() instanceof MimeMultipart) {
                LOGGER.info("Content is an instance of MimeMultipart");
                MimeMultipart sentMulti = (MimeMultipart)sent.getContent();
                MimeMultipart receivedMulti = (MimeMultipart)received.getContent();
                ByteArrayOutputStream sentOutStream = new ByteArrayOutputStream();
                ByteArrayOutputStream received2OutStream = new ByteArrayOutputStream();
                sentMulti.writeTo((OutputStream)sentOutStream);
                receivedMulti.writeTo((OutputStream)received2OutStream);
                byte[] sentBytes = sentOutStream.toByteArray();
                byte[] receivedBytes = received2OutStream.toByteArray();
                ByteArrayInputStream sentInStream = new ByteArrayInputStream(sentBytes);
                ByteArrayInputStream receivedInStream = new ByteArrayInputStream(receivedBytes);
                return IOUtils.contentEquals((InputStream)sentInStream, (InputStream)receivedInStream);
            }
            if (sent.getContent() instanceof String) {
                LOGGER.info("Content is an instance of String");
                String sentStr = sent.getContent().toString().trim();
                String receivedStr = received.getContent().toString().trim();
                String contentType = sent.getContentType();
                contentType = contentType.split("charset=")[1];
                return Arrays.equals(sentStr.getBytes(contentType), receivedStr.getBytes(contentType));
            }
            LOGGER.error("Content type is unknown: " + sent.getContent());
        }
        catch (Exception e) {
            throw new SystemException("Error comparing messages.", (Throwable)e);
        }
        return false;
    }

    public static boolean compareSentAndReceivedEmailHeaders(Message sent, Message received) {
        return MailUtils.pCompareSentAndReceivedEmailHeaders(sent, received);
    }

    private static boolean pCompareSentAndReceivedEmailHeaders(Message sent, Message received) {
        try {
            MimeMessage sendedMessage = (MimeMessage)sent;
            MimeMessage receivedMessage = (MimeMessage)received;
            LOGGER.info("compareEmailwithSentEmailHeaders");
            String[] relevantHeaders = new String[]{"From:", "To:", "Message-ID:", "Subject:", "MIME-Version:", "Content-Type:", "Content-Transfer-Encoding:"};
            Enumeration headersSendedMessage = sendedMessage.getMatchingHeaderLines(relevantHeaders);
            Enumeration headersReceivedMessage = receivedMessage.getMatchingHeaderLines(relevantHeaders);
            while (headersSendedMessage.hasMoreElements() && headersReceivedMessage.hasMoreElements()) {
                String headerSendedMessage = (String)headersSendedMessage.nextElement();
                String headerReceivedMessage = (String)headersReceivedMessage.nextElement();
                LOGGER.info("Compare " + headerSendedMessage + " and " + headerReceivedMessage);
                if (headerSendedMessage != null && headerReceivedMessage != null) {
                    if (headerSendedMessage.equals(headerReceivedMessage)) continue;
                    LOGGER.error("Headers are different. " + headerSendedMessage + " doesn't match " + headerReceivedMessage);
                    return false;
                }
                if (headerSendedMessage.equals(headerReceivedMessage)) continue;
                return false;
            }
        }
        catch (Exception e) {
            throw new SystemException("Error comparing message headers.", (Throwable)e);
        }
        return true;
    }

    public static MimeMessage loadEmailFile(String filename) {
        return MailUtils.pLoadEmailFile(filename);
    }

    private static MimeMessage pLoadEmailFile(String filename) {
        MimeMessage message = null;
        try {
            Session mailSession = Session.getInstance((Properties)new Properties());
            message = new MimeMessage(mailSession, (InputStream)new FileInputStream(filename));
        }
        catch (Exception e) {
            throw new SystemException("Error loading email.", (Throwable)e);
        }
        return message;
    }

    public static void saveEmail(Message message, String filename) {
        MailUtils.pSaveEmail(message, filename);
    }

    private static void pSaveEmail(Message message, String filename) {
        File targetFile = new File(filename);
        if (targetFile.exists()) {
            targetFile.delete();
        } else {
            File targetDirectory = new File(targetFile.getParent());
            targetDirectory.mkdirs();
        }
        try {
            FileOutputStream fos = new FileOutputStream(targetFile);
            LOGGER.info("Writing email to file: " + targetFile);
            message.writeTo((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            throw new SystemException("Can't save Email.", (Throwable)e);
        }
    }

    public static void saveEmail(Email message, String filename) {
        MailUtils.pSaveEmailX(message, filename);
    }

    private static void pSaveEmailX(Email message, String filename) {
        if (new File(filename).exists()) {
            new File(filename).delete();
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            LOGGER.info("Writing email to file: " + filename);
            message.getMessage().writeTo((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            throw new SystemException("Can't save Email.", (Throwable)e);
        }
    }

    public static MimeMessage loadEmail(InputStream inputStream) {
        return MailUtils.pLoadEmail(inputStream);
    }

    private static MimeMessage pLoadEmail(InputStream inputStream) {
        MimeMessage message = null;
        try {
            Session mailSession = Session.getInstance((Properties)new Properties());
            message = new MimeMessage(mailSession, inputStream);
        }
        catch (Exception e) {
            throw new SystemException("Error loading email.", (Throwable)e);
        }
        return message;
    }

    public static MimeMessage encryptMessageWithCert(MimeMessage message, Session mailSession, String certFile) {
        return MailUtils.pEncryptMessageWithCert(message, mailSession, certFile);
    }

    private static MimeMessage pEncryptMessageWithCert(MimeMessage message, Session mailSession, String certFile) {
        MimeMessage newMessage = null;
        try {
            Enumeration headerEnum = message.getAllHeaderLines();
            LOGGER.info("Encrypt message with certificate: " + certFile);
            FileInputStream inputStream = new FileInputStream(certFile);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            ((InputStream)inputStream).close();
            SMIMEEnvelopedGenerator smeg = new SMIMEEnvelopedGenerator();
            JceKeyTransRecipientInfoGenerator recipientInfoGen = new JceKeyTransRecipientInfoGenerator(cert);
            smeg.addRecipientInfoGenerator((RecipientInfoGenerator)recipientInfoGen);
            message.saveChanges();
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            message.writeTo((OutputStream)byteOutputStream);
            ByteArrayInputStream bis = new ByteArrayInputStream(byteOutputStream.toByteArray());
            MimeBodyPart mbp = new MimeBodyPart((InputStream)bis);
            OutputEncryptor encryptor = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).build();
            MimeBodyPart encrypted = smeg.generate(mbp, encryptor);
            newMessage = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
            newMessage.setContent(encrypted.getContent(), encrypted.getContentType());
            newMessage.saveChanges();
            Enumeration compEnum = newMessage.getAllHeaderLines();
            ArrayList<String> headers = new ArrayList<String>();
            while (compEnum.hasMoreElements()) {
                headers.add((String)compEnum.nextElement());
            }
            while (headerEnum.hasMoreElements()) {
                String headerline = (String)headerEnum.nextElement();
                String hpart = headerline.split(":")[0];
                Boolean setHeader = true;
                for (String s : headers) {
                    if (!s.contains(hpart)) continue;
                    setHeader = false;
                    break;
                }
                if (setHeader.booleanValue()) {
                    newMessage.addHeaderLine(headerline);
                    LOGGER.info("Setting " + hpart);
                    continue;
                }
                LOGGER.info("Not setting " + hpart);
            }
            newMessage.saveChanges();
        }
        catch (Exception e) {
            throw new SystemException("Can't encrypt message.", (Throwable)e);
        }
        return newMessage;
    }

    public static void encryptAndSaveEmail(MimeMessage message, String filename, String certfile) {
        MailUtils.pEncryptAndSaveEmail(message, filename, certfile);
    }

    private static void pEncryptAndSaveEmail(MimeMessage message, String filename, String certfile) {
        MimeMessage encM = MailUtils.encryptMessageWithCert(message, Session.getDefaultInstance((Properties)new Properties()), certfile);
        MailUtils.saveEmail((Message)encM, filename);
    }

    public static MimeMessage encryptMessageWithKeystore(MimeMessage message, Session mailSession, String keyfile, String password) {
        return MailUtils.pEncryptMessageWithKeystore(message, mailSession, keyfile, password);
    }

    private static MimeMessage pEncryptMessageWithKeystore(MimeMessage message, Session mailSession, String keyfile, String password) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        MimeMessage smimeEncryptedMsg = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            String keyAlias = ExampleUtils.findKeyAlias((KeyStore)keyStore, (String)keyfile, (char[])password.toCharArray());
            Certificate[] chain = keyStore.getCertificateChain(keyAlias);
            SMIMEEnvelopedGenerator smeg = new SMIMEEnvelopedGenerator();
            JceKeyTransRecipientInfoGenerator recipientInfoGen = new JceKeyTransRecipientInfoGenerator((X509Certificate)chain[0]);
            smeg.addRecipientInfoGenerator((RecipientInfoGenerator)recipientInfoGen);
            OutputEncryptor encryptor = new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC).build();
            MimeBodyPart mbp = smeg.generate(message, encryptor);
            smimeEncryptedMsg = new MimeMessage(mailSession);
            Enumeration hdrLines = message.getAllHeaderLines();
            while (hdrLines.hasMoreElements()) {
                smimeEncryptedMsg.addHeaderLine((String)hdrLines.nextElement());
            }
            smimeEncryptedMsg.setContent(mbp.getContent(), mbp.getContentType());
            smimeEncryptedMsg.saveChanges();
        }
        catch (Exception e) {
            throw new SystemException("Can't encrypt message.", (Throwable)e);
        }
        return smimeEncryptedMsg;
    }

    public static MimeMessage signMessageWithKeystore(MimeMessage message, Session mailSession, String keyfile, String password) {
        return MailUtils.pSignMessageWithKeystore(message, mailSession, keyfile, password);
    }

    private static MimeMessage pSignMessageWithKeystore(MimeMessage message, Session mailSession, String keyfile, String password) {
        MimeMessage signedMessage = null;
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            String keyAlias = ExampleUtils.findKeyAlias((KeyStore)keyStore, (String)keyfile, (char[])password.toCharArray());
            Certificate[] chain = keyStore.getCertificateChain(keyAlias);
            SMIMECapabilityVector capabilities = new SMIMECapabilityVector();
            capabilities.addCapability(SMIMECapability.dES_EDE3_CBC);
            capabilities.addCapability(SMIMECapability.rC2_CBC, 128);
            capabilities.addCapability(SMIMECapability.dES_CBC);
            ASN1EncodableVector attributes = new ASN1EncodableVector();
            X500Name name = new X500Name(((X509Certificate)chain[0]).getIssuerDN().getName());
            BigInteger serial = ((X509Certificate)chain[0]).getSerialNumber();
            IssuerAndSerialNumber issAndSer = new IssuerAndSerialNumber(name, serial);
            attributes.add((ASN1Encodable)new SMIMEEncryptionKeyPreferenceAttribute(issAndSer));
            attributes.add((ASN1Encodable)new SMIMECapabilitiesAttribute(capabilities));
            SMIMESignedGenerator signer = new SMIMESignedGenerator();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, password.toCharArray());
            signer.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(attributes)).build("SHA1withRSA", privateKey, (X509Certificate)chain[0]));
            MimeMultipart mimeMultiPart = signer.generate(message);
            signedMessage = new MimeMessage(mailSession);
            Enumeration headers = message.getAllHeaderLines();
            while (headers.hasMoreElements()) {
                signedMessage.addHeaderLine((String)headers.nextElement());
            }
            signedMessage.setContent((Multipart)mimeMultiPart);
            signedMessage.saveChanges();
        }
        catch (Exception e) {
            throw new SystemException("Can't sign message.", (Throwable)e);
        }
        return signedMessage;
    }

    public static MimeMessage decryptMessageWithKeystore(MimeMessage message, Session mailSession, String keyfile, String password) {
        return MailUtils.pDecryptMessageWithKeystore(message, mailSession, keyfile, password);
    }

    private static MimeMessage pDecryptMessageWithKeystore(MimeMessage message, Session mailSession, String keyfile, String password) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            String keyAlias = ExampleUtils.findKeyAlias((KeyStore)keyStore, (String)keyfile, (char[])password.toCharArray());
            Certificate[] chain = keyStore.getCertificateChain(keyAlias);
            X509Certificate cert = (X509Certificate)chain[0];
            JceKeyTransRecipientId recId = new JceKeyTransRecipientId(cert);
            Key privateKey = keyStore.getKey(keyAlias, password.toCharArray());
            SMIMEEnveloped smimeEnveloped = new SMIMEEnveloped(message);
            RecipientInformationStore recipients = smimeEnveloped.getRecipientInfos();
            RecipientInformation recipient = recipients.get((RecipientId)recId);
            if (recipient == null) {
                throw new MessagingException("no recipient");
            }
            MimeBodyPart mbp = SMIMEUtil.toMimeBodyPart((byte[])recipient.getContent((Recipient)new JceKeyTransEnvelopedRecipient((PrivateKey)privateKey).setProvider("BC")));
            MimeMessage decryptedMessage = new MimeMessage(mailSession);
            Enumeration hLineEnum = message.getAllHeaderLines();
            while (hLineEnum.hasMoreElements()) {
                decryptedMessage.addHeaderLine((String)hLineEnum.nextElement());
            }
            MimeMultipart multiPart = new MimeMultipart();
            multiPart.addBodyPart((BodyPart)mbp);
            decryptedMessage.setContent((Multipart)multiPart);
            decryptedMessage.saveChanges();
            return decryptedMessage;
        }
        catch (Exception e) {
            throw new SystemException("Can't decrypt message", (Throwable)e);
        }
    }

    public static void encryptAndSaveEmail(MimeMessage message, Session mailsession, String keyfile, String password, String filename) {
        MailUtils.pEncryptAndSaveEmail(message, mailsession, keyfile, password, filename);
    }

    private static void pEncryptAndSaveEmail(MimeMessage message, Session mailsession, String keyfile, String password, String filename) {
        MimeMessage mimeMessage = MailUtils.pEncryptMessageWithKeystore(message, mailsession, keyfile, password);
        MailUtils.pSaveEmail((Message)mimeMessage, filename);
    }

    public static String[] getEmailHeaders(MimeMessage message) {
        return MailUtils.pGetEmailHeaders(message);
    }

    private static String[] pGetEmailHeaders(MimeMessage message) {
        ArrayList<String> headersAsStrings;
        try {
            Enumeration headers = message.getAllHeaderLines();
            headersAsStrings = new ArrayList<String>();
            while (headers.hasMoreElements()) {
                headersAsStrings.add((String)headers.nextElement());
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        return headersAsStrings.toArray(new String[headersAsStrings.size()]);
    }

    public static MimeMessage setMimeMessageHeaders(MimeMessage message, String subject, Address[] fromAddresses, String sender, Address[] toAddresses, Address[] ccAddresses, Address[] bccAddresses) {
        return MailUtils.pSetMimeMessageHeaders(message, subject, fromAddresses, sender, toAddresses, ccAddresses, bccAddresses);
    }

    private static MimeMessage pSetMimeMessageHeaders(MimeMessage message, String subject, Address[] fromAddresses, String sender, Address[] toAddresses, Address[] ccAddresses, Address[] bccAddresses) {
        try {
            if (subject != null && subject.length() > 0) {
                message.setSubject(subject);
            }
            if (fromAddresses != null && fromAddresses.length != 0) {
                message.removeHeader("From");
                message.addFrom(fromAddresses);
            }
            if (sender != null && !"".equals(sender)) {
                message.setHeader("Sender", sender);
            }
            if (toAddresses != null && toAddresses.length > 0) {
                message.removeHeader("To");
                message.addRecipients(Message.RecipientType.TO, toAddresses);
            }
            if (ccAddresses != null && ccAddresses.length > 0) {
                message.addRecipients(Message.RecipientType.CC, ccAddresses);
            }
            if (bccAddresses != null && bccAddresses.length > 0) {
                message.addRecipients(Message.RecipientType.BCC, bccAddresses);
            }
            message.saveChanges();
        }
        catch (MessagingException e) {
            LOGGER.error(e.getMessage());
        }
        return message;
    }
}

