/*
 * Decompiled with CFR 0.152.
 */
package io.trino.array;

import io.trino.array.ByteBigArray;
import java.util.Arrays;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestByteBigArray {
    @Test
    public void testFill() {
        ByteBigArray array = new ByteBigArray();
        TestByteBigArray.assertFillCapacity(array, 0L, (byte)1);
        TestByteBigArray.assertFillCapacity(array, 1L, (byte)2);
        TestByteBigArray.assertFillCapacity(array, 1000L, (byte)3);
        TestByteBigArray.assertFillCapacity(array, 1024L, (byte)4);
        TestByteBigArray.assertFillCapacity(array, 1025L, (byte)5);
    }

    private static void assertFillCapacity(ByteBigArray array, long capacity, byte value) {
        array.ensureCapacity(capacity);
        array.fill(value);
        int i = 0;
        while ((long)i < capacity) {
            Assert.assertEquals((byte)array.get((long)i), (byte)value);
            ++i;
        }
    }

    @Test
    public void testCopyTo() {
        ByteBigArray source = new ByteBigArray();
        ByteBigArray destination = new ByteBigArray();
        Iterator<Integer> iterator = Arrays.asList(0, 1, 1024, 1025).iterator();
        while (iterator.hasNext()) {
            long sourceIndex = iterator.next().intValue();
            Iterator<Integer> iterator2 = Arrays.asList(0, 1, 1024, 1025).iterator();
            while (iterator2.hasNext()) {
                long destinationIndex = iterator2.next().intValue();
                Iterator<Integer> iterator3 = Arrays.asList(0, 1, 1024, 1025).iterator();
                while (iterator3.hasNext()) {
                    long length = iterator3.next().intValue();
                    TestByteBigArray.assertCopyTo(source, sourceIndex, destination, destinationIndex, length);
                }
            }
        }
    }

    private static void assertCopyTo(ByteBigArray source, long sourceIndex, ByteBigArray destination, long destinationIndex, long length) {
        long i;
        long sourceCapacity = sourceIndex + length;
        source.ensureCapacity(sourceCapacity);
        long destinationCapacity = destinationIndex + length + 1L;
        destination.ensureCapacity(destinationCapacity);
        byte destinationFillValue = -1;
        destination.fill(destinationFillValue);
        for (i = 0L; i < sourceCapacity; ++i) {
            source.set(i, (byte)i);
        }
        source.copyTo(sourceIndex, destination, destinationIndex, length);
        for (i = 0L; i < destinationIndex; ++i) {
            Assert.assertEquals((byte)destination.get(i), (byte)destinationFillValue);
        }
        for (i = 0L; i < length; ++i) {
            Assert.assertEquals((byte)source.get(sourceIndex + i), (byte)destination.get(destinationIndex + i));
        }
        for (i = destinationIndex + length; i < destinationCapacity; ++i) {
            Assert.assertEquals((byte)destination.get(i), (byte)destinationFillValue);
        }
    }
}

