/*
 * Decompiled with CFR 0.152.
 */
package io.trino.array;

import io.trino.array.ShortBigArray;
import java.util.Arrays;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestShortBigArray {
    @Test
    public void testFill() {
        ShortBigArray array = new ShortBigArray();
        TestShortBigArray.assertFillCapacity(array, 0L, (short)1);
        TestShortBigArray.assertFillCapacity(array, 1L, (short)2);
        TestShortBigArray.assertFillCapacity(array, 1000L, (short)3);
        TestShortBigArray.assertFillCapacity(array, 1024L, (short)4);
        TestShortBigArray.assertFillCapacity(array, 1025L, (short)5);
    }

    private static void assertFillCapacity(ShortBigArray array, long capacity, short value) {
        array.ensureCapacity(capacity);
        array.fill(value);
        int i = 0;
        while ((long)i < capacity) {
            Assert.assertEquals((short)array.get((long)i), (short)value);
            ++i;
        }
    }

    @Test
    public void testCopyTo() {
        ShortBigArray source = new ShortBigArray();
        ShortBigArray destination = new ShortBigArray();
        Iterator<Integer> iterator = Arrays.asList(0, 1, 1024, 1025).iterator();
        while (iterator.hasNext()) {
            long sourceIndex = iterator.next().intValue();
            Iterator<Integer> iterator2 = Arrays.asList(0, 1, 1024, 1025).iterator();
            while (iterator2.hasNext()) {
                long destinationIndex = iterator2.next().intValue();
                Iterator<Integer> iterator3 = Arrays.asList(0, 1, 1024, 1025).iterator();
                while (iterator3.hasNext()) {
                    long length = iterator3.next().intValue();
                    TestShortBigArray.assertCopyTo(source, sourceIndex, destination, destinationIndex, length);
                }
            }
        }
    }

    private static void assertCopyTo(ShortBigArray source, long sourceIndex, ShortBigArray destination, long destinationIndex, long length) {
        long i;
        long sourceCapacity = sourceIndex + length;
        source.ensureCapacity(sourceCapacity);
        long destinationCapacity = destinationIndex + length + 1L;
        destination.ensureCapacity(destinationCapacity);
        short destinationFillValue = -1;
        destination.fill(destinationFillValue);
        for (i = 0L; i < sourceCapacity; ++i) {
            source.set(i, (short)i);
        }
        source.copyTo(sourceIndex, destination, destinationIndex, length);
        for (i = 0L; i < destinationIndex; ++i) {
            Assert.assertEquals((short)destination.get(i), (short)destinationFillValue);
        }
        for (i = 0L; i < length; ++i) {
            Assert.assertEquals((short)source.get(sourceIndex + i), (short)destination.get(destinationIndex + i));
        }
        for (i = destinationIndex + length; i < destinationCapacity; ++i) {
            Assert.assertEquals((short)destination.get(i), (short)destinationFillValue);
        }
    }
}

