/*
 * Decompiled with CFR 0.152.
 */
package io.trino.array;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.array.ReferenceCountMap;
import io.trino.jmh.Benchmarks;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.WarmupMode;

@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=4)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class BenchmarkReferenceCountMap {
    private static final int NUMBER_OF_ENTRIES = 1000000;
    private static final int NUMBER_OF_BASES = 100;

    @Benchmark
    @OperationsPerInvocation(value=1000000)
    public ReferenceCountMap benchmarkInserts(Data data) {
        ReferenceCountMap map = new ReferenceCountMap();
        for (int i = 0; i < 1000000; ++i) {
            map.incrementAndGet((Object)data.slices[i]);
            map.incrementAndGet(data.slices[i].getBase());
        }
        return map;
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkReferenceCountMap.class, (WarmupMode)WarmupMode.BULK).withOptions(optionsBuilder -> optionsBuilder.addProfiler(GCProfiler.class).jvmArgs(new String[]{"-XX:+UseG1GC"})).run();
    }

    @State(value=Scope.Thread)
    public static class Data {
        @Param(value={"int", "double", "long", "byte"})
        private String arrayType = "int";
        private Object[] bases = new Object[100];
        private Slice[] slices = new Slice[1000000];

        @Setup
        public void setup() {
            int i;
            block24: for (i = 0; i < 100; ++i) {
                switch (this.arrayType) {
                    case "int": {
                        this.bases[i] = new int[ThreadLocalRandom.current().nextInt(100)];
                        continue block24;
                    }
                    case "double": {
                        this.bases[i] = new double[ThreadLocalRandom.current().nextInt(100)];
                        continue block24;
                    }
                    case "long": {
                        this.bases[i] = new long[ThreadLocalRandom.current().nextInt(100)];
                        continue block24;
                    }
                    case "byte": {
                        this.bases[i] = new byte[ThreadLocalRandom.current().nextInt(100)];
                        continue block24;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            block25: for (i = 0; i < 1000000; ++i) {
                Object base = this.bases[ThreadLocalRandom.current().nextInt(100)];
                switch (this.arrayType) {
                    case "int": {
                        int[] intBase = (int[])base;
                        this.slices[i] = Slices.wrappedIntArray((int[])intBase, (int)0, (int)intBase.length);
                        continue block25;
                    }
                    case "double": {
                        double[] doubleBase = (double[])base;
                        this.slices[i] = Slices.wrappedDoubleArray((double[])doubleBase, (int)0, (int)doubleBase.length);
                        continue block25;
                    }
                    case "long": {
                        long[] longBase = (long[])base;
                        this.slices[i] = Slices.wrappedLongArray((long[])longBase, (int)0, (int)longBase.length);
                        continue block25;
                    }
                    case "byte": {
                        byte[] byteBase = (byte[])base;
                        this.slices[i] = Slices.wrappedBuffer((byte[])byteBase, (int)0, (int)byteBase.length);
                        continue block25;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }
    }
}

