/*
 * Decompiled with CFR 0.152.
 */
package io.trino.array;

import io.trino.array.BooleanBigArray;
import java.util.Arrays;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBooleanBigArray {
    @Test
    public void testFill() {
        BooleanBigArray array = new BooleanBigArray();
        TestBooleanBigArray.assertFillCapacity(array, 0L, true);
        TestBooleanBigArray.assertFillCapacity(array, 1L, false);
        TestBooleanBigArray.assertFillCapacity(array, 1000L, true);
        TestBooleanBigArray.assertFillCapacity(array, 1024L, false);
        TestBooleanBigArray.assertFillCapacity(array, 1025L, true);
    }

    private static void assertFillCapacity(BooleanBigArray array, long capacity, boolean value) {
        array.ensureCapacity(capacity);
        array.fill(value);
        int i = 0;
        while ((long)i < capacity) {
            Assert.assertEquals((boolean)array.get((long)i), (boolean)value);
            ++i;
        }
    }

    @Test
    public void testCopyTo() {
        BooleanBigArray source = new BooleanBigArray();
        BooleanBigArray destination = new BooleanBigArray();
        Iterator<Integer> iterator = Arrays.asList(0, 1, 1024, 1025).iterator();
        while (iterator.hasNext()) {
            long sourceIndex = iterator.next().intValue();
            Iterator<Integer> iterator2 = Arrays.asList(0, 1, 1024, 1025).iterator();
            while (iterator2.hasNext()) {
                long destinationIndex = iterator2.next().intValue();
                Iterator<Integer> iterator3 = Arrays.asList(0, 1, 1024, 1025).iterator();
                while (iterator3.hasNext()) {
                    long length = iterator3.next().intValue();
                    TestBooleanBigArray.assertCopyTo(source, sourceIndex, destination, destinationIndex, length);
                }
            }
        }
    }

    private static void assertCopyTo(BooleanBigArray source, long sourceIndex, BooleanBigArray destination, long destinationIndex, long length) {
        long i;
        long sourceCapacity = sourceIndex + length;
        source.ensureCapacity(sourceCapacity);
        long destinationCapacity = destinationIndex + length + 1L;
        destination.ensureCapacity(destinationCapacity);
        boolean destinationFillValue = true;
        destination.fill(destinationFillValue);
        for (i = 0L; i < sourceCapacity; ++i) {
            source.set(i, i % 2L == 0L);
        }
        source.copyTo(sourceIndex, destination, destinationIndex, length);
        for (i = 0L; i < destinationIndex; ++i) {
            Assert.assertEquals((boolean)destination.get(i), (boolean)destinationFillValue);
        }
        for (i = 0L; i < length; ++i) {
            Assert.assertEquals((boolean)source.get(sourceIndex + i), (boolean)destination.get(destinationIndex + i));
        }
        for (i = destinationIndex + length; i < destinationCapacity; ++i) {
            Assert.assertEquals((boolean)destination.get(i), (boolean)destinationFillValue);
        }
    }
}

