/*
 * Decompiled with CFR 0.152.
 */
package io.trino.array;

import io.trino.array.DoubleBigArray;
import java.util.Arrays;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDoubleBigArray {
    @Test
    public void testFill() {
        DoubleBigArray array = new DoubleBigArray();
        TestDoubleBigArray.assertFillCapacity(array, 0L, 0.1);
        TestDoubleBigArray.assertFillCapacity(array, 1L, 0.2);
        TestDoubleBigArray.assertFillCapacity(array, 1000L, 0.3);
        TestDoubleBigArray.assertFillCapacity(array, 1024L, 0.4);
        TestDoubleBigArray.assertFillCapacity(array, 1025L, 0.5);
    }

    private static void assertFillCapacity(DoubleBigArray array, long capacity, double value) {
        array.ensureCapacity(capacity);
        array.fill(value);
        int i = 0;
        while ((long)i < capacity) {
            Assert.assertEquals((Object)array.get((long)i), (Object)value);
            ++i;
        }
    }

    @Test
    public void testCopyTo() {
        DoubleBigArray source = new DoubleBigArray();
        DoubleBigArray destination = new DoubleBigArray();
        Iterator<Integer> iterator = Arrays.asList(0, 1, 1024, 1025).iterator();
        while (iterator.hasNext()) {
            long sourceIndex = iterator.next().intValue();
            Iterator<Integer> iterator2 = Arrays.asList(0, 1, 1024, 1025).iterator();
            while (iterator2.hasNext()) {
                long destinationIndex = iterator2.next().intValue();
                Iterator<Integer> iterator3 = Arrays.asList(0, 1, 1024, 1025).iterator();
                while (iterator3.hasNext()) {
                    long length = iterator3.next().intValue();
                    TestDoubleBigArray.assertCopyTo(source, sourceIndex, destination, destinationIndex, length);
                }
            }
        }
    }

    private static void assertCopyTo(DoubleBigArray source, long sourceIndex, DoubleBigArray destination, long destinationIndex, long length) {
        long i;
        long sourceCapacity = sourceIndex + length;
        source.ensureCapacity(sourceCapacity);
        long destinationCapacity = destinationIndex + length + 1L;
        destination.ensureCapacity(destinationCapacity);
        double destinationFillValue = -0.1;
        destination.fill(destinationFillValue);
        for (i = 0L; i < sourceCapacity; ++i) {
            source.set(i, (double)i);
        }
        source.copyTo(sourceIndex, destination, destinationIndex, length);
        for (i = 0L; i < destinationIndex; ++i) {
            Assert.assertEquals((Object)destination.get(i), (Object)destinationFillValue);
        }
        for (i = 0L; i < length; ++i) {
            Assert.assertEquals((Object)source.get(sourceIndex + i), (Object)destination.get(destinationIndex + i));
        }
        for (i = destinationIndex + length; i < destinationCapacity; ++i) {
            Assert.assertEquals((Object)destination.get(i), (Object)destinationFillValue);
        }
    }
}

