/*
 * Decompiled with CFR 0.152.
 */
package io.trino.array;

import io.trino.array.IntBigArray;
import java.util.Arrays;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestIntBigArray {
    @Test
    public void testFill() {
        IntBigArray array = new IntBigArray();
        TestIntBigArray.assertFillCapacity(array, 0L, 1);
        TestIntBigArray.assertFillCapacity(array, 1L, 2);
        TestIntBigArray.assertFillCapacity(array, 1000L, 3);
        TestIntBigArray.assertFillCapacity(array, 1024L, 4);
        TestIntBigArray.assertFillCapacity(array, 1025L, 5);
    }

    private static void assertFillCapacity(IntBigArray array, long capacity, int value) {
        array.ensureCapacity(capacity);
        array.fill(value);
        int i = 0;
        while ((long)i < capacity) {
            Assert.assertEquals((int)array.get((long)i), (int)value);
            ++i;
        }
    }

    @Test
    public void testCopyTo() {
        IntBigArray source = new IntBigArray();
        IntBigArray destination = new IntBigArray();
        Iterator<Integer> iterator = Arrays.asList(0, 1, 1024, 1025).iterator();
        while (iterator.hasNext()) {
            long sourceIndex = iterator.next().intValue();
            Iterator<Integer> iterator2 = Arrays.asList(0, 1, 1024, 1025).iterator();
            while (iterator2.hasNext()) {
                long destinationIndex = iterator2.next().intValue();
                Iterator<Integer> iterator3 = Arrays.asList(0, 1, 1024, 1025).iterator();
                while (iterator3.hasNext()) {
                    long length = iterator3.next().intValue();
                    TestIntBigArray.assertCopyTo(source, sourceIndex, destination, destinationIndex, length);
                }
            }
        }
    }

    private static void assertCopyTo(IntBigArray source, long sourceIndex, IntBigArray destination, long destinationIndex, long length) {
        long i;
        long sourceCapacity = sourceIndex + length;
        source.ensureCapacity(sourceCapacity);
        long destinationCapacity = destinationIndex + length + 1L;
        destination.ensureCapacity(destinationCapacity);
        int destinationFillValue = -1;
        destination.fill(destinationFillValue);
        for (i = 0L; i < sourceCapacity; ++i) {
            source.set(i, (int)i);
        }
        source.copyTo(sourceIndex, destination, destinationIndex, length);
        for (i = 0L; i < destinationIndex; ++i) {
            Assert.assertEquals((int)destination.get(i), (int)destinationFillValue);
        }
        for (i = 0L; i < length; ++i) {
            Assert.assertEquals((int)source.get(sourceIndex + i), (int)destination.get(destinationIndex + i));
        }
        for (i = destinationIndex + length; i < destinationCapacity; ++i) {
            Assert.assertEquals((int)destination.get(i), (int)destinationFillValue);
        }
    }
}

