/*
 * Decompiled with CFR 0.152.
 */
package io.trino.array;

import io.trino.array.LongBigArray;
import java.util.Arrays;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLongBigArray {
    @Test
    public void testFill() {
        LongBigArray array = new LongBigArray();
        TestLongBigArray.assertFillCapacity(array, 0L, 1L);
        TestLongBigArray.assertFillCapacity(array, 1L, 2L);
        TestLongBigArray.assertFillCapacity(array, 1000L, 3L);
        TestLongBigArray.assertFillCapacity(array, 1024L, 4L);
        TestLongBigArray.assertFillCapacity(array, 1025L, 5L);
    }

    private static void assertFillCapacity(LongBigArray array, long capacity, long value) {
        array.ensureCapacity(capacity);
        array.fill(value);
        int i = 0;
        while ((long)i < capacity) {
            Assert.assertEquals((long)array.get((long)i), (long)value);
            ++i;
        }
    }

    @Test
    public void testCopyTo() {
        LongBigArray source = new LongBigArray();
        LongBigArray destination = new LongBigArray();
        Iterator<Integer> iterator = Arrays.asList(0, 1, 1024, 1025).iterator();
        while (iterator.hasNext()) {
            long sourceIndex = iterator.next().intValue();
            Iterator<Integer> iterator2 = Arrays.asList(0, 1, 1024, 1025).iterator();
            while (iterator2.hasNext()) {
                long destinationIndex = iterator2.next().intValue();
                Iterator<Integer> iterator3 = Arrays.asList(0, 1, 1024, 1025).iterator();
                while (iterator3.hasNext()) {
                    long length = iterator3.next().intValue();
                    TestLongBigArray.assertCopyTo(source, sourceIndex, destination, destinationIndex, length);
                }
            }
        }
    }

    private static void assertCopyTo(LongBigArray source, long sourceIndex, LongBigArray destination, long destinationIndex, long length) {
        long i;
        long sourceCapacity = sourceIndex + length;
        source.ensureCapacity(sourceCapacity);
        long destinationCapacity = destinationIndex + length + 1L;
        destination.ensureCapacity(destinationCapacity);
        long destinationFillValue = -1L;
        destination.fill(destinationFillValue);
        for (i = 0L; i < sourceCapacity; ++i) {
            source.set(i, i);
        }
        source.copyTo(sourceIndex, destination, destinationIndex, length);
        for (i = 0L; i < destinationIndex; ++i) {
            Assert.assertEquals((long)destination.get(i), (long)destinationFillValue);
        }
        for (i = 0L; i < length; ++i) {
            Assert.assertEquals((long)source.get(sourceIndex + i), (long)destination.get(destinationIndex + i));
        }
        for (i = destinationIndex + length; i < destinationCapacity; ++i) {
            Assert.assertEquals((long)destination.get(i), (long)destinationFillValue);
        }
    }
}

