/*
 * Decompiled with CFR 0.152.
 */
package io.trino.array;

import io.trino.array.ObjectBigArray;
import java.util.Arrays;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestObjectBigArray {
    @Test
    public void testFill() {
        ObjectBigArray array = new ObjectBigArray();
        TestObjectBigArray.assertFillCapacity(array, 0L, "a");
        TestObjectBigArray.assertFillCapacity(array, 1L, "b");
        TestObjectBigArray.assertFillCapacity(array, 1000L, "c");
        TestObjectBigArray.assertFillCapacity(array, 1024L, "d");
        TestObjectBigArray.assertFillCapacity(array, 1025L, "e");
    }

    private static <T> void assertFillCapacity(ObjectBigArray<T> array, long capacity, T value) {
        array.ensureCapacity(capacity);
        array.fill(value);
        int i = 0;
        while ((long)i < capacity) {
            Assert.assertEquals((Object)array.get((long)i), value);
            ++i;
        }
    }

    @Test
    public void testCopyTo() {
        ObjectBigArray source = new ObjectBigArray();
        ObjectBigArray destination = new ObjectBigArray();
        Iterator<Integer> iterator = Arrays.asList(0, 1, 1024, 1025).iterator();
        while (iterator.hasNext()) {
            long sourceIndex = iterator.next().intValue();
            Iterator<Integer> iterator2 = Arrays.asList(0, 1, 1024, 1025).iterator();
            while (iterator2.hasNext()) {
                long destinationIndex = iterator2.next().intValue();
                Iterator<Integer> iterator3 = Arrays.asList(0, 1, 1024, 1025).iterator();
                while (iterator3.hasNext()) {
                    long length = iterator3.next().intValue();
                    TestObjectBigArray.assertCopyTo((ObjectBigArray<String>)source, sourceIndex, (ObjectBigArray<String>)destination, destinationIndex, length);
                }
            }
        }
    }

    private static void assertCopyTo(ObjectBigArray<String> source, long sourceIndex, ObjectBigArray<String> destination, long destinationIndex, long length) {
        long i;
        long sourceCapacity = sourceIndex + length;
        source.ensureCapacity(sourceCapacity);
        long destinationCapacity = destinationIndex + length + 1L;
        destination.ensureCapacity(destinationCapacity);
        String destinationFillValue = "a";
        destination.fill((Object)destinationFillValue);
        for (i = 0L; i < sourceCapacity; ++i) {
            source.set(i, (Object)Long.toString(i));
        }
        source.copyTo(sourceIndex, destination, destinationIndex, length);
        for (i = 0L; i < destinationIndex; ++i) {
            Assert.assertEquals((String)((String)destination.get(i)), (String)destinationFillValue);
        }
        for (i = 0L; i < length; ++i) {
            Assert.assertEquals((String)((String)source.get(sourceIndex + i)), (String)((String)destination.get(destinationIndex + i)));
        }
        for (i = destinationIndex + length; i < destinationCapacity; ++i) {
            Assert.assertEquals((String)((String)destination.get(i)), (String)destinationFillValue);
        }
    }
}

