/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.jdbc.BaseCaseInsensitiveMappingTest;
import io.trino.plugin.jdbc.mapping.RuleBasedIdentifierMappingUtils;
import io.trino.plugin.oracle.OracleQueryRunner;
import io.trino.plugin.oracle.TestingOracleServer;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.SqlExecutor;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestOracleCaseInsensitiveMapping
extends BaseCaseInsensitiveMappingTest {
    private Path mappingFile;
    private TestingOracleServer oracleServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.mappingFile = RuleBasedIdentifierMappingUtils.createRuleBasedIdentifierMappingFile();
        this.oracleServer = (TestingOracleServer)this.closeAfterClass(new TestingOracleServer());
        return OracleQueryRunner.createOracleQueryRunner(this.oracleServer, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.builder().putAll(OracleQueryRunner.connectionProperties(this.oracleServer)).put((Object)"case-insensitive-name-matching", (Object)"true").put((Object)"case-insensitive-name-matching.config-file", (Object)this.mappingFile.toFile().getAbsolutePath()).put((Object)"case-insensitive-name-matching.config-file.refresh-period", (Object)RuleBasedIdentifierMappingUtils.REFRESH_PERIOD_DURATION.toString()).buildOrThrow(), ImmutableList.of());
    }

    protected Path getMappingFile() {
        return Objects.requireNonNull(this.mappingFile, "mappingFile is null");
    }

    protected Optional<String> optionalFromDual() {
        return Optional.of("FROM dual");
    }

    protected AutoCloseable withSchema(String schemaName) {
        this.onRemoteDatabase().execute(String.format("CREATE USER %s IDENTIFIED BY SCM", this.quoted(schemaName)));
        this.onRemoteDatabase().execute(String.format("GRANT UNLIMITED TABLESPACE TO %s", this.quoted(schemaName)));
        return () -> this.onRemoteDatabase().execute("DROP USER " + this.quoted(schemaName));
    }

    protected AutoCloseable withTable(String remoteSchemaName, String remoteTableName, String tableDefinition) {
        String schemaName = this.quoted(remoteSchemaName);
        if (remoteSchemaName.equalsIgnoreCase("trino_test")) {
            schemaName = remoteSchemaName;
        }
        String quotedName = schemaName + "." + this.quoted(remoteTableName);
        this.onRemoteDatabase().execute(String.format("CREATE TABLE %s %s", quotedName, tableDefinition));
        return () -> this.onRemoteDatabase().execute("DROP TABLE " + quotedName);
    }

    protected SqlExecutor onRemoteDatabase() {
        return Objects.requireNonNull(this.oracleServer, "oracleServer is null")::execute;
    }

    @Test
    public void forceTestNgToRespectSingleThreaded() {
    }
}

